/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.api.entity;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import thecodex6824.thaumicaugmentation.api.block.property.IPortalBlock;
import thecodex6824.thaumicaugmentation.api.entity.CapabilityPortalState;
import thecodex6824.thaumicaugmentation.api.entity.IPortalEntity;
import thecodex6824.thaumicaugmentation.api.entity.IPortalState;

public final class PortalStateManager {
    private static final Object2IntOpenHashMap<Entity> TRACKED = new Object2IntOpenHashMap();

    private PortalStateManager() {
    }

    public static void markEntityInPortal(Entity entity) {
        IPortalState state = (IPortalState)entity.getCapability(CapabilityPortalState.PORTAL_STATE, null);
        if (state != null && !TRACKED.containsKey((Object)entity)) {
            state.setInPortal(true);
            TRACKED.put((Object)entity, 20);
        }
    }

    private static boolean findPortalBlock(Entity entity) {
        AxisAlignedBB box = entity.func_174813_aQ();
        if (box != null) {
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(0, 0, 0);
            int x = (int)Math.floor(box.field_72340_a);
            while ((double)x < Math.ceil(box.field_72336_d)) {
                int z = (int)Math.floor(box.field_72339_c);
                while ((double)z < Math.ceil(box.field_72334_f)) {
                    pos.func_181079_c(x, 0, z);
                    int y = (int)Math.floor(box.field_72338_b);
                    while ((double)y < Math.ceil(box.field_72337_e)) {
                        IBlockState state;
                        if (entity.func_130014_f_().func_175667_e((BlockPos)pos) && ((state = entity.func_130014_f_().func_180495_p((BlockPos)pos)).func_177228_b().containsKey((Object)IPortalBlock.PORTAL) && ((Boolean)state.func_177229_b((IProperty)IPortalBlock.PORTAL)).booleanValue() || !state.func_177228_b().containsKey((Object)IPortalBlock.PORTAL) && state.func_177230_c() instanceof IPortalBlock)) {
                            return true;
                        }
                        ++y;
                    }
                    ++z;
                }
                ++x;
            }
        }
        return false;
    }

    private static boolean findPortalEntity(Entity entity) {
        AxisAlignedBB box = entity.func_174813_aQ();
        if (box != null) {
            for (Entity other : entity.func_130014_f_().func_72872_a(Entity.class, box)) {
                if (other == entity || !(other instanceof IPortalEntity)) continue;
                return true;
            }
        }
        return false;
    }

    public static void tick() {
        if (!TRACKED.isEmpty()) {
            ArrayList<Entity> toGetRidOf = new ArrayList<Entity>();
            for (Entity entity : TRACKED.keySet()) {
                if (!PortalStateManager.findPortalBlock(entity) && !PortalStateManager.findPortalEntity(entity)) {
                    if (TRACKED.addTo((Object)entity, -1) != 1) continue;
                    IPortalState state = (IPortalState)entity.getCapability(CapabilityPortalState.PORTAL_STATE, null);
                    if (state != null) {
                        state.setInPortal(false);
                    }
                    toGetRidOf.add(entity);
                    continue;
                }
                TRACKED.put((Object)entity, 20);
            }
            for (Entity e : toGetRidOf) {
                TRACKED.removeInt((Object)e);
            }
        }
    }
}

