/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.api.augment;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import thecodex6824.thaumicaugmentation.api.util.DamageWrapper;
import thecodex6824.thaumicaugmentation.api.util.FocusWrapper;

public interface IAugment {
    default public void onEquip(Entity user) {
    }

    default public void onUnequip(Entity user) {
    }

    default public boolean onCastPre(ItemStack caster, FocusWrapper focus, Entity user) {
        return false;
    }

    default public void onCastPost(ItemStack caster, FocusWrapper focus, Entity user) {
    }

    default public boolean onTick(Entity user) {
        return false;
    }

    default public boolean onHurtEntity(DamageSource source, Entity attacked, DamageWrapper damage) {
        return false;
    }

    default public boolean onDamagedEntity(DamageSource source, Entity attacked, DamageWrapper damage) {
        return false;
    }

    default public boolean onHurt(Entity attacked, DamageSource source, DamageWrapper damage) {
        return false;
    }

    default public boolean onDamaged(Entity attacked, DamageSource source, DamageWrapper damage) {
        return false;
    }

    default public boolean onInteractEntity(Entity user, ItemStack used, Entity target, EnumHand hand) {
        return false;
    }

    default public boolean onInteractBlock(Entity user, ItemStack used, BlockPos target, EnumFacing face, EnumHand hand) {
        return false;
    }

    default public boolean onInteractAir(Entity user, ItemStack used, EnumHand hand) {
        return false;
    }

    default public boolean onUseItem(Entity user, ItemStack used) {
        return false;
    }

    default public boolean isCompatible(ItemStack otherAugment) {
        return true;
    }

    default public boolean canBeAppliedToItem(ItemStack augmentable) {
        return true;
    }

    default public boolean hasAdditionalAugmentTooltip() {
        return false;
    }

    default public void appendAdditionalAugmentTooltip(List<String> tooltip) {
    }

    default public boolean shouldSync() {
        return false;
    }

    default public boolean shouldAllowDefaultAddition() {
        return true;
    }

    default public boolean shouldAllowDefaultRemoval() {
        return true;
    }
}

