/*
 * Decompiled with CFR 0.152.
 */
package erebus.world.feature.tree;

import erebus.ModBlocks;
import erebus.ModFluids;
import erebus.ModItems;
import erebus.block.bamboo.BlockBambooTorch;
import erebus.blocks.BlockDoorErebus;
import erebus.blocks.BlockLeavesErebus;
import erebus.blocks.BlockLogErebus;
import erebus.blocks.BlockStairsErebus;
import erebus.blocks.EnumWood;
import erebus.entity.EntityTarantulaMiniboss;
import erebus.items.ItemErebusFood;
import erebus.items.ItemMaterials;
import erebus.world.feature.structure.worlddata.WorldDataGiantEucalyptus;
import erebus.world.loot.IPostProcess;
import erebus.world.loot.LootItemStack;
import erebus.world.loot.LootUtil;
import erebus.world.loot.WeightedLootList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class WorldGenGiantEucalyptus
extends WorldGenerator {
    public int height = 28;
    public int baseRadius = 14;
    public int direction = -1;
    public IBlockState STAIRS = EnumWood.EUCALYPTUS.getStairs().func_176223_P();
    public IBlockState LOG = EnumWood.EUCALYPTUS.getLog().func_176223_P();
    public IBlockState LEAVES = EnumWood.EUCALYPTUS.getLeaves().func_176223_P().func_177226_a((IProperty)BlockLeavesErebus.field_176236_b, (Comparable)Boolean.valueOf(false));
    public IBlockState FENCE = EnumWood.EUCALYPTUS.getFence().func_176223_P();
    public IBlockState DOOR = EnumWood.EUCALYPTUS.getDoor().func_176223_P();
    public static IBlockState BAMBOO_TORCH_LOWER = ModBlocks.BAMBOO_TORCH.func_176223_P().func_177226_a(BlockBambooTorch.HALF, (Comparable)((Object)BlockBambooTorch.EnumBlockTorchHalf.LOWER));
    public static IBlockState BAMBOO_TORCH_UPPER = ModBlocks.BAMBOO_TORCH.func_176223_P().func_177226_a(BlockBambooTorch.HALF, (Comparable)((Object)BlockBambooTorch.EnumBlockTorchHalf.UPPER));
    public static final WeightedLootList chestLoot = new WeightedLootList(new LootItemStack[]{new LootItemStack((Item)Items.field_151031_f).setWeight(1), new LootItemStack(Items.field_151032_g).setAmount(3, 10).setWeight(18), new LootItemStack(Items.field_151122_aG).setAmount(1, 4).setWeight(18), new LootItemStack(Items.field_151121_aF).setAmount(2, 6).setWeight(16), new LootItemStack(Blocks.field_150321_G).setAmount(2, 7).setWeight(13), new LootItemStack(ModItems.EREBUS_FOOD).setAmount(1, 2).setDamage(ItemErebusFood.EnumFoodType.DARK_FRUIT_PIE.ordinal()).setWeight(13), new LootItemStack(ModItems.MATERIALS).setAmount(1, 3).setDamage(ItemMaterials.EnumErebusMaterialsType.JADE.ordinal()).setWeight(10), new LootItemStack(ModItems.MATERIALS).setAmount(4, 8).setDamage(ItemMaterials.EnumErebusMaterialsType.PLATE_EXO.ordinal()).setWeight(9), new LootItemStack(Items.field_151134_bR).setWeight(8), new LootItemStack(ModBlocks.UMBER_GOLEM_STATUE).setAmount(1).setWeight(1), new LootItemStack(ModItems.WEB_SLINGER).setAmount(1).setWeight(1), new LootItemStack(Items.field_151005_D).setWeight(3), new LootItemStack(Items.field_151035_b).setWeight(2), new LootItemStack(ModItems.JADE_PICKAXE).setWeight(1), new LootItemStack(Items.field_151050_s).setWeight(1), new LootItemStack(Items.field_151011_C).setWeight(3), new LootItemStack(Items.field_151037_a).setWeight(2), new LootItemStack(ModItems.JADE_SHOVEL).setWeight(1), new LootItemStack(Items.field_151051_r).setWeight(1), new LootItemStack(Items.field_151006_E).setWeight(3), new LootItemStack(Items.field_151036_c).setWeight(2), new LootItemStack(ModItems.JADE_AXE).setWeight(1), new LootItemStack(Items.field_151049_t).setWeight(1), new LootItemStack(Items.field_151010_B).setWeight(3), new LootItemStack(Items.field_151040_l).setWeight(2), new LootItemStack(ModItems.JADE_SWORD).setWeight(1), new LootItemStack(Items.field_151052_q).setWeight(1), new LootItemStack((Item)Items.field_151030_Z).setWeight(2), new LootItemStack(ModItems.JADE_CHESTPLATE).setWeight(1), new LootItemStack((Item)Items.field_151171_ah).setWeight(1), new LootItemStack((Item)Items.field_151028_Y).setWeight(2), new LootItemStack(ModItems.JADE_HELMET).setWeight(1), new LootItemStack((Item)Items.field_151169_ag).setWeight(1), new LootItemStack((Item)Items.field_151165_aa).setWeight(2), new LootItemStack(ModItems.JADE_LEGGINGS).setWeight(1), new LootItemStack((Item)Items.field_151149_ai).setWeight(1), new LootItemStack((Item)Items.field_151167_ab).setWeight(2), new LootItemStack(ModItems.JADE_BOOTS).setWeight(1), new LootItemStack((Item)Items.field_151151_aj).setWeight(1), new LootItemStack(ModItems.BAMBUCKET).setAmount(1).setWeight(6)}).setPostProcessor(new IPostProcess(){

        @Override
        public ItemStack postProcessItem(ItemStack is, Random rand) {
            if (is.func_77973_b() == Items.field_151134_bR || rand.nextBoolean() && (is.func_77973_b() instanceof ItemTool || is.func_77973_b() instanceof ItemArmor || is.func_77973_b() instanceof ItemSword)) {
                boolean enchBook;
                boolean bl = enchBook = is.func_77973_b() == Items.field_151134_bR;
                if (enchBook) {
                    is = new ItemStack(Items.field_151122_aG);
                }
                List enchList = EnchantmentHelper.func_77513_b((Random)rand, (ItemStack)is, (int)(7 + rand.nextInt(10)), (boolean)true);
                if (enchBook) {
                    is = new ItemStack(Items.field_151134_bR);
                }
                if (enchList != null && enchList.size() > 0) {
                    for (int a = 0; a < enchList.size(); ++a) {
                        EnchantmentData data = (EnchantmentData)enchList.get(a);
                        is.func_77966_a(data.field_76302_b, data.field_76303_c);
                    }
                }
            }
            if (is.func_77973_b() == ModItems.BAMBUCKET) {
                int randomBucket = rand.nextInt(3);
                switch (randomBucket) {
                    case 0: {
                        is = ModFluids.getFilledBambucket(new FluidStack(FluidRegistry.getFluid((String)"beetle_juice"), 1000));
                        break;
                    }
                    case 1: {
                        is = ModFluids.getFilledBambucket(new FluidStack(FluidRegistry.getFluid((String)"anti_venom"), 1000));
                        break;
                    }
                    case 2: {
                        is = ModFluids.getFilledBambucket(new FluidStack(FluidRegistry.getFluid((String)"honey"), 1000));
                    }
                }
            }
            return is;
        }
    });

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        if (this.checkWorldLocation(world, pos)) {
            this.generateStructure(world, rand, pos);
            return true;
        }
        return false;
    }

    public boolean checkWorldLocation(World world, BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        for (int xx = x - this.baseRadius; xx <= x + this.baseRadius; ++xx) {
            for (int zz = z - this.baseRadius; zz <= z + this.baseRadius; ++zz) {
                for (int yy = y + 1; yy < y + this.height; ++yy) {
                    IBlockState block = world.func_180495_p(new BlockPos(xx, yy, zz));
                    if (block.func_177230_c().func_176200_f((IBlockAccess)world, new BlockPos(xx, yy, zz))) continue;
                    return false;
                }
            }
        }
        WorldDataGiantEucalyptus data = WorldDataGiantEucalyptus.forWorld(world);
        if (data.getData().isEmpty()) {
            data.addStructurePosition(pos);
            data.func_76185_a();
            return true;
        }
        if (!data.getData().isEmpty()) {
            for (int i = 0; i < data.getData().size(); ++i) {
                int x_origin = data.getData().get(i).func_177958_n();
                int z_origin = data.getData().get(i).func_177952_p();
                if (pos.func_177958_n() < x_origin - 100 || pos.func_177958_n() > x_origin + 100 || pos.func_177952_p() < z_origin - 100 || pos.func_177952_p() > z_origin + 100) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void generateStructure(World world, Random rand, BlockPos pos) {
        int yy;
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        WorldDataGiantEucalyptus data = WorldDataGiantEucalyptus.forWorld(world);
        data.addStructurePosition(pos);
        data.func_76185_a();
        int radius = this.baseRadius - 1;
        int layer1 = 4;
        int layer2 = 7;
        int layer3 = 9;
        int layer4 = 19;
        int layer5 = 27;
        for (yy = y; this.height + y >= yy; ++yy) {
            for (int i = radius * -1; i <= radius; ++i) {
                for (int j = radius * -1; j <= radius; ++j) {
                    double dSq = i * i + j * j;
                    if (yy <= y + layer1 && yy < y + layer2) {
                        if (Math.round(Math.sqrt(dSq)) == (long)radius || Math.round(Math.sqrt(dSq)) <= (long)(radius - 1) && yy <= y + 2) {
                            world.func_180501_a(new BlockPos(x + i, yy, z + j), this.LOG, 2);
                        }
                        world.func_180501_a(new BlockPos(x, yy, z), this.LOG, 2);
                    }
                    if (yy <= y + layer2 && yy > y + layer1) {
                        if (Math.round(Math.sqrt(dSq)) == (long)(radius - 1)) {
                            world.func_180501_a(new BlockPos(x + i, yy, z + j), this.LOG, 2);
                        }
                        world.func_180501_a(new BlockPos(x, yy, z), this.LOG, 2);
                    }
                    if (yy <= y + layer3 && yy > y + layer2) {
                        if (Math.round(Math.sqrt(dSq)) == (long)(radius - 2)) {
                            world.func_180501_a(new BlockPos(x + i, yy, z + j), this.LOG, 2);
                        }
                        world.func_180501_a(new BlockPos(x, yy, z), this.LOG, 2);
                    }
                    if (yy <= y + layer4 && yy > y + layer3) {
                        world.func_180501_a(new BlockPos(x, y + 10, z), this.LOG, 2);
                        world.func_180501_a(new BlockPos(x, y + 11, z), this.LOG, 2);
                        if (Math.round(Math.sqrt(dSq)) <= (long)(radius - 12) && Math.round(Math.sqrt(dSq)) > (long)(radius - 13)) {
                            world.func_180501_a(new BlockPos(x + i, y + 12, z + j), Blocks.field_150321_G.func_176223_P(), 2);
                        }
                        if (Math.round(Math.sqrt(dSq)) == (long)(radius - 3) || Math.round(Math.sqrt(dSq)) <= (long)(radius - 3) && Math.round(Math.sqrt(dSq)) > (long)(radius - 12) && yy >= y + 9 && yy <= y + 12) {
                            world.func_180501_a(new BlockPos(x + i, yy, z + j), this.LOG, 2);
                        }
                    }
                    if (yy <= y + layer5 && yy > y + layer4) {
                        if (Math.round(Math.sqrt(dSq)) == (long)(radius - 2)) {
                            world.func_180501_a(new BlockPos(x + i, yy, z + j), this.LOG, 2);
                        }
                        if (Math.round(Math.sqrt(dSq)) <= (long)(radius - 3) && yy == y + 20) {
                            world.func_180501_a(new BlockPos(x + i, yy, z + j), this.LOG, 2);
                        }
                        if (Math.round(Math.sqrt(dSq)) <= (long)(radius - 3) && yy == y + 21) {
                            world.func_180501_a(new BlockPos(x + i, yy, z + j), ModBlocks.SILK.func_176223_P(), 2);
                        }
                    }
                    if (Math.round(Math.sqrt(dSq)) >= (long)(radius - 3) || Math.round(Math.sqrt(dSq)) % 2L != 0L || yy != y + 21 || x + i == x || z + j == z) continue;
                    world.func_180501_a(new BlockPos(x + i, yy, z + j), Blocks.field_150321_G.func_176223_P(), 2);
                }
            }
        }
        this.createLeaves(world, rand, x + 10, y + 29, z);
        this.createLeaves(world, rand, x - 10, y + 29, z);
        this.createLeaves(world, rand, x, y + 29, z + 10);
        this.createLeaves(world, rand, x, y + 29, z - 10);
        this.createLeaves(world, rand, x + 7, y + 27, z + 7);
        this.createLeaves(world, rand, x + 7, y + 27, z - 7);
        this.createLeaves(world, rand, x - 7, y + 27, z + 7);
        this.createLeaves(world, rand, x - 7, y + 27, z - 7);
        this.createRoots(world, rand, x, y, z);
        this.createRoots(world, rand, x + 9, y, z);
        this.createRoots(world, rand, x - 9, y, z);
        this.createRoots(world, rand, x, y, z + 9);
        this.createRoots(world, rand, x, y, z - 9);
        this.createRoots(world, rand, x + 8, y, z + 8);
        this.createRoots(world, rand, x + 8, y, z - 8);
        this.createRoots(world, rand, x - 8, y, z + 8);
        this.createRoots(world, rand, x - 8, y, z - 8);
        for (yy = y + 3; 11 + y >= yy; ++yy) {
            world.func_180501_a(new BlockPos(x + 1, yy, z), Blocks.field_150395_bd.func_176203_a(2), 3);
            world.func_180501_a(new BlockPos(x - 1, yy, z), Blocks.field_150395_bd.func_176203_a(8), 3);
            world.func_180501_a(new BlockPos(x, yy, z + 1), Blocks.field_150395_bd.func_176203_a(4), 3);
            world.func_180501_a(new BlockPos(x, yy, z - 1), Blocks.field_150395_bd.func_176203_a(1), 3);
        }
        world.func_175656_a(new BlockPos(x + 9, y + 20, z), Blocks.field_150350_a.func_176223_P());
        world.func_175656_a(new BlockPos(x - 9, y + 20, z), Blocks.field_150350_a.func_176223_P());
        world.func_175656_a(new BlockPos(x, y + 20, z + 9), Blocks.field_150350_a.func_176223_P());
        world.func_175656_a(new BlockPos(x, y + 20, z - 9), Blocks.field_150350_a.func_176223_P());
        world.func_175656_a(new BlockPos(x + 9, y + 21, z), Blocks.field_150350_a.func_176223_P());
        world.func_175656_a(new BlockPos(x - 9, y + 21, z), Blocks.field_150350_a.func_176223_P());
        world.func_175656_a(new BlockPos(x, y + 21, z + 9), Blocks.field_150350_a.func_176223_P());
        world.func_175656_a(new BlockPos(x, y + 21, z - 9), Blocks.field_150350_a.func_176223_P());
        for (yy = y + 13; 21 + y >= yy; ++yy) {
            world.func_180501_a(new BlockPos(x - 9, yy, z), Blocks.field_150395_bd.func_176203_a(2), 3);
            world.func_180501_a(new BlockPos(x + 9, yy, z), Blocks.field_150395_bd.func_176203_a(8), 3);
            world.func_180501_a(new BlockPos(x, yy, z - 9), Blocks.field_150395_bd.func_176203_a(4), 3);
            world.func_180501_a(new BlockPos(x, yy, z + 9), Blocks.field_150395_bd.func_176203_a(1), 3);
        }
        this.placeSpawner(world, rand, x - 7, y + 3, z);
        this.placeSpawner(world, rand, x + 7, y + 3, z);
        this.placeSpawner(world, rand, x, y + 3, z - 7);
        this.placeSpawner(world, rand, x, y + 3, z + 7);
        if (rand.nextBoolean()) {
            this.placeSpawner(world, rand, x - 5, y + 13, z);
            this.placeSpawner(world, rand, x + 5, y + 13, z);
        } else {
            this.placeSpawner(world, rand, x, y + 13, z - 5);
            this.placeSpawner(world, rand, x, y + 13, z + 5);
        }
        EntityTarantulaMiniboss boss = new EntityTarantulaMiniboss(world);
        boss.func_70012_b((double)x + 0.5, y + 22, (double)z + 0.5, rand.nextFloat() * 360.0f, 0.0f);
        boss.field_98038_p = true;
        world.func_72838_d((Entity)boss);
        this.addEntranceDecoration(world, rand, pos);
    }

    public void addEntranceDecoration(World world, Random rand, BlockPos pos) {
        this.direction = 0;
        while (this.direction < 4) {
            for (int count = 0; count < 3; ++count) {
                this.rotatedCubeVolume(world, rand, pos, 0, -2 + count, -15 + count, this.LOG, 1, 2, 2, this.direction);
                this.rotatedCubeVolume(world, rand, pos, 0, 0 + count, -15 + count, this.getStairRotations(this.STAIRS, this.direction == 0 ? 2 : (this.direction == 1 ? 0 : (this.direction == 2 ? 3 : 1))), 1, 1, 1, this.direction);
                this.rotatedCubeVolume(world, rand, pos, 0, 1 + count, -15 + count, Blocks.field_150350_a.func_176223_P(), 1, 2, 1, this.direction);
                if (count >= 2) continue;
                this.rotatedCubeVolume(world, rand, pos, -1, -2 + count, -15 + count, this.LOG, 1, 3, 2, this.direction);
                this.rotatedCubeVolume(world, rand, pos, 1, -2 + count, -15 + count, this.LOG, 1, 3, 2, this.direction);
                this.rotatedCubeVolume(world, rand, pos, -1, 1 + count, -15 + count, this.FENCE, 1, 1, 1, this.direction);
                this.rotatedCubeVolume(world, rand, pos, 1, 1 + count, -15 + count, this.FENCE, 1, 1, 1, this.direction);
                if (count >= 1) continue;
                this.rotatedCubeVolume(world, rand, pos, -1, 2 + count, -15 + count, this.FENCE, 1, 1, 1, this.direction);
                this.rotatedCubeVolume(world, rand, pos, 1, 2 + count, -15 + count, this.FENCE, 1, 1, 1, this.direction);
                this.rotatedCubeVolume(world, rand, pos, -1, 3 + count, -15 + count, BAMBOO_TORCH_LOWER, 1, 1, 1, this.direction);
                this.rotatedCubeVolume(world, rand, pos, 1, 3 + count, -15 + count, BAMBOO_TORCH_LOWER, 1, 1, 1, this.direction);
                this.rotatedCubeVolume(world, rand, pos, -1, 4 + count, -15 + count, BAMBOO_TORCH_UPPER, 1, 1, 1, this.direction);
                this.rotatedCubeVolume(world, rand, pos, 1, 4 + count, -15 + count, BAMBOO_TORCH_UPPER, 1, 1, 1, this.direction);
            }
            this.rotatedCubeVolume(world, rand, pos, 0, 3, -12, this.getDoorRotations(this.DOOR, this.direction), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 0, 4, -12, this.getDoorRotations(this.DOOR, this.direction + 4), 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, -2, 5, -13, this.LOG, 5, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, -1, 6, -13, this.LOG, 3, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 0, 7, -13, this.LOG, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, -1, 8, -12, this.LOG, 3, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 0, 9, -12, this.LOG, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 0, 10, -11, this.LOG, 1, 1, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, -1, 10, -11, this.LOG, 1, 2, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 1, 10, -11, this.LOG, 1, 2, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, -2, 11, -11, this.LOG, 1, 2, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 2, 11, -11, this.LOG, 1, 2, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, -3, 12, -11, this.LOG, 1, 5, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 3, 12, -11, this.LOG, 1, 5, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, -1, 14, -10, ModBlocks.AMBER_GLASS.func_176223_P(), 1, 2, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 1, 14, -10, ModBlocks.AMBER_GLASS.func_176223_P(), 1, 2, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, -2, 16, -11, this.LOG, 1, 2, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 2, 16, -11, this.LOG, 1, 2, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, -1, 17, -11, this.LOG, 1, 2, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 1, 17, -11, this.LOG, 1, 2, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 0, 18, -11, this.LOG, 1, 2, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 0, 20, -12, this.LOG, 1, 6, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, -1, 22, -12, this.LOG, 1, 2, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 1, 22, -12, this.LOG, 1, 2, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, -2, 23, -12, this.LOG, 1, 3, 1, this.direction);
            this.rotatedCubeVolume(world, rand, pos, 2, 23, -12, this.LOG, 1, 3, 1, this.direction);
            ++this.direction;
        }
    }

    public void createLeaves(World world, Random rand, int x, int y, int z) {
        int radius = 5;
        int height = 3;
        for (int xx = x - radius; xx <= x + radius; ++xx) {
            for (int zz = z - radius; zz <= z + radius; ++zz) {
                for (int yy = y - height; yy < y + height; ++yy) {
                    double dSq = Math.pow(xx - x, 2.0) + Math.pow(zz - z, 2.0) + Math.pow(yy - y, 2.0);
                    if (Math.round(Math.sqrt(dSq)) >= (long)radius || !(dSq >= Math.pow(radius - 2, 2.0))) continue;
                    if (rand.nextInt(10) == 0) {
                        world.func_175656_a(new BlockPos(xx, yy, zz), this.LOG);
                        continue;
                    }
                    world.func_175656_a(new BlockPos(xx, yy, zz), this.LEAVES);
                }
            }
        }
    }

    public void createRoots(World world, Random rand, int x, int y, int z) {
        float radius = 4.0f;
        int height = rand.nextInt(6) + 10;
        for (int yy = y - 1; yy > y - height; --yy) {
            int i = (int)(radius * -1.0f);
            while ((float)i <= radius) {
                int j = (int)(radius * -1.0f);
                while ((float)j <= radius) {
                    double dSq = i * i + j * j;
                    if ((float)Math.round(Math.sqrt(dSq)) <= radius && rand.nextInt(5) != 0) {
                        world.func_180501_a(new BlockPos(x + i, yy, z + j), this.LOG.func_177226_a((IProperty)BlockLogErebus.field_176299_a, (Comparable)BlockLog.EnumAxis.NONE), 2);
                    }
                    if (yy % 4 == 0) {
                        radius = (float)((double)radius - 0.02);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public void placeSpawner(World world, Random rand, int x, int y, int z) {
        world.func_180501_a(new BlockPos(x + 1, y, z), Blocks.field_150321_G.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(x - 1, y, z), Blocks.field_150321_G.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(x, y, z - 1), Blocks.field_150321_G.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(x, y, z + 1), Blocks.field_150321_G.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(x, y + 1, z), Blocks.field_150321_G.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(x, y, z), ModBlocks.TARANTULA_SPAWNER.func_176223_P(), 2);
        world.func_180501_a(new BlockPos(x, y - 1, z), Blocks.field_150486_ae.func_176203_a(0), 2);
        TileEntityChest chest = (TileEntityChest)world.func_175625_s(new BlockPos(x, y - 1, z));
        if (chest != null) {
            LootUtil.generateLoot((IInventory)chest, rand, chestLoot, 3, 10);
        }
    }

    public void rotatedCubeVolume(World world, Random rand, BlockPos pos, int offsetA, int offsetB, int offsetC, IBlockState state, int sizeWidth, int sizeHeight, int sizeDepth, int direction) {
        switch (direction) {
            case 0: {
                for (int yy = offsetB; yy < offsetB + sizeHeight; ++yy) {
                    for (int xx = offsetA; xx < offsetA + sizeWidth; ++xx) {
                        for (int zz = offsetC; zz < offsetC + sizeDepth; ++zz) {
                            world.func_180501_a(pos.func_177982_a(xx, yy, zz), state, 16);
                        }
                    }
                }
                break;
            }
            case 1: {
                for (int yy = offsetB; yy < offsetB + sizeHeight; ++yy) {
                    for (int zz = -offsetA; zz > -offsetA - sizeWidth; --zz) {
                        for (int xx = offsetC; xx < offsetC + sizeDepth; ++xx) {
                            world.func_180501_a(pos.func_177982_a(xx, yy, zz), state, 16);
                        }
                    }
                }
                break;
            }
            case 2: {
                for (int yy = offsetB; yy < offsetB + sizeHeight; ++yy) {
                    for (int xx = -offsetA; xx > -offsetA - sizeWidth; --xx) {
                        for (int zz = -offsetC; zz > -offsetC - sizeDepth; --zz) {
                            world.func_180501_a(pos.func_177982_a(xx, yy, zz), state, 16);
                        }
                    }
                }
                break;
            }
            case 3: {
                for (int yy = offsetB; yy < offsetB + sizeHeight; ++yy) {
                    for (int zz = offsetA; zz < offsetA + sizeWidth; ++zz) {
                        for (int xx = -offsetC; xx > -offsetC - sizeDepth; --xx) {
                            world.func_180501_a(pos.func_177982_a(xx, yy, zz), state, 16);
                        }
                    }
                }
                break;
            }
        }
    }

    public IBlockState getStairRotations(IBlockState state, int blockMeta) {
        int direction = blockMeta;
        switch (direction) {
            case 0: {
                return state.func_177226_a((IProperty)BlockStairsErebus.field_176309_a, (Comparable)EnumFacing.EAST);
            }
            case 1: {
                return state.func_177226_a((IProperty)BlockStairsErebus.field_176309_a, (Comparable)EnumFacing.WEST);
            }
            case 2: {
                return state.func_177226_a((IProperty)BlockStairsErebus.field_176309_a, (Comparable)EnumFacing.SOUTH);
            }
            case 3: {
                return state.func_177226_a((IProperty)BlockStairsErebus.field_176309_a, (Comparable)EnumFacing.NORTH);
            }
            case 4: {
                return state.func_177226_a((IProperty)BlockStairsErebus.field_176309_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockStairsErebus.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP);
            }
            case 5: {
                return state.func_177226_a((IProperty)BlockStairsErebus.field_176309_a, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)BlockStairsErebus.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP);
            }
            case 6: {
                return state.func_177226_a((IProperty)BlockStairsErebus.field_176309_a, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)BlockStairsErebus.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP);
            }
            case 7: {
                return state.func_177226_a((IProperty)BlockStairsErebus.field_176309_a, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockStairsErebus.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP);
            }
        }
        return state;
    }

    public IBlockState getDoorRotations(IBlockState state, int direction) {
        switch (direction) {
            case 0: {
                return state.func_177226_a((IProperty)BlockDoorErebus.field_176520_a, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)BlockDoorErebus.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER);
            }
            case 1: {
                return state.func_177226_a((IProperty)BlockDoorErebus.field_176520_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockDoorErebus.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER);
            }
            case 2: {
                return state.func_177226_a((IProperty)BlockDoorErebus.field_176520_a, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockDoorErebus.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER);
            }
            case 3: {
                return state.func_177226_a((IProperty)BlockDoorErebus.field_176520_a, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)BlockDoorErebus.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER);
            }
            case 4: {
                state.func_177226_a((IProperty)BlockDoorErebus.field_176520_a, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)BlockDoorErebus.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER);
            }
            case 5: {
                return state.func_177226_a((IProperty)BlockDoorErebus.field_176520_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockDoorErebus.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER);
            }
            case 6: {
                return state.func_177226_a((IProperty)BlockDoorErebus.field_176520_a, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockDoorErebus.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER);
            }
            case 7: {
                return state.func_177226_a((IProperty)BlockDoorErebus.field_176520_a, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)BlockDoorErebus.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER);
            }
        }
        return state;
    }
}

