/*
 * Decompiled with CFR 0.152.
 */
package erebus.network.client;

import erebus.Erebus;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketParticle
implements IMessage,
IMessageHandler<PacketParticle, IMessage> {
    public byte particleType;
    public float posX;
    public float posY;
    public float posZ;

    public PacketParticle() {
    }

    public PacketParticle(ParticleType particleType, float posX, float posY, float posZ) {
        this.particleType = (byte)particleType.ordinal();
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeByte((int)this.particleType);
        buffer.writeFloat(this.posX).writeFloat(this.posY).writeFloat(this.posZ);
    }

    public void fromBytes(ByteBuf buffer) {
        this.particleType = buffer.readByte();
        this.posX = buffer.readFloat();
        this.posY = buffer.readFloat();
        this.posZ = buffer.readFloat();
    }

    @SideOnly(value=Side.CLIENT)
    public IMessage onMessage(PacketParticle message, MessageContext ctx) {
        WorldClient world = FMLClientHandler.instance().getWorldClient();
        if (world == null) {
            return null;
        }
        if (world.field_72995_K) {
            if (message.particleType < 0 || message.particleType >= ParticleType.values.length) {
                return null;
            }
            switch (ParticleType.values[message.particleType]) {
                case BEETLE_LARVA_SQUISH: {
                    for (int count = 0; count <= 200; ++count) {
                        Erebus.PROXY.spawnCustomParticle("slime", (World)world, (double)message.posX + (world.field_73012_v.nextDouble() - 0.5), (double)message.posY + world.field_73012_v.nextDouble(), (double)message.posZ + (world.field_73012_v.nextDouble() - 0.5), 0.0, 0.0, 0.0);
                    }
                    break;
                }
                case CRUSHROOM_BLAM: {
                    for (int a = 0; a < 360; a += 4) {
                        double ang = (double)a * Math.PI / 180.0;
                        Erebus.PROXY.spawnCustomParticle("repellent", (World)world, message.posX + -MathHelper.func_76126_a((float)((float)ang)) * 3.0f, (double)message.posY + 0.1, message.posZ + MathHelper.func_76134_b((float)((float)ang)) * 3.0f, 0.0, 0.0, 0.0);
                    }
                    break;
                }
                case TARANTULA_BLAM: {
                    for (int a = 0; a < 360; a += 4) {
                        double ang = (double)a * Math.PI / 180.0;
                        Erebus.PROXY.spawnCustomParticle("cloud", (World)world, message.posX + -MathHelper.func_76126_a((float)((float)ang)) * 3.0f, message.posY, message.posZ + MathHelper.func_76134_b((float)((float)ang)) * 3.0f, (double)(-MathHelper.func_76126_a((float)((float)ang))) * 0.5, 0.1, (double)MathHelper.func_76134_b((float)((float)ang)) * 0.5);
                    }
                    break;
                }
                case ANTLION_BLAM: {
                    for (int a = 0; a < 360; a += 4) {
                        double ang = (double)a * Math.PI / 180.0;
                        for (int count = 0; count <= 20; ++count) {
                            Erebus.PROXY.spawnCustomParticle("antlion_dig", (World)world, (double)message.posX + (double)(-MathHelper.func_76126_a((float)((float)ang))) * 3.5, (double)message.posY + 0.5, (double)message.posZ + (double)MathHelper.func_76134_b((float)((float)ang)) * 3.5, (double)(-MathHelper.func_76126_a((float)((float)ang))) * 0.8, 0.0, (double)MathHelper.func_76134_b((float)((float)ang)) * 0.8);
                        }
                        Erebus.PROXY.spawnCustomParticle("cloud", (World)world, (double)message.posX + (double)(-MathHelper.func_76126_a((float)((float)ang))) * 4.5, message.posY, (double)message.posZ + (double)MathHelper.func_76134_b((float)((float)ang)) * 4.5, (double)(-MathHelper.func_76126_a((float)((float)ang))) * 1.0, 0.1, (double)MathHelper.func_76134_b((float)((float)ang)) * 1.0);
                    }
                    break;
                }
                case BOSS_DEATH: {
                    float f = (world.field_73012_v.nextFloat() - 0.5f) * 8.0f;
                    float f1 = (world.field_73012_v.nextFloat() - 0.5f) * 4.0f;
                    float f2 = (world.field_73012_v.nextFloat() - 0.5f) * 8.0f;
                    Erebus.PROXY.spawnCustomParticle("huge_explode", (World)world, message.posX + f, (double)message.posY + 2.0 + (double)f1, message.posZ + f2, 0.0, 0.0, 0.0);
                    break;
                }
                case ANTLION_RUMBLE: {
                    for (int a = 0; a < 360; a += 4) {
                        double ang = (double)a * Math.PI / 180.0;
                        Erebus.PROXY.spawnCustomParticle("antlion_dig", (World)world, (double)message.posX + (double)(-MathHelper.func_76126_a((float)((float)ang))) * 3.5, (double)message.posY + 0.125, (double)message.posZ + (double)MathHelper.func_76134_b((float)((float)ang)) * 3.5, (double)(-MathHelper.func_76126_a((float)((float)ang))) * 0.8, 0.3, (double)MathHelper.func_76134_b((float)((float)ang)) * 0.8);
                    }
                    break;
                }
                case ANTLION_DIG: {
                    for (int a = 0; a < 360; a += 4) {
                        double ang = (double)a * Math.PI / 180.0;
                        Erebus.PROXY.spawnCustomParticle("antlion_dig", (World)world, (double)message.posX + (double)(-MathHelper.func_76126_a((float)((float)ang))) * 1.5, message.posY, (double)message.posZ + (double)MathHelper.func_76134_b((float)((float)ang)) * 1.5, (double)(-MathHelper.func_76126_a((float)((float)ang))) * 0.8, 0.3, (double)MathHelper.func_76134_b((float)((float)ang)) * 0.8);
                    }
                    break;
                }
                case HAMMER_BLAM: {
                    for (int a = 0; a < 360; a += 4) {
                        double ang = (double)a * Math.PI / 180.0;
                        for (int count = 0; count <= 4; ++count) {
                            Erebus.PROXY.spawnCustomParticle("sparks", (World)world, (double)message.posX + (double)(-MathHelper.func_76126_a((float)((float)ang))) * 1.0 * (double)count * 0.5, message.posY, (double)message.posZ + (double)(MathHelper.func_76134_b((float)((float)ang)) * 1.0f * (float)count) * 0.5, (double)(-MathHelper.func_76126_a((float)((float)ang))) * 0.5, 0.01, (double)MathHelper.func_76134_b((float)((float)ang)) * 0.5);
                        }
                        Erebus.PROXY.spawnCustomParticle("cloud", (World)world, (double)message.posX + (double)(-MathHelper.func_76126_a((float)((float)ang))) * 2.0, message.posY, (double)message.posZ + (double)MathHelper.func_76134_b((float)((float)ang)) * 2.0, (double)(-MathHelper.func_76126_a((float)((float)ang))) * 0.5, 0.01, (double)MathHelper.func_76134_b((float)((float)ang)) * 0.5);
                    }
                    break;
                }
                case GAS_VENT_SWAMP: {
                    for (double yy = (double)message.posY; yy < (double)message.posY + 2.0; yy += 0.5) {
                        double d0 = message.posX - 0.075f;
                        double d1 = yy;
                        double d2 = message.posZ - 0.075f;
                        double d3 = message.posX + 0.075f;
                        double d4 = message.posZ + 0.075f;
                        double d5 = message.posX;
                        double d6 = yy + 0.25;
                        double d7 = message.posZ;
                        Erebus.PROXY.spawnCustomParticle("swampflame", (World)world, d0, d1, d2, 0.0, 0.05, 0.0);
                        Erebus.PROXY.spawnCustomParticle("swampflame", (World)world, d0, d1, d4, 0.0, 0.05, 0.0);
                        Erebus.PROXY.spawnCustomParticle("swampflame", (World)world, d3, d1, d2, 0.0, 0.05, 0.0);
                        Erebus.PROXY.spawnCustomParticle("swampflame", (World)world, d3, d1, d4, 0.0, 0.05, 0.0);
                        Erebus.PROXY.spawnCustomParticle("swampflame", (World)world, d5, d6, d7, 0.0, 0.05, 0.0);
                    }
                    break;
                }
                case GAS_VENT_VOLCANIC: {
                    for (double yy = (double)message.posY; yy < (double)message.posY + 2.0; yy += 0.5) {
                        double d0 = message.posX - 0.075f;
                        double d1 = yy;
                        double d2 = message.posZ - 0.075f;
                        double d3 = message.posX + 0.075f;
                        double d4 = message.posZ + 0.075f;
                        double d5 = message.posX;
                        double d6 = yy + 0.25;
                        double d7 = message.posZ;
                        Erebus.PROXY.spawnCustomParticle("flame", (World)world, d0, d1, d2, 0.0, 0.05, 0.0);
                        Erebus.PROXY.spawnCustomParticle("flame", (World)world, d0, d1, d4, 0.0, 0.05, 0.0);
                        Erebus.PROXY.spawnCustomParticle("flame", (World)world, d3, d1, d2, 0.0, 0.05, 0.0);
                        Erebus.PROXY.spawnCustomParticle("flame", (World)world, d3, d1, d4, 0.0, 0.05, 0.0);
                        Erebus.PROXY.spawnCustomParticle("flame", (World)world, d5, d6, d7, 0.0, 0.05, 0.0);
                    }
                    break;
                }
                case WASP_DAGGER: {
                    for (int i = 0; i < 8; ++i) {
                        Erebus.PROXY.spawnCustomParticle("reddust", (World)world, message.posX, message.posY, message.posZ, 0.0, 0.0, 0.0);
                    }
                    break;
                }
            }
        }
        return null;
    }

    public static enum ParticleType {
        BEETLE_LARVA_SQUISH,
        SPRAY_CAN,
        CRUSHROOM_BLAM,
        TARANTULA_BLAM,
        BOSS_DEATH,
        ANTLION_BLAM,
        ANTLION_RUMBLE,
        ANTLION_DIG,
        HAMMER_BLAM,
        GAS_VENT_SWAMP,
        GAS_VENT_VOLCANIC,
        WASP_DAGGER;

        static final ParticleType[] values;

        static {
            values = ParticleType.values();
        }
    }
}

