/*
 * Decompiled with CFR 0.152.
 */
package erebus.items;

import erebus.ModBlocks;
import erebus.ModSounds;
import erebus.ModTabs;
import erebus.block.altars.AltarBase;
import erebus.blocks.BlockDoubleHeightPlant;
import erebus.blocks.BlockGaeanKeystone;
import erebus.blocks.BlockPreservedBlock;
import erebus.core.handler.configs.ConfigHandler;
import erebus.core.helper.Utils;
import erebus.entity.EntityAnimatedBambooCrate;
import erebus.entity.EntityAnimatedBlock;
import erebus.entity.EntityAnimatedChest;
import erebus.tileentity.TileEntityBambooCrate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemWandOfAnimation
extends Item {
    public ItemWandOfAnimation() {
        this.func_77664_n();
        this.setNoRepair();
        this.func_77656_e(64);
        this.func_77625_d(1);
        this.func_77637_a(ModTabs.GEAR);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flag) {
        list.add(TextFormatting.GRAY + new TextComponentTranslation("tooltip.erebus.wandofanimation", new Object[0]).func_150254_d());
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_175151_a(pos, facing, stack)) {
            return EnumActionResult.FAIL;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        int blockMeta = block.func_176201_c(state);
        if (!world.field_72995_K && block != null && this.canAnimate(state, world, pos)) {
            EntityAnimatedBlock entityAnimatedBlock;
            if (block == Blocks.field_150486_ae) {
                entityAnimatedBlock = new EntityAnimatedChest(world).setContents((IInventory)Utils.getTileEntity((IBlockAccess)world, pos, TileEntityChest.class));
            } else if (block == ModBlocks.BAMBOO_CRATE) {
                entityAnimatedBlock = new EntityAnimatedBambooCrate(world).setContents((IInventory)Utils.getTileEntity((IBlockAccess)world, pos, TileEntityBambooCrate.class));
                blockMeta = 0;
            } else {
                entityAnimatedBlock = new EntityAnimatedBlock(world);
            }
            if (block == Blocks.field_150428_aP || block == Blocks.field_150423_aK) {
                blockMeta = 1;
            }
            world.func_175698_g(pos);
            entityAnimatedBlock.func_70012_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, 0.0f, 0.0f);
            entityAnimatedBlock.setBlock(block, blockMeta);
            world.func_72838_d((Entity)entityAnimatedBlock);
            entityAnimatedBlock.setOwnerId(player.func_110124_au());
            world.func_184133_a((EntityPlayer)null, pos, ModSounds.ALTAR_OFFERING, SoundCategory.BLOCKS, 0.2f, 1.0f);
            stack.func_77972_a(1, (EntityLivingBase)player);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    private Boolean isBlacklisted(Block block) {
        ArrayList<Block> blockList = new ArrayList<Block>();
        for (int blocks = 0; blocks < ConfigHandler.WOA_BLACKLISTED_BLOCKS.length; ++blocks) {
            String entry = ConfigHandler.WOA_BLACKLISTED_BLOCKS[blocks].trim();
            Block outBlock = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(entry));
            blockList.add(outBlock);
        }
        if (blockList.contains(block)) {
            return true;
        }
        return false;
    }

    private boolean canAnimate(IBlockState state, World world, BlockPos pos) {
        return this.isBlacklisted(state.func_177230_c()) == false && !(state.func_177230_c() instanceof BlockGaeanKeystone) && !(state.func_177230_c() instanceof AltarBase) && !(state.func_177230_c() instanceof BlockDoublePlant) && !(state.func_177230_c() instanceof BlockDoubleHeightPlant) && !(state.func_177230_c() instanceof BlockPreservedBlock) && !(state.func_177230_c() instanceof BlockContainer) && state.func_185887_b(world, pos) >= 0.0f && state.func_185900_c((IBlockAccess)world, (BlockPos)pos).field_72336_d - state.func_185900_c((IBlockAccess)world, (BlockPos)pos).field_72340_a >= (double)0.7f && state.func_185900_c((IBlockAccess)world, (BlockPos)pos).field_72334_f - state.func_185900_c((IBlockAccess)world, (BlockPos)pos).field_72339_c >= (double)0.7f && state.func_185900_c((IBlockAccess)world, (BlockPos)pos).field_72337_e - state.func_185900_c((IBlockAccess)world, (BlockPos)pos).field_72338_b >= (double)0.7f || state.func_177230_c() == Blocks.field_150486_ae || state.func_177230_c() == ModBlocks.BAMBOO_CRATE;
    }
}

