/*
 * Decompiled with CFR 0.152.
 */
package erebus.items;

import erebus.ModItems;
import erebus.ModTabs;
import erebus.core.helper.FluidHandlerUniversalBucket;
import erebus.entity.EntityBeetle;
import erebus.entity.EntityBotFlyLarva;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemBambucket
extends UniversalBucket {
    private final ItemStack empty = new ItemStack((Item)this);

    public ItemBambucket() {
        super(1000, new ItemStack(ModItems.BAMBUCKET), true);
        this.func_77625_d(16);
        this.func_77637_a(ModTabs.ITEMS);
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        FluidStack fluidStack = this.getFluid(stack);
        if (fluidStack != null) {
            return false;
        }
        ItemStack newStack = new ItemStack((Item)this, 1);
        if (!newStack.func_77942_o()) {
            newStack.func_77982_d(new NBTTagCompound());
        }
        IFluidHandlerItem cap = (IFluidHandlerItem)newStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        if (target instanceof EntityCow && !target.func_70631_g_()) {
            cap.fill(new FluidStack(FluidRegistry.getFluid((String)"milk"), 1000), true);
            player.func_184185_a(SoundEvents.field_187564_an, 1.0f, 1.0f);
            if (!player.field_71071_by.func_70441_a(newStack)) {
                player.func_71019_a(newStack, false);
            }
            stack.func_190918_g(1);
            return true;
        }
        if (target instanceof EntityBeetle) {
            cap.fill(new FluidStack(FluidRegistry.getFluid((String)"beetle_juice"), 1000), true);
            player.func_184185_a(SoundEvents.field_187630_M, 1.0f, 1.0f);
            if (!player.field_71071_by.func_70441_a(newStack)) {
                player.func_71019_a(newStack, false);
            }
            stack.func_190918_g(1);
            return true;
        }
        return false;
    }

    public void func_150895_a(@Nullable CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        subItems.add((Object)this.empty);
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            IFluidHandlerItem fluidHandler;
            FluidStack fs = new FluidStack(fluid, this.getCapacity());
            ItemStack stack = new ItemStack((Item)this);
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            if ((fluidHandler = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) == null || fluidHandler.fill(fs, true) != fs.amount) continue;
            ItemStack filled = fluidHandler.getContainer();
            subItems.add((Object)filled);
        }
    }

    public String func_77653_i(ItemStack stack) {
        FluidStack fluidStack = this.getFluid(stack);
        String unlocalisedName = this.func_77657_g(stack);
        if (fluidStack == null) {
            return I18n.func_74838_a((String)(unlocalisedName + ".name")).trim();
        }
        String fluidUnlocalisedName = unlocalisedName + ".filled." + fluidStack.getFluid().getName() + ".name";
        if (I18n.func_94522_b((String)fluidUnlocalisedName)) {
            return I18n.func_74838_a((String)fluidUnlocalisedName);
        }
        return I18n.func_74837_a((String)(unlocalisedName + ".filled.name"), (Object[])new Object[]{fluidStack.getLocalizedName()});
    }

    public int func_77626_a(ItemStack stack) {
        return this.isDrinkableFluid(stack) ? 32 : 0;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return this.isDrinkableFluid(stack) ? EnumAction.DRINK : EnumAction.NONE;
    }

    public boolean isDrinkableFluid(ItemStack stack) {
        FluidStack fluidStack = this.getFluid(stack);
        return fluidStack != null && (fluidStack.getFluid() == FluidRegistry.getFluid((String)"beetle_juice") || fluidStack.getFluid() == FluidRegistry.getFluid((String)"anti_venom") || fluidStack.getFluid() == FluidRegistry.getFluid((String)"milk"));
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        FluidActionResult filledResult;
        ItemStack heldItem = player.func_184586_b(hand);
        FluidStack fluidStack = this.getFluid(heldItem);
        if (world.field_72995_K) {
            return new ActionResult(EnumActionResult.PASS, (Object)heldItem);
        }
        if (this.isDrinkableFluid(heldItem)) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)heldItem);
        }
        RayTraceResult target = this.func_77621_a(world, player, true);
        if (target == null || target.field_72313_a == RayTraceResult.Type.MISS) {
            return new ActionResult(EnumActionResult.FAIL, (Object)heldItem);
        }
        BlockPos pos = target.func_178782_a();
        if (fluidStack != null) {
            world.func_184133_a(null, pos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return super.func_77659_a(world, player, hand);
        }
        ItemStack singleBucket = new ItemStack((Item)this, 1);
        if (!singleBucket.func_77942_o()) {
            singleBucket.func_77982_d(new NBTTagCompound());
        }
        if ((filledResult = FluidUtil.tryPickUpFluid((ItemStack)singleBucket, (EntityPlayer)player, (World)world, (BlockPos)pos, (EnumFacing)target.field_178784_b)).isSuccess()) {
            world.func_184133_a(null, pos, SoundEvents.field_187630_M, SoundCategory.BLOCKS, 1.0f, 1.0f);
            ItemStack filledBucket = filledResult.result;
            if (player.field_71075_bZ.field_75098_d) {
                return new ActionResult(EnumActionResult.SUCCESS, (Object)heldItem);
            }
            heldItem.func_190918_g(1);
            if (heldItem.func_190926_b()) {
                return new ActionResult(EnumActionResult.SUCCESS, (Object)filledBucket);
            }
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)filledBucket);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)heldItem);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)heldItem);
    }

    public ItemStack getEmpty() {
        if (!this.empty.func_77942_o()) {
            this.empty.func_77982_d(new NBTTagCompound());
        }
        return this.empty;
    }

    public Entity getParasite(Entity entityIn) {
        for (Entity entity : entityIn.func_184188_bt()) {
            if (!(entity instanceof EntityBotFlyLarva)) continue;
            return entity;
        }
        return null;
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entityLiving) {
        ItemStack emptyBucket;
        EntityPlayer player;
        FluidStack fluidStack = this.getFluid(stack);
        ItemStack newStack = new ItemStack((Item)this, 1);
        if (!newStack.func_77942_o()) {
            newStack.func_77982_d(new NBTTagCompound());
        }
        if (!(fluidStack.getFluid() != FluidRegistry.getFluid((String)"beetle_juice") && fluidStack.getFluid() != FluidRegistry.getFluid((String)"milk") || world.field_72995_K)) {
            entityLiving.curePotionEffects(stack);
            if (entityLiving.func_184207_aI() && this.getParasite((Entity)entityLiving) != null && ((EntityBotFlyLarva)this.getParasite((Entity)entityLiving)).getParasiteCount() > 0) {
                ((EntityBotFlyLarva)this.getParasite((Entity)entityLiving)).setABitDead();
            }
        }
        if (fluidStack.getFluid() == FluidRegistry.getFluid((String)"anti_venom") && entityLiving instanceof EntityPlayer && (!(player = (EntityPlayer)entityLiving).getEntityData().func_74764_b("anti_venom_duration") || player.getEntityData().func_74762_e("anti_venom_duration") < 180)) {
            player.getEntityData().func_74768_a("anti_venom_duration", 180);
        }
        if (entityLiving instanceof EntityPlayerMP) {
            player = (EntityPlayerMP)entityLiving;
            CriteriaTriggers.field_193138_y.func_193148_a((EntityPlayerMP)player, stack);
            player.func_71029_a(StatList.func_188057_b((Item)this));
        }
        if (!(emptyBucket = new ItemStack((Item)this, 1)).func_77942_o()) {
            emptyBucket.func_77982_d(new NBTTagCompound());
        }
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player2 = (EntityPlayer)entityLiving;
            if (!player2.field_71071_by.func_70441_a(emptyBucket)) {
                player2.func_71019_a(emptyBucket, false);
            }
        }
        stack.func_190918_g(1);
        return stack;
    }

    @Nullable
    public FluidStack getFluid(ItemStack container) {
        return FluidUtil.getFluidContained((ItemStack)container);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new FluidHandlerUniversalBucket(stack, this.getCapacity());
    }
}

