/*
 * Decompiled with CFR 0.152.
 */
package erebus.core.handler;

import erebus.core.handler.configs.ConfigHandler;
import erebus.world.teleporter.TeleporterHandler;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSpawnPosition;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class EntityPlayerSpawnHandler {
    public static final String RESPAWN_IN_EREBUS_NBT = "erebus.respawn_in_erebus";

    @SubscribeEvent
    public void onPlayerDeath(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            NBTTagCompound dataNbt = player.getEntityData();
            NBTTagCompound persistentNbt = dataNbt.func_74775_l("PlayerPersisted");
            BlockPos spawnPos = player.getBedLocation(player.field_71093_bK);
            BlockPos adjustedSpawnPos = spawnPos == null ? null : EntityPlayer.func_180467_a((World)player.field_70170_p, (BlockPos)spawnPos, (boolean)player.isSpawnForced(player.field_71093_bK));
            boolean respawnInErebus = ConfigHandler.INSTANCE.allowRespawning && (!player.field_70170_p.field_73011_w.func_76567_e() || adjustedSpawnPos == null);
            persistentNbt.func_74757_a(RESPAWN_IN_EREBUS_NBT, respawnInErebus);
            dataNbt.func_74782_a("PlayerPersisted", (NBTBase)persistentNbt);
        }
    }

    @SubscribeEvent
    public void onRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (!event.player.field_70170_p.field_72995_K) {
            boolean shouldTeleportToErebus;
            BlockPos spawnPos = event.player.getBedLocation(event.player.field_71093_bK);
            BlockPos adjustedSpawnPos = spawnPos == null ? null : EntityPlayer.func_180467_a((World)event.player.field_70170_p, (BlockPos)spawnPos, (boolean)event.player.isSpawnForced(event.player.field_71093_bK));
            NBTTagCompound dataNbt = event.player.getEntityData();
            NBTTagCompound persistentNbt = dataNbt.func_74775_l("PlayerPersisted");
            boolean bl = shouldTeleportToErebus = ConfigHandler.INSTANCE.allowRespawning || persistentNbt.func_74767_n(RESPAWN_IN_EREBUS_NBT);
            if (shouldTeleportToErebus && event.player.field_70170_p instanceof WorldServer) {
                WorldServer erebusWorld = ((WorldServer)event.player.field_70170_p).func_73046_m().func_71218_a(ConfigHandler.INSTANCE.erebusDimensionID);
                TeleporterHandler.transferToErebus((Entity)event.player);
                spawnPos = event.player.getBedLocation(event.player.field_71093_bK);
                BlockPos blockPos = adjustedSpawnPos = spawnPos == null ? null : EntityPlayer.func_180467_a((World)event.player.field_70170_p, (BlockPos)spawnPos, (boolean)event.player.isSpawnForced(event.player.field_71093_bK));
                if (adjustedSpawnPos != null) {
                    event.player.func_70107_b((double)adjustedSpawnPos.func_177958_n() + 0.5, (double)adjustedSpawnPos.func_177956_o(), (double)adjustedSpawnPos.func_177952_p() + 0.5);
                    if (event.player instanceof EntityPlayerMP) {
                        EntityPlayerMP playerMP = (EntityPlayerMP)event.player;
                        playerMP.field_71135_a.func_147364_a(playerMP.field_70165_t, playerMP.field_70163_u, playerMP.field_70161_v, playerMP.field_70177_z, playerMP.field_70125_A);
                        playerMP.field_71135_a.func_147359_a((Packet)new SPacketSpawnPosition(adjustedSpawnPos));
                    }
                }
            }
            if (shouldTeleportToErebus || event.player.field_71093_bK == ConfigHandler.INSTANCE.erebusDimensionID) {
                boolean newRespawn = false;
                if (adjustedSpawnPos == null) {
                    newRespawn = true;
                } else {
                    boolean isValidSpawnBlock;
                    IBlockState stateDown = event.player.field_70170_p.func_180495_p(adjustedSpawnPos.func_177977_b());
                    boolean bl2 = isValidSpawnBlock = stateDown.func_185904_a().func_76230_c() && !stateDown.func_177230_c().isLeaves(stateDown, (IBlockAccess)event.player.field_70170_p, adjustedSpawnPos.func_177977_b()) && !stateDown.func_177230_c().isFoliage((IBlockAccess)event.player.field_70170_p, adjustedSpawnPos.func_177977_b());
                    if (!isValidSpawnBlock) {
                        newRespawn = true;
                    }
                }
                if (newRespawn && persistentNbt.func_150297_b("erebus.last_portal_location", 4)) {
                    BlockPos lastPortal = BlockPos.func_177969_a((long)persistentNbt.func_74763_f("erebus.last_portal_location"));
                    EntityPlayerSpawnHandler.respawnAtPortal((Entity)event.player, lastPortal);
                }
            }
        }
    }

    public static void respawnAtPortal(Entity entity, BlockPos newSpawn) {
        entity.func_70012_b((double)newSpawn.func_177958_n() + 0.5, (double)newSpawn.func_177956_o(), (double)newSpawn.func_177952_p() + 0.5, entity.field_70177_z, entity.field_70125_A);
        newSpawn = new BlockPos(entity);
        if (entity instanceof EntityPlayer) {
            ((EntityPlayer)entity).func_180473_a(newSpawn, true);
        }
        if (entity instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)entity;
            playerMP.field_71135_a.func_147364_a(playerMP.field_70165_t, playerMP.field_70163_u, playerMP.field_70161_v, playerMP.field_70177_z, playerMP.field_70125_A);
            playerMP.field_71135_a.func_147359_a((Packet)new SPacketSpawnPosition(newSpawn));
        }
    }
}

