/*
 * Decompiled with CFR 0.152.
 */
package erebus.blocks;

import erebus.Erebus;
import erebus.ModBlocks;
import erebus.ModTabs;
import erebus.proxy.CommonProxy;
import erebus.tileentity.TileEntityLiquifier;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockLiquifier
extends BlockDirectional
implements ITileEntityProvider,
ModBlocks.IHasCustomItem {
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");

    public BlockLiquifier() {
        super(Material.field_151573_f);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
        this.func_149711_c(10.0f);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149647_a(ModTabs.BLOCKS);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityLiquifier();
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185505_j;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return field_185505_j;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_82600_a((int)meta);
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            facing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)field_176387_N, (Comparable)facing).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        meta |= ((EnumFacing)state.func_177229_b((IProperty)field_176387_N)).func_176745_a();
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            meta |= 8;
        }
        return meta;
    }

    public static EnumFacing getFacingFromEntity(BlockPos pos, EntityLivingBase entity) {
        if (MathHelper.func_76135_e((float)((float)entity.field_70165_t - (float)pos.func_177958_n())) < 2.0f && MathHelper.func_76135_e((float)((float)entity.field_70161_v - (float)pos.func_177952_p())) < 2.0f) {
            double eyeHeight = entity.field_70163_u + (double)entity.func_70047_e();
            if (eyeHeight - (double)pos.func_177956_o() > 2.0) {
                return EnumFacing.NORTH;
            }
            if ((double)pos.func_177956_o() - eyeHeight > 0.0) {
                return EnumFacing.NORTH;
            }
        }
        return entity.func_174811_aO().func_176734_d();
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)field_176387_N, (Comparable)BlockLiquifier.getFacingFromEntity(pos, placer)).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(world.func_175640_z(pos)));
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntityLiquifier tile;
        if (!world.field_72995_K && !player.field_71075_bZ.field_75098_d && (tile = (TileEntityLiquifier)world.func_175625_s(pos)) != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            tile.func_189515_b(nbt);
            ItemStack stack = new ItemStack(Item.func_150898_a((Block)this), 1, 0);
            if (tile.tank.getFluidAmount() > 0) {
                stack.func_77982_d(nbt);
            }
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)tile);
            world.func_175713_t(pos);
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(world, pos, state, placer, stack);
        TileEntityLiquifier tile = (TileEntityLiquifier)world.func_175625_s(pos);
        if (!world.field_72995_K) {
            if (stack.func_77942_o() && tile != null && !stack.func_77978_p().func_74764_b("Empty")) {
                FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p());
                tile.tank.fillInternal(fluid, true);
            }
            if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
                tile.setActive(true);
            }
        }
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)field_176387_N, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)field_176387_N)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)state.func_177229_b((IProperty)field_176387_N)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176387_N, POWERED});
    }

    public static void setState(World world, BlockPos pos, IBlockState state, boolean powered) {
        if (!world.field_72995_K) {
            TileEntityLiquifier tile = (TileEntityLiquifier)world.func_175625_s(pos);
            state = state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(powered));
            world.func_180501_a(pos, state, 3);
            tile.setActive(powered);
            if (tile != null) {
                tile.func_145829_t();
                world.func_175690_a(pos, (TileEntity)tile);
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (world.func_175625_s(pos) instanceof TileEntityLiquifier) {
            player.openGui((Object)Erebus.INSTANCE, CommonProxy.GuiID.LIQUIFIER.ordinal(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntityLiquifier tile = (TileEntityLiquifier)world.func_175625_s(pos);
        if (tile != null) {
            world.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(world, pos, state);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!world.field_72995_K) {
            if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue() && !world.func_175640_z(pos)) {
                BlockLiquifier.setState(world, pos, state, false);
            } else if (!((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue() && world.func_175640_z(pos)) {
                BlockLiquifier.setState(world, pos, state, true);
            }
        }
    }

    @Override
    public ItemBlock getItemBlock() {
        ItemBlock LIQUIFIER_ITEM = new ItemBlock((Block)this){

            @SideOnly(value=Side.CLIENT)
            public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flag) {
                if (stack.func_77942_o() && !stack.func_77978_p().func_74764_b("Empty")) {
                    FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p());
                    if (fluid != null) {
                        list.add(TextFormatting.GREEN + "Contains: " + fluid.getFluid().getLocalizedName(fluid));
                        list.add(TextFormatting.BLUE + "" + fluid.amount + "Mb");
                    }
                } else {
                    list.add(TextFormatting.YELLOW + new TextComponentTranslation("tooltip.erebus.liquifier", new Object[0]).func_150254_d());
                    list.add(TextFormatting.RED + "It's Empty!");
                }
            }
        };
        return LIQUIFIER_ITEM;
    }
}

