/*
 * Decompiled with CFR 0.152.
 */
package erebus.blocks;

import erebus.ModBlocks;
import erebus.ModTabs;
import erebus.api.IErebusEnum;
import erebus.blocks.BlockSpawner;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBotFlySpawner
extends BlockSpawner {
    public static final PropertyEnum<EnumDungDirection> TYPE = PropertyEnum.func_177709_a((String)"type", EnumDungDirection.class);

    public BlockBotFlySpawner(ResourceLocation mobName) {
        super(mobName);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, (Comparable)((Object)EnumDungDirection.DOWN_NORTH)));
        this.setHarvestLevel("pickaxe", 0);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return 0;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!world.field_72995_K) {
            EntityAreaEffectCloud entityareaeffectcloud = new EntityAreaEffectCloud(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
            entityareaeffectcloud.func_184483_a(3.0f);
            entityareaeffectcloud.func_184495_b(-0.5f);
            entityareaeffectcloud.func_184485_d(10);
            entityareaeffectcloud.func_184486_b(entityareaeffectcloud.func_184489_o() * 2);
            entityareaeffectcloud.func_184487_c(-entityareaeffectcloud.func_184490_j() / (float)entityareaeffectcloud.func_184489_o());
            entityareaeffectcloud.func_184496_a(new PotionEffect(MobEffects.field_76419_f, 140));
            entityareaeffectcloud.func_184496_a(new PotionEffect(MobEffects.field_76431_k, 200));
            world.func_72838_d((Entity)entityareaeffectcloud);
        }
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        return BlockBotFlySpawner.canPlaceBlock(world, pos, side);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!BlockBotFlySpawner.canPlaceBlock(world, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    protected static boolean canPlaceBlock(World world, BlockPos pos, EnumFacing direction) {
        BlockPos blockpos = pos.func_177972_a(direction.func_176734_d());
        IBlockState iblockstate = world.func_180495_p(blockpos);
        boolean flag = iblockstate.func_193401_d((IBlockAccess)world, blockpos, direction) == BlockFaceShape.SOLID;
        Block block = iblockstate.func_177230_c();
        return world.func_175677_d(blockpos, true) && block.func_149662_c(iblockstate) && flag;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        int direction = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        EnumDungDirection newFacing = EnumDungDirection.DOWN_NORTH;
        if (facing == EnumFacing.UP) {
            switch (direction) {
                case 0: {
                    newFacing = EnumDungDirection.DOWN_SOUTH;
                    break;
                }
                case 1: {
                    newFacing = EnumDungDirection.DOWN_EAST;
                    break;
                }
                case 2: {
                    newFacing = EnumDungDirection.DOWN_NORTH;
                    break;
                }
                case 3: {
                    newFacing = EnumDungDirection.DOWN_WEST;
                }
            }
        } else if (facing == EnumFacing.DOWN) {
            switch (direction) {
                case 0: {
                    newFacing = EnumDungDirection.UP_SOUTH;
                    break;
                }
                case 1: {
                    newFacing = EnumDungDirection.UP_EAST;
                    break;
                }
                case 2: {
                    newFacing = EnumDungDirection.UP_NORTH;
                    break;
                }
                case 3: {
                    newFacing = EnumDungDirection.UP_WEST;
                }
            }
        } else {
            switch (facing) {
                case SOUTH: {
                    newFacing = EnumDungDirection.NORTH;
                    break;
                }
                case EAST: {
                    newFacing = EnumDungDirection.WEST;
                    break;
                }
                case NORTH: {
                    newFacing = EnumDungDirection.SOUTH;
                    break;
                }
                case WEST: {
                    newFacing = EnumDungDirection.EAST;
                }
            }
        }
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)newFacing));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (tab == ModTabs.BLOCKS) {
            list.add((Object)new ItemStack((Block)this, 1, EnumDungDirection.DOWN_NORTH.ordinal()));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumDungDirection.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        EnumDungDirection type = (EnumDungDirection)((Object)state.func_177229_b(TYPE));
        return type.ordinal();
    }

    public static enum EnumDungDirection implements IErebusEnum
    {
        DOWN_NORTH,
        DOWN_SOUTH,
        DOWN_WEST,
        DOWN_EAST,
        UP_NORTH,
        UP_SOUTH,
        UP_WEST,
        UP_EAST,
        NORTH,
        SOUTH,
        WEST,
        EAST;


        @Override
        public ItemStack createStack(int size) {
            return new ItemStack(ModBlocks.DUNG_SPAWNER_BOT_FLY, size, this.ordinal());
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

