/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.planetprogression.tileEntities;

import com.mjr.planetprogression.tileEntities.TileEntityTelescope;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.EnumSet;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlock;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;

public class TileEntityTelescopeFake
extends TileBaseElectricBlock {
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public BlockPos mainBlockPosition;
    private WeakReference<TileEntityTelescope> mainTelepad = null;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    private boolean canConnect = false;

    public TileEntityTelescopeFake() {
        super("container.telescope.fake.name");
    }

    public void setMainBlock(BlockPos mainBlock) {
        this.setMainBlockInternal(mainBlock);
        if (!this.field_145850_b.field_72995_K) {
            IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 3);
        }
    }

    private void setMainBlockInternal(BlockPos mainBlock) {
        this.mainBlockPosition = mainBlock;
        this.updateConnectable();
    }

    public void onBlockRemoval() {
        TileEntityTelescope telepad = this.getBaseTelepad();
        if (telepad != null) {
            telepad.onDestroy((TileEntity)this);
        }
    }

    public boolean onActivated(EntityPlayer par5EntityPlayer) {
        TileEntityTelescope telepad = this.getBaseTelepad();
        return telepad != null && telepad.onActivated(par5EntityPlayer);
    }

    public void func_73660_a() {
        super.func_73660_a();
        TileEntityTelescope telepad = this.getBaseTelepad();
        if (telepad != null) {
            this.storage.setCapacity(telepad.storage.getCapacityGC());
            this.storage.setMaxExtract(telepad.storage.getMaxExtract());
            this.storage.setMaxReceive(telepad.storage.getMaxReceive());
            this.extractEnergyGC(null, telepad.receiveEnergyGC(null, this.getEnergyStoredGC(), false), false);
        }
    }

    private TileEntityTelescope getBaseTelepad() {
        TileEntity tileEntity;
        if (this.mainBlockPosition == null) {
            return null;
        }
        if (this.mainTelepad == null && (tileEntity = this.field_145850_b.func_175625_s(this.mainBlockPosition)) != null && tileEntity instanceof TileEntityTelescope) {
            this.mainTelepad = new WeakReference<TileEntityTelescope>((TileEntityTelescope)tileEntity);
        }
        if (this.mainTelepad == null) {
            this.field_145850_b.func_175698_g(this.mainBlockPosition);
        } else {
            TileEntityTelescope telepad = (TileEntityTelescope)((Object)this.mainTelepad.get());
            if (telepad != null) {
                return telepad;
            }
            this.field_145850_b.func_175713_t(this.func_174877_v());
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagCompound tagCompound = nbt.func_74775_l("mainBlockPosition");
        this.setMainBlockInternal(new BlockPos(tagCompound.func_74762_e("x"), tagCompound.func_74762_e("y"), tagCompound.func_74762_e("z")));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (this.mainBlockPosition != null) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            tagCompound.func_74768_a("x", this.mainBlockPosition.func_177958_n());
            tagCompound.func_74768_a("y", this.mainBlockPosition.func_177956_o());
            tagCompound.func_74768_a("z", this.mainBlockPosition.func_177952_p());
            nbt.func_74782_a("mainBlockPosition", (NBTBase)tagCompound);
        }
        return nbt;
    }

    public double getPacketRange() {
        return 30.0;
    }

    public int getPacketCooldown() {
        return 50;
    }

    public boolean isNetworkedTile() {
        return true;
    }

    public void getNetworkedData(ArrayList<Object> sendData) {
        if (this.mainBlockPosition == null && (this.field_145850_b.field_72995_K || !this.resetMainBlockPosition())) {
            return;
        }
        super.getNetworkedData(sendData);
    }

    private boolean resetMainBlockPosition() {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                for (int y = -2; y < 1; y += 2) {
                    BlockPos vecToCheck = this.func_174877_v().func_177982_a(x, y, z);
                    if (!(this.field_145850_b.func_175625_s(vecToCheck) instanceof TileEntityTelescope)) continue;
                    this.setMainBlock(vecToCheck);
                    return true;
                }
            }
        }
        return false;
    }

    public EnumSet<EnumFacing> getElectricalOutputDirections() {
        return EnumSet.noneOf(EnumFacing.class);
    }

    public boolean shouldUseEnergy() {
        return false;
    }

    public float receiveElectricity(EnumFacing from, float energy, int tier, boolean doReceive) {
        return 0.0f;
    }

    public EnumSet<EnumFacing> getElectricalInputDirections() {
        return EnumSet.noneOf(EnumFacing.class);
    }

    public boolean canConnect(EnumFacing direction, NetworkType type) {
        if (direction == null || type == NetworkType.POWER) {
            return false;
        }
        return false;
    }

    public EnumFacing getElectricInputDirection() {
        return null;
    }

    public EnumFacing getFront() {
        return EnumFacing.NORTH;
    }

    public ItemStack getBatteryInSlot() {
        return null;
    }

    private void updateConnectable() {
        if (this.mainBlockPosition != null && this.func_174877_v().func_177958_n() == this.mainBlockPosition.func_177958_n() && this.func_174877_v().func_177952_p() == this.mainBlockPosition.func_177952_p() && this.func_174877_v().func_177956_o() > this.mainBlockPosition.func_177956_o()) {
            this.canConnect = true;
            return;
        }
        this.canConnect = false;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[0];
    }

    protected boolean handleInventory() {
        return false;
    }
}

