/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.planetprogression.entities;

import com.mjr.mjrlegendslib.network.IPacket;
import com.mjr.mjrlegendslib.util.PlayerUtilties;
import com.mjr.mjrlegendslib.util.TranslateUtilities;
import com.mjr.planetprogression.PlanetProgression;
import com.mjr.planetprogression.data.SatelliteData;
import com.mjr.planetprogression.entities.EntitySatelliteAutoRocket;
import com.mjr.planetprogression.handlers.capabilities.CapabilityStatsHandler;
import com.mjr.planetprogression.handlers.capabilities.IStatsCapability;
import com.mjr.planetprogression.item.ItemSatellite;
import com.mjr.planetprogression.item.PlanetProgression_Items;
import com.mjr.planetprogression.network.PacketSimplePP;
import com.mjr.planetprogression.tileEntities.TileEntitySatelliteLandingPad;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import micdoodle8.mods.galacticraft.api.entity.IRocketType;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.api.tile.IFuelDock;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.inventory.ContainerRocketInventory;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class EntitySatelliteRocket
extends EntitySatelliteAutoRocket {
    public IRocketType.EnumRocketType rocketType;
    public float rumble;

    public EntitySatelliteRocket(World world) {
        super(world);
        this.func_70105_a(3.0f, 16.0f);
    }

    public EntitySatelliteRocket(World world, double x, double y, double z, IRocketType.EnumRocketType type) {
        super(world, x, y, z);
        this.rocketType = type;
        this.stacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
    }

    public EntitySatelliteRocket(World world, double x, double y, double z, IRocketType.EnumRocketType type, EntityPlayer playerIn) {
        super(world, x, y, z);
        this.rocketType = type;
        this.stacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        this.placedPlayerUUID = playerIn.func_110124_au().toString();
    }

    public double func_70033_W() {
        return 1.5;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(PlanetProgression_Items.SATELLITE_ROCKET, 1, this.rocketType.getIndex());
    }

    public double func_70042_X() {
        return 0.5;
    }

    public double getOnPadYOffset() {
        return 0.4;
    }

    public float getRenderOffsetY() {
        return 1.1f;
    }

    public int getRocketTier() {
        return Integer.MAX_VALUE;
    }

    public int getFuelTankCapacity() {
        return 1000;
    }

    public int getPreLaunchWait() {
        return 0;
    }

    @Override
    public List<ItemStack> getItemsDropped(List<ItemStack> droppedItems) {
        super.getItemsDropped(droppedItems);
        ItemStack rocket = new ItemStack(PlanetProgression_Items.SATELLITE_ROCKET, 1, this.rocketType.getIndex());
        rocket.func_77982_d(new NBTTagCompound());
        rocket.func_77978_p().func_74768_a("RocketFuel", this.fuelTank.getFluidAmount());
        droppedItems.add(rocket);
        return droppedItems;
    }

    @Override
    public boolean isDockValid(IFuelDock dock) {
        return dock instanceof TileEntitySatelliteLandingPad;
    }

    public String func_70005_c_() {
        return TranslateUtilities.translate((String)"entity.planetprogression.EntitySatelliteRocket.name", (boolean)false);
    }

    public void onReachAtmosphere() {
        EntityPlayerMP player;
        if (!this.field_70170_p.field_72995_K && (player = PlayerUtilties.getPlayerFromUUID((String)this.placedPlayerUUID)) != null) {
            int found = 0;
            for (ItemStack item : this.stacks) {
                String itemName;
                if (item == null || !(item.func_77973_b() instanceof ItemSatellite)) continue;
                ++found;
                IStatsCapability stats = null;
                if (player != null) {
                    stats = (IStatsCapability)player.getCapability(CapabilityStatsHandler.PP_STATS_CAPABILITY, null);
                }
                String id = !(itemName = item.func_82833_r()).equalsIgnoreCase(item.func_82833_r()) ? UUID.randomUUID().toString() : itemName;
                stats.addSatellites(new SatelliteData(((ItemSatellite)item.func_77973_b()).getType(), id, 0, null));
                player.func_145747_a((ITextComponent)new TextComponentString(EnumColor.RED + "Satellite: " + id + " has been launched in to space!"));
            }
            if (found == 0) {
                player.func_145747_a((ITextComponent)new TextComponentString(EnumColor.RED + "No Satellites were found in the rocket!"));
            }
        }
        this.func_70106_y();
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        int i = this.timeUntilLaunch >= 100 ? Math.abs(this.timeUntilLaunch / 100) : 1;
        if ((this.getLaunched() || this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.IGNITED.ordinal() && this.field_70146_Z.nextInt(i) == 0) && !ConfigManagerCore.disableSpaceshipParticles && this.hasValidFuel() && this.field_70170_p.field_72995_K) {
            this.spawnParticles(this.getLaunched());
        }
        if (this.launchPhase >= EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal() && this.hasValidFuel()) {
            if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal()) {
                double d = this.timeSinceLaunch / 150.0f;
                if ((d = Math.min(d, 1.0)) != 0.0) {
                    this.field_70181_x = -d * 2.5 * Math.cos((double)(this.field_70125_A - 180.0f) / 57.2957795);
                }
            } else {
                this.field_70181_x -= 0.008;
            }
            double multiplier = 1.0;
            if (this.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && (multiplier = ((IGalacticraftWorldProvider)this.field_70170_p.field_73011_w).getFuelUsageMultiplier()) <= 0.0) {
                multiplier = 1.0;
            }
            if (this.timeSinceLaunch % (float)MathHelper.func_76128_c((double)(2.0 * (1.0 / multiplier))) == 0.0f) {
                this.removeFuel(1);
                if (!this.hasValidFuel()) {
                    this.stopRocketSound();
                }
            }
        } else if (!this.hasValidFuel() && this.getLaunched() && !this.field_70170_p.field_72995_K && Math.abs(Math.sin(this.timeSinceLaunch / 1000.0f)) / 10.0 != 0.0) {
            this.field_70181_x -= Math.abs(Math.sin(this.timeSinceLaunch / 1000.0f)) / 20.0;
        }
    }

    protected void spawnParticles(boolean launched) {
        if (!this.field_70128_L) {
            double x1 = 3.2 * Math.cos((double)this.field_70177_z / 57.2957795) * Math.sin((double)this.field_70125_A / 57.2957795);
            double z1 = 3.2 * Math.sin((double)this.field_70177_z / 57.2957795) * Math.sin((double)this.field_70125_A / 57.2957795);
            double y1 = 3.2 * Math.cos((double)(this.field_70125_A - 180.0f) / 57.2957795);
            if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.LANDING.ordinal()) {
                double modifier = this.field_70163_u;
                modifier = Math.max(modifier, 1.0);
                x1 *= modifier / 60.0;
                y1 *= modifier / 60.0;
                z1 *= modifier / 60.0;
            }
            double y2 = this.field_70167_r + (this.field_70163_u - this.field_70167_r) + y1;
            double x2 = this.field_70165_t + x1;
            double z2 = this.field_70161_v + z1;
            Vector3 motionVec = new Vector3(x1, y1, z1);
            Vector3 d1 = new Vector3(y1 * 0.1, -x1 * 0.1, z1 * 0.1).rotate(315.0f - this.field_70177_z, motionVec);
            Vector3 d2 = new Vector3(x1 * 0.1, -z1 * 0.1, y1 * 0.1).rotate(315.0f - this.field_70177_z, motionVec);
            Vector3 d3 = new Vector3(-y1 * 0.1, x1 * 0.1, z1 * 0.1).rotate(315.0f - this.field_70177_z, motionVec);
            Vector3 d4 = new Vector3(x1 * 0.1, z1 * 0.1, -y1 * 0.1).rotate(315.0f - this.field_70177_z, motionVec);
            Vector3 mv1 = motionVec.clone().translate(d1);
            Vector3 mv2 = motionVec.clone().translate(d2);
            Vector3 mv3 = motionVec.clone().translate(d3);
            Vector3 mv4 = motionVec.clone().translate(d4);
            EntityLivingBase riddenByEntity = this.func_184188_bt().isEmpty() || !(this.func_184188_bt().get(0) instanceof EntityLivingBase) ? null : (EntityLivingBase)this.func_184188_bt().get(0);
            Object[] rider = new Object[]{riddenByEntity};
            this.makeFlame(x2 + d1.x, y2 + d1.y, z2 + d1.z, mv1, this.getLaunched(), rider);
            this.makeFlame(x2 + d2.x, y2 + d2.y, z2 + d2.z, mv2, this.getLaunched(), rider);
            this.makeFlame(x2 + d3.x, y2 + d3.y, z2 + d3.z, mv3, this.getLaunched(), rider);
            this.makeFlame(x2 + d4.x, y2 + d4.y, z2 + d4.z, mv4, this.getLaunched(), rider);
        }
    }

    private void makeFlame(double x2, double y2, double z2, Vector3 motionVec, boolean getLaunched, Object[] rider) {
        if (getLaunched) {
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0, y2, z2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0), motionVec, rider);
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0, y2, z2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0), motionVec, rider);
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0, y2, z2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0), motionVec, rider);
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0, y2, z2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0), motionVec, rider);
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2, y2, z2), motionVec, rider);
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 + 0.4, y2, z2), motionVec, rider);
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2 - 0.4, y2, z2), motionVec, rider);
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2, y2, z2 + 0.4), motionVec, rider);
            GalacticraftCore.proxy.spawnParticle("launchFlameLaunched", new Vector3(x2, y2, z2 - 0.4), motionVec, rider);
            return;
        }
        double x1 = motionVec.x;
        double y1 = motionVec.y;
        double z1 = motionVec.z;
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0, y2, z2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0), new Vector3(x1 + 0.5, y1 - 0.3, z1 + 0.5), rider);
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0, y2, z2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0), new Vector3(x1 - 0.5, y1 - 0.3, z1 + 0.5), rider);
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0, y2, z2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0), new Vector3(x1 - 0.5, y1 - 0.3, z1 - 0.5), rider);
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 + 0.4 - this.field_70146_Z.nextDouble() / 10.0, y2, z2 - 0.4 + this.field_70146_Z.nextDouble() / 10.0), new Vector3(x1 + 0.5, y1 - 0.3, z1 - 0.5), rider);
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 + 0.4, y2, z2), new Vector3(x1 + 0.8, y1 - 0.3, z1), rider);
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2 - 0.4, y2, z2), new Vector3(x1 - 0.8, y1 - 0.3, z1), rider);
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2, y2, z2 + 0.4), new Vector3(x1, y1 - 0.3, z1 + 0.8), rider);
        GalacticraftCore.proxy.spawnParticle("launchFlameIdle", new Vector3(x2, y2, z2 - 0.4), new Vector3(x1, y1 - 0.3, z1 - 0.8), rider);
    }

    @Override
    public void onPadDestroyed() {
        if (!this.field_70128_L && this.launchPhase != EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal()) {
            this.dropShipAsItem();
            this.func_70106_y();
        }
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K && player instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            playerMP.func_71117_bO();
            playerMP.func_71128_l();
            int windowId = playerMP.field_71139_cq;
            PlanetProgression.packetPipeline.sendTo((IPacket)new PacketSimplePP(PacketSimplePP.EnumSimplePacket.C_OPEN_SATELLITE_ROCKET_GUI, GCCoreUtil.getDimensionID((World)playerMP.field_70170_p), new Object[]{windowId, this.func_145782_y()}), playerMP);
            player.field_71070_bA = new ContainerRocketInventory((IInventory)playerMP.field_71071_by, (IInventory)this, this.rocketType, (EntityPlayer)playerMP);
            player.field_71070_bA.field_75152_c = windowId;
            player.field_71070_bA.func_75132_a((IContainerListener)playerMP);
        }
        return false;
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        nbt.func_74768_a("Type", this.rocketType.getIndex());
        nbt.func_74778_a("PlacedPlayerUUID", this.placedPlayerUUID);
        super.func_70014_b(nbt);
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        this.rocketType = IRocketType.EnumRocketType.values()[nbt.func_74762_e("Type")];
        this.placedPlayerUUID = nbt.func_74779_i("PlacedPlayerUUID");
        super.func_70037_a(nbt);
    }

    public IRocketType.EnumRocketType getType() {
        return this.rocketType;
    }

    public int func_70302_i_() {
        if (this.rocketType == null) {
            return 0;
        }
        return this.rocketType.getInventorySpace();
    }

    @Override
    public void decodePacketdata(ByteBuf buffer) {
        this.rocketType = IRocketType.EnumRocketType.values()[buffer.readInt()];
        super.decodePacketdata(buffer);
        this.field_70165_t = buffer.readDouble() / 8000.0;
        this.field_70163_u = buffer.readDouble() / 8000.0;
        this.field_70161_v = buffer.readDouble() / 8000.0;
    }

    @Override
    public void getNetworkedData(ArrayList<Object> list) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        list.add(this.rocketType != null ? this.rocketType.getIndex() : 0);
        super.getNetworkedData(list);
        list.add(this.field_70165_t * 8000.0);
        list.add(this.field_70163_u * 8000.0);
        list.add(this.field_70161_v * 8000.0);
    }

    public int[] func_180463_a(EnumFacing side) {
        return null;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return false;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return false;
    }
}

