/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.planetprogression.client.handlers;

import com.google.common.collect.Lists;
import com.mjr.mjrlegendslib.util.MessageUtilities;
import com.mjr.mjrlegendslib.util.TranslateUtilities;
import com.mjr.planetprogression.blocks.PlanetProgression_Blocks;
import com.mjr.planetprogression.client.gui.screen.CustomGuiCelestialSelection;
import com.mjr.planetprogression.network.PlanetProgressionPacketHandler;
import java.util.List;
import micdoodle8.mods.galacticraft.core.client.gui.screen.GuiCelestialSelection;
import micdoodle8.mods.galacticraft.core.tick.KeyHandlerClient;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.item.Item;
import net.minecraft.world.World;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MainHandlerClient {
    private static List<PlanetProgressionPacketHandler> packetHandlers = Lists.newCopyOnWriteArrayList();

    public static void addPacketHandler(PlanetProgressionPacketHandler handler) {
        packetHandlers.add(handler);
    }

    @SubscribeEvent
    public void worldUnloadEvent(WorldEvent.Unload event) {
        for (PlanetProgressionPacketHandler packetHandler : packetHandlers) {
            packetHandler.unload(event.getWorld());
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft minecraft = FMLClientHandler.instance().getClient();
        WorldClient world = minecraft.field_71441_e;
        if (event.phase == TickEvent.Phase.END && world != null) {
            for (PlanetProgressionPacketHandler handler : packetHandlers) {
                handler.tick((World)world);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    @SideOnly(value=Side.CLIENT)
    public void onGuiOpenEvent(GuiOpenEvent event) {
        if (!(!(event.getGui() instanceof GuiCelestialSelection) || MainHandlerClient.isClassAvailable("com.mjr.extraplanets.compatibility.PlanetProgressionCompatibility") && event.getGui().getClass().getName().equalsIgnoreCase("com.mjr.extraplanets.client.gui.screen.CustomCelestialSelection") || event.getGui().getClass().getName().equalsIgnoreCase("asmodeuscore.core.astronomy.gui.screen.NewGuiCelestialSelection"))) {
            if (GameSettings.func_100015_a((KeyBinding)KeyHandlerClient.galaxyMap)) {
                event.setGui((GuiScreen)new CustomGuiCelestialSelection(true, ((GuiCelestialSelection)event.getGui()).possibleBodies, ((GuiCelestialSelection)event.getGui()).canCreateStations));
            } else {
                event.setGui((GuiScreen)new CustomGuiCelestialSelection(false, ((GuiCelestialSelection)event.getGui()).possibleBodies, ((GuiCelestialSelection)event.getGui()).canCreateStations));
            }
        }
    }

    public static boolean isClassAvailable(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return clazz != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (Throwable e) {
            MessageUtilities.fatalErrorMessageToLog((String)"planetprogression", (String)"Unknown error when checking for class existing");
            return false;
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onItemTooltip(ItemTooltipEvent event) {
        if (event.getItemStack().func_77973_b().equals(Item.func_150898_a((Block)PlanetProgression_Blocks.SATTLLITE_BUILDER))) {
            event.getToolTip().add(EnumColor.AQUA + TranslateUtilities.translate((String)"satellite.builder.use.desc"));
        } else if (event.getItemStack().func_77973_b().equals(Item.func_150898_a((Block)PlanetProgression_Blocks.SATTLLITE_CONTROLLER))) {
            event.getToolTip().add(EnumColor.AQUA + TranslateUtilities.translate((String)"satellite.controller.use.desc"));
            event.getToolTip().add(EnumColor.AQUA + TranslateUtilities.translate((String)"satellite.controller.use.2.desc"));
            event.getToolTip().add(EnumColor.BRIGHT_GREEN + TranslateUtilities.translate((String)"satellite.controller.use.keycard.desc"));
        } else if (event.getItemStack().func_77973_b().equals(Item.func_150898_a((Block)PlanetProgression_Blocks.TELESCOPE))) {
            event.getToolTip().add(EnumColor.AQUA + TranslateUtilities.translate((String)"telescope.use.desc"));
        }
    }
}

