/*
 * Decompiled with CFR 0.152.
 */
package tonius.simplyjetpacks.util;

import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import tonius.simplyjetpacks.config.Config;
import tonius.simplyjetpacks.setup.ParticleType;
import tonius.simplyjetpacks.util.KeyboardUtil;

public abstract class SJStringUtil {
    private static final String on = TextFormatting.GREEN + SJStringUtil.localize("tooltip.", ".on", new Object[0]);
    private static final String off = TextFormatting.RED + SJStringUtil.localize("tooltip.", ".off", new Object[0]);
    private static final String enabled = TextFormatting.GREEN + SJStringUtil.localize("tooltip.", ".enabled", new Object[0]);
    private static final String disabled = TextFormatting.RED + SJStringUtil.localize("tooltip.", ".disabled", new Object[0]);
    private static final String notAvailable = TextFormatting.DARK_GRAY + SJStringUtil.localize("tooltip.", ".not_available", new Object[0]);
    private static final DecimalFormat formatter = new DecimalFormat("###,###");

    public static String getFormattedNumber(int number) {
        return formatter.format(number);
    }

    public static String getTierText(int tier) {
        return SJStringUtil.localize("tooltip.", ".tier", tier);
    }

    public static String getEnergyText(int amount, int max, boolean infinite) {
        if (infinite) {
            return TextFormatting.GRAY + SJStringUtil.localize("tooltip.", ".energy.infinite", new Object[0]);
        }
        return TextFormatting.GRAY + SJStringUtil.localize("tooltip.", ".energyWithMax", SJStringUtil.getFormattedNumber(amount), SJStringUtil.getFormattedNumber(max));
    }

    public static String getStateText(boolean state) {
        String onOrOff = state ? on : off;
        return TextFormatting.GOLD + SJStringUtil.localize("tooltip.", ".state", new Object[0]) + ": " + onOrOff;
    }

    public static String getHoverModeText(boolean state) {
        String enabledOrDisabled = state ? enabled : disabled;
        return TextFormatting.GOLD + SJStringUtil.localize("tooltip.", ".hover_mode", new Object[0]) + ": " + enabledOrDisabled;
    }

    public static String getChargerStateText(boolean state) {
        String onOrOff = state ? on : off;
        return TextFormatting.GOLD + SJStringUtil.localize("tooltip.", "chargerState", new Object[0]) + ": " + onOrOff;
    }

    public static String getEnergyUsageText(int usage) {
        String usageText = SJStringUtil.localize("tooltip.", ".energyPerTick", SJStringUtil.getFormattedNumber(usage));
        return TextFormatting.GOLD + SJStringUtil.localize("tooltip.", ".energyUsage", new Object[0]) + ": " + TextFormatting.GRAY + usageText;
    }

    public static String getChargerRateText(int rate) {
        String rateText = rate > 0 ? SJStringUtil.localize("tooltip.", ".energyPerTick", SJStringUtil.getFormattedNumber(rate)) : SJStringUtil.localize("tooltip.", ".energy.none", new Object[0]);
        return TextFormatting.GOLD + SJStringUtil.localize("tooltip.", ".chargerRate", new Object[0]) + ": " + TextFormatting.GRAY + rateText;
    }

    public static String getEnergySendText(int send) {
        return TextFormatting.GOLD + SJStringUtil.localize("tooltip.", ".energySend", new Object[0]) + ": " + TextFormatting.GRAY + SJStringUtil.localize("tooltip.", ".energyPerTick", SJStringUtil.getFormattedNumber(send));
    }

    public static String getEnergyReceiveText(int receive) {
        String usageText = receive < Integer.MAX_VALUE ? SJStringUtil.localize("tooltip.", ".energyPerTick", SJStringUtil.getFormattedNumber(receive)) : SJStringUtil.localize("tooltip.", ".energy.none", new Object[0]);
        return TextFormatting.GOLD + SJStringUtil.localize("tooltip.", ".energyReceive", new Object[0]) + ": " + TextFormatting.GRAY + usageText;
    }

    public static String getParticlesText(ParticleType particle) {
        return TextFormatting.GOLD + SJStringUtil.localize("tooltip.", ".particles", new Object[0]) + ": " + TextFormatting.GRAY + SJStringUtil.localize("tooltip.", ".particles." + particle.ordinal(), new Object[0]);
    }

    public static String getHUDEnergyText(String packType, int percent, int energy) {
        String text = "";
        if (!Config.minimalEnergyHUD) {
            text = text + SJStringUtil.localize("gui.", ".hud." + packType + ".energy", new Object[0]) + ": ";
        }
        text = percent > 0 ? text + SJStringUtil.getColoredPercent(percent) + "%" : text + TextFormatting.RED + SJStringUtil.localize("gui.", ".hud.energy.depleted", new Object[0]);
        if (Config.showExactEnergyInHUD) {
            text = text + " (" + SJStringUtil.getFormattedNumber(energy) + " RF)";
        }
        return text;
    }

    public static String getHUDStateText(Boolean engine, Boolean hover, Boolean charger, Boolean eHover) {
        String text = "";
        if (engine != null) {
            text = text + (engine != false ? TextFormatting.GREEN : TextFormatting.RED) + SJStringUtil.localize("gui.", ".hud.state.engine", new Object[0]) + TextFormatting.RESET;
        }
        if (hover != null) {
            if (engine != null) {
                text = text + TextFormatting.GRAY + " - ";
            }
            text = text + (hover != false ? TextFormatting.GREEN : TextFormatting.RED) + SJStringUtil.localize("gui.", ".hud.state.hover", new Object[0]) + TextFormatting.RESET;
        }
        if (charger != null) {
            if (hover != null || engine != null) {
                text = text + TextFormatting.GRAY + " - ";
            }
            text = text + (charger != false ? TextFormatting.GREEN : TextFormatting.RED) + SJStringUtil.localize("gui.", ".hud.state.charger", new Object[0]);
        }
        if (eHover != null) {
            if (hover != null || engine != null || charger != null) {
                text = text + TextFormatting.GRAY + " - ";
            }
            text = text + (eHover != false ? TextFormatting.GREEN : TextFormatting.RED) + SJStringUtil.localize("gui.", ".hud.state.eHover", new Object[0]);
        }
        return text;
    }

    public static String getColoredPercent(int percent) {
        if (percent > 70) {
            return TextFormatting.GREEN.toString() + percent;
        }
        if (percent > 40) {
            return TextFormatting.YELLOW.toString() + percent;
        }
        if (percent > 10) {
            return TextFormatting.GOLD.toString() + percent;
        }
        return TextFormatting.RED.toString() + percent;
    }

    public static String getShiftText() {
        return TextFormatting.GRAY + SJStringUtil.localize("tooltip.", ".holdShift", TextFormatting.YELLOW.toString() + TextFormatting.ITALIC + SJStringUtil.localize("tooltip.", ".holdShift.shift", new Object[0]) + TextFormatting.RESET + TextFormatting.GRAY);
    }

    public static boolean canShowDetails() {
        return !Config.holdShiftForDetails || KeyboardUtil.isShiftKeyDown();
    }

    public static String localize(String prefix, String suffix, Object ... args) {
        String toLocalize = prefix + "simplyjetpacks" + suffix;
        if (args != null && args.length > 0) {
            return I18n.func_74837_a((String)toLocalize, (Object[])args);
        }
        return I18n.func_74838_a((String)toLocalize);
    }

    public static ITextComponent localizeNew(String prefix, String suffix, Object ... args) {
        String toLocalize = prefix + "simplyjetpacks" + suffix;
        if (args != null && args.length > 0) {
            return new TextComponentTranslation(toLocalize, args);
        }
        return new TextComponentTranslation(toLocalize, new Object[0]);
    }

    public static ITextComponent localizeNew(String unlocalized, Object ... args) {
        String toLocalize = "simplyjetpacks." + unlocalized;
        if (args != null && args.length > 0) {
            return new TextComponentTranslation(toLocalize, args);
        }
        return new TextComponentTranslation(toLocalize, new Object[0]);
    }

    public static void addDescriptionLines(List<String> list, String base, String color) {
        String localized;
        String unlocalized;
        int i = 1;
        while (!(unlocalized = "tooltip.simplyjetpacks." + base + ".description." + i).equals(localized = I18n.func_74838_a((String)unlocalized))) {
            list.add(color + localized);
            ++i;
        }
    }

    public static String getEnderiumBonusText() {
        return TextFormatting.BLUE + SJStringUtil.localize("tooltip.", ".enderium_energy_bonus", Float.valueOf(Config.gelidEnderiumEnergyUsageBonus));
    }
}

