/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.wct.items;

import appeng.api.AEApi;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.IGrid;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.security.ISecurityGrid;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.util.Platform;
import com.google.common.base.Splitter;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.text.WordUtils;
import org.lwjgl.input.Keyboard;
import p455w0rd.ae2wtlib.api.ICustomWirelessTerminalItem;
import p455w0rd.ae2wtlib.api.WTApi;
import p455w0rd.ae2wtlib.api.WTGuiObject;
import p455w0rd.ae2wtlib.api.item.ItemBase;
import p455w0rd.ae2wtlib.api.networking.security.WTPlayerSource;
import p455w0rd.ae2wtlib.items.ItemWUT;
import p455w0rd.wct.api.IWirelessCraftingTerminalItem;
import p455w0rd.wct.api.WCTApi;
import p455w0rd.wct.init.ModItems;
import p455w0rd.wct.init.ModNetworking;
import p455w0rd.wct.sync.packets.PacketMagnetFilterHeld;
import p455w0rd.wct.sync.packets.PacketSetMagnetHeld;
import p455w0rd.wct.util.WCTUtils;
import p455w0rdslib.util.EntityItemUtils;
import p455w0rdslib.util.ItemUtils;

public class ItemMagnet
extends ItemBase {
    public static final String MAGNET_SLOT_NBT = "MagnetSlot";
    public static final String MAGNET_FILTER_NBT = "MagnetFilter";
    public static final String TIMER_RESET_NBT = "WCTReset";
    public static final String TIMER_PICKUP_NBT = "WCTPickupTimer";
    public static final String MAGNET_MODE_NBT = "MagnetMode";
    public static final String WHITELISTING_NBT = "Whitelisting";
    public static final String IGNORE_NBT = "IgnoreNBT";
    public static final String IGNORE_META_NBT = "IgnoreMeta";
    public static final String USE_OREDICT_NBT = "UseOreDict";
    public static final String INIT_NBT = "Initialized";
    public static final String ITEMS_NBT = "Items";
    private int distanceFromPlayer;
    private static final String name = "magnet_card";

    public ItemMagnet() {
        super(new ResourceLocation("wct", name));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(@Nonnull ItemStack item) {
        return ItemMagnet.isActivated(item);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public boolean func_77645_m() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack is, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
        list.add(this.color("aqua") + "==============================");
        String shift = I18n.func_74838_a((String)"tooltip.press_shift.desc").replace("Shift", this.color("yellow") + this.color("bold") + this.color("italics") + "Shift" + this.color("gray"));
        if (ItemMagnet.isShiftKeyDown()) {
            String info = I18n.func_74838_a((String)"tooltip.magnet.desc");
            for (String line : Splitter.on((String)"\n").split((CharSequence)WordUtils.wrap((String)info, (int)37, (String)"\n", (boolean)false))) {
                list.add(line.trim());
            }
            list.add("");
            list.add(this.color("italics") + "" + I18n.func_74838_a((String)"tooltip.magnet_set_filter.desc"));
            list.add("");
            String not = I18n.func_74838_a((String)"tooltip.not.desc");
            list.add(I18n.func_74838_a((String)"tooltip.status.desc") + ": " + (ItemMagnet.isActivated(is) ? this.color("green") + I18n.func_74838_a((String)"tooltip.active.desc") : this.color("red") + not + " " + I18n.func_74838_a((String)"tooltip.active.desc")));
            MagnetFunctionMode mode = ItemMagnet.getMagnetFunctionMode(is);
            if (mode != MagnetFunctionMode.INACTIVE) {
                list.add(this.color("white") + "  " + mode.getMessage().replace("-", "\n  -"));
            }
            String white = I18n.func_74838_a((String)"tooltip.magnet_whitelisting.desc");
            String black = I18n.func_74838_a((String)"tooltip.magnet_blacklisting.desc");
            list.add(I18n.func_74838_a((String)"tooltip.filter_mode.desc") + ": " + this.color("white") + (this.getListMode(is) ? white : black));
            String ignoring = I18n.func_74838_a((String)"tooltip.ignoring.desc");
            String nbtData = I18n.func_74838_a((String)"tooltip.nbt.desc");
            String metaData = I18n.func_74838_a((String)"tooltip.meta.desc");
            String usingOreDict = I18n.func_74838_a((String)"tooltip.using.desc") + " " + I18n.func_74838_a((String)"tooltip.oredict.desc");
            list.add((!ItemMagnet.doesMagnetUseOreDict(is) ? " " + not : this.color("green")) + " " + usingOreDict);
            list.add((!ItemMagnet.doesMagnetIgnoreNBT(is) ? " " + not : this.color("green")) + " " + ignoring + " " + nbtData);
            list.add((!ItemMagnet.doesMagnetIgnoreMeta(is) ? " " + not : this.color("green")) + " " + ignoring + " " + metaData);
            NonNullList<ItemStack> filteredItems = ItemMagnet.getFilteredItems(is);
            if (filteredItems != null) {
                list.add("");
                list.add(this.color("gray") + I18n.func_74838_a((String)"tooltip.filtered_items.desc") + ":");
                for (int i = 0; i < filteredItems.size(); ++i) {
                    list.add("  " + ((ItemStack)filteredItems.get(i)).func_82833_r());
                }
            }
            list.add("");
            String onlyWorks = I18n.func_74838_a((String)"tooltip.only_works.desc");
            for (String line : Splitter.on((String)"\n").split((CharSequence)WordUtils.wrap((String)onlyWorks, (int)27, (String)"\n", (boolean)false))) {
                list.add(this.color("white") + this.color("bold") + this.color("italics") + line.trim());
            }
        } else {
            list.add(shift);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private String color(String color) {
        return WTApi.instance().color(color);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isShiftKeyDown() {
        return Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack item = player.func_184586_b(hand);
        if (world.field_72995_K && hand == EnumHand.MAIN_HAND && !item.func_190926_b()) {
            if (!ItemMagnet.isMagnetInitialized(item)) {
                ModNetworking.instance().sendToServer(new PacketMagnetFilterHeld(MagnetItemMode.INIT, true));
            }
            if (player.func_70093_af()) {
                ItemMagnet.cycleMagnetFunctionModeHeld(player);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)item);
            }
            WCTApi.instance().openMagnetGui(player, false, -1);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)item);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)item);
    }

    public void doMagnet(EntityPlayer player, @Nonnull ItemStack wirelessTerminal, boolean isWCTBauble, int wctSlot) {
        World world = player.func_130014_f_();
        ItemStack magnet = ItemMagnet.getMagnetFromWCT(wirelessTerminal);
        if (world.field_72995_K || magnet.func_190926_b() || !ItemMagnet.isActivated(magnet) || player == null || player.func_70093_af()) {
            return;
        }
        this.distanceFromPlayer = 6;
        NonNullList<ItemStack> filteredList = ItemMagnet.getFilteredItems(magnet);
        for (EntityItem entityItem : ItemMagnet.getEntitiesInRange(EntityItem.class, world, player.func_180425_c(), this.distanceFromPlayer)) {
            if (entityItem == null) {
                return;
            }
            if (EntityItemUtils.getThrowerName((EntityItem)entityItem) != null && EntityItemUtils.getThrowerName((EntityItem)entityItem).equals(player.func_70005_c_()) && !EntityItemUtils.canPickup((EntityItem)entityItem)) continue;
            if (entityItem.getEntityData().func_74764_b("PreventRemoteMovement")) {
                return;
            }
            ItemStack itemStackToGet = entityItem.func_92059_d();
            if (itemStackToGet.func_190926_b()) {
                return;
            }
            int stackSize = itemStackToGet.func_190916_E();
            WTGuiObject<IAEItemStack> obj = this.getGuiObject(wirelessTerminal, player);
            boolean ignoreRange = WTApi.instance().hasInfiniteRange(wirelessTerminal);
            boolean hasAxxess = this.hasNetworkAccess(SecurityPermissions.INJECT, true, player, wirelessTerminal);
            if ((!ignoreRange || !hasAxxess) && (!obj.rangeCheck() || !hasAxxess)) continue;
            IAEItemStack ais = (IAEItemStack)((IItemStorageChannel)AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class)).createStack((Object)itemStackToGet);
            ais.setStackSize((long)stackSize);
            if (entityItem.field_70128_L) continue;
            if (this.getListMode(magnet)) {
                if (ItemMagnet.isItemFiltered(magnet, itemStackToGet, filteredList) && !filteredList.isEmpty()) {
                    if (!this.doInject(ais, stackSize, player, wirelessTerminal, entityItem, isWCTBauble, wctSlot)) continue;
                    entityItem.func_70106_y();
                    continue;
                }
                if (ItemMagnet.getMagnetFunctionMode(magnet) != MagnetFunctionMode.ACTIVE_KEEP_IN_INVENTORY) continue;
                this.doInventoryPickup(entityItem, player, itemStackToGet, world, stackSize);
                continue;
            }
            if (!ItemMagnet.isItemFiltered(magnet, itemStackToGet, filteredList) || filteredList.isEmpty()) {
                if (!this.doInject(ais, stackSize, player, wirelessTerminal, entityItem, isWCTBauble, wctSlot)) continue;
                entityItem.func_70106_y();
                continue;
            }
            if (ItemMagnet.getMagnetFunctionMode(magnet) != MagnetFunctionMode.ACTIVE_KEEP_IN_INVENTORY) continue;
            this.doInventoryPickup(entityItem, player, itemStackToGet, world, stackSize);
        }
        for (EntityXPOrb entityXPOrb : ItemMagnet.getEntitiesInRange(EntityXPOrb.class, world, player.func_180425_c(), this.distanceFromPlayer)) {
            if (entityXPOrb.field_70128_L || entityXPOrb.func_82150_aj()) continue;
            int xpAmount = entityXPOrb.field_70530_e;
            entityXPOrb.func_70106_y();
            world.func_184148_a((EntityPlayer)null, entityXPOrb.field_70165_t, entityXPOrb.field_70163_u, entityXPOrb.field_70161_v, SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.1f, 0.5f * ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.8f));
            ItemStack itemstack = EnchantmentHelper.func_92099_a((Enchantment)Enchantments.field_185296_A, (EntityLivingBase)player);
            if (!itemstack.func_190926_b() && itemstack.func_77951_h()) {
                int i = Math.min(this.xpToDurability(xpAmount), itemstack.func_77952_i());
                xpAmount -= this.durabilityToXp(i);
                itemstack.func_77964_b(itemstack.func_77952_i() - i);
            }
            if (xpAmount <= 0) continue;
            player.func_71023_q(xpAmount);
        }
    }

    private boolean doInject(IAEItemStack ais, int stackSize, EntityPlayer player, ItemStack wirelessTerminal, EntityItem itemToGet, boolean isWCTBauble, int wctSlot) {
        WTGuiObject<IAEItemStack> obj;
        ItemStack pickupStack;
        World world = player.func_130014_f_();
        InventoryPlayer playerInv = player.field_71071_by;
        int invSize = playerInv.func_70302_i_();
        if (invSize >= 0 && !WTApi.instance().getConfig().isOldInfinityMechanicEnabled() && !wirelessTerminal.func_190926_b() && WTApi.instance().shouldConsumeBoosters(wirelessTerminal) && !(pickupStack = itemToGet.func_92059_d()).func_190926_b() && pickupStack.func_77973_b() == WTApi.instance().getBoosterCard()) {
            WTApi.instance().addInfinityBoosters(wirelessTerminal, pickupStack);
            WTApi.instance().getNetHandler().sendToDimension(WTApi.instance().getNetHandler().createInfinityEnergySyncPacket(WTApi.instance().getInfinityEnergy(wirelessTerminal), player.func_110124_au(), isWCTBauble, wctSlot), player.func_130014_f_().field_73011_w.getDimension());
            return true;
        }
        ItemStack tempTerminal = wirelessTerminal.func_77946_l();
        if (WTApi.instance().getWUTUtility().isWUT(wirelessTerminal)) {
            tempTerminal = ItemMagnet.getWCTFromWUT(wirelessTerminal);
        }
        WTGuiObject<IAEItemStack> powerSrc = obj = this.getGuiObject(tempTerminal, player);
        WTPlayerSource mySrc = new WTPlayerSource(player, obj);
        ais = (IAEItemStack)Platform.poweredInsert(powerSrc, obj, (IAEStack)ais, (IActionSource)mySrc);
        ItemStack magnet = ItemMagnet.getMagnetFromWCT(wirelessTerminal);
        if (ais != null && !magnet.func_190926_b() && ItemMagnet.getMagnetFunctionMode(magnet) == MagnetFunctionMode.ACTIVE_KEEP_IN_INVENTORY) {
            player.func_71001_a((Entity)itemToGet, stackSize);
            player.field_71071_by.func_70441_a(itemToGet.func_92059_d());
            world.func_184133_a(player, player.func_180425_c(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.1f, 0.5f * ((player.func_130014_f_().field_73012_v.nextFloat() - player.func_130014_f_().field_73012_v.nextFloat()) * 0.7f + 2.0f));
        }
        return ais == null;
    }

    private int durabilityToXp(int durability) {
        return durability / 2;
    }

    private int xpToDurability(int xp) {
        return xp * 2;
    }

    private void doInventoryPickup(EntityItem itemToGet, EntityPlayer player, ItemStack itemStackToGet, World world, int stackSize) {
        if (itemToGet.func_70032_d((Entity)player) <= (float)this.distanceFromPlayer && player.field_71071_by.func_70441_a(itemStackToGet)) {
            player.func_71001_a((Entity)itemToGet, stackSize);
            world.func_184133_a(player, player.func_180425_c(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.1f, 0.5f * ((player.func_130014_f_().field_73012_v.nextFloat() - player.func_130014_f_().field_73012_v.nextFloat()) * 0.7f + 2.0f));
        }
    }

    private static boolean doesMagnetIgnoreNBT(ItemStack magnet) {
        return ItemUtils.readBoolean((ItemStack)magnet, (String)IGNORE_NBT);
    }

    private static boolean doesMagnetIgnoreMeta(ItemStack magnet) {
        return ItemUtils.readBoolean((ItemStack)magnet, (String)IGNORE_META_NBT);
    }

    private static boolean doesMagnetUseOreDict(ItemStack magnet) {
        return ItemUtils.readBoolean((ItemStack)magnet, (String)USE_OREDICT_NBT);
    }

    private static boolean areOresEqual(ItemStack is1, ItemStack is2) {
        int[] list1 = OreDictionary.getOreIDs((ItemStack)is1);
        int[] list2 = OreDictionary.getOreIDs((ItemStack)is2);
        for (int element : list1) {
            for (int element2 : list2) {
                if (element != element2) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isItemFiltered(@Nonnull ItemStack magnet, @Nonnull ItemStack is, NonNullList<ItemStack> itemList) {
        if (!is.func_190926_b() && !itemList.isEmpty()) {
            for (int i = 0; i < itemList.size(); ++i) {
                ItemStack thisStack = (ItemStack)itemList.get(i);
                if (ItemMagnet.doesMagnetUseOreDict(magnet) && ItemMagnet.areOresEqual(is, thisStack)) {
                    return true;
                }
                if (!(ItemMagnet.doesMagnetIgnoreMeta(magnet) && ItemMagnet.doesMagnetIgnoreNBT(magnet) ? is.func_77973_b().equals(thisStack.func_77973_b()) : (ItemMagnet.doesMagnetIgnoreMeta(magnet) && !ItemMagnet.doesMagnetIgnoreNBT(magnet) ? ItemStack.func_77970_a((ItemStack)is, (ItemStack)thisStack) && is.func_77973_b() == thisStack.func_77973_b() : (!ItemMagnet.doesMagnetIgnoreMeta(magnet) && ItemMagnet.doesMagnetIgnoreNBT(magnet) && is.func_77973_b() == thisStack.func_77973_b() ? ItemMagnet.isMetaEqual(is, thisStack) : ItemMagnet.isMetaEqual(is, thisStack) && ItemStack.func_77970_a((ItemStack)is, (ItemStack)thisStack) && is.func_77973_b() == thisStack.func_77973_b())))) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isMetaEqual(@Nonnull ItemStack is1, @Nonnull ItemStack is2) {
        return is1.func_77952_i() == is2.func_77952_i();
    }

    private boolean hasNetworkAccess(SecurityPermissions perm, boolean requirePower, EntityPlayer player, @Nonnull ItemStack wirelessTerm) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        WTGuiObject<IAEItemStack> obj = this.getGuiObject(wirelessTerm, player);
        IGrid g = obj.getTargetGrid();
        if (g != null) {
            IEnergyGrid eg;
            if (requirePower && !(eg = (IEnergyGrid)g.getCache(IEnergyGrid.class)).isNetworkPowered()) {
                return false;
            }
            ISecurityGrid sg = (ISecurityGrid)g.getCache(ISecurityGrid.class);
            if (sg.hasPermission(player, perm)) {
                return true;
            }
        }
        return false;
    }

    public static NonNullList<ItemStack> getFilteredItems(@Nonnull ItemStack magnet) {
        if (magnet.func_190926_b()) {
            return NonNullList.func_191196_a();
        }
        if (magnet.func_77973_b() == ModItems.MAGNET_CARD && magnet.func_77942_o()) {
            NBTTagCompound nbtTC = magnet.func_77978_p();
            if (!nbtTC.func_74764_b(MAGNET_FILTER_NBT)) {
                return NonNullList.func_191196_a();
            }
            NBTTagList tagList = nbtTC.func_150295_c(MAGNET_FILTER_NBT, 10);
            if (tagList.func_74745_c() > 0 && tagList != null) {
                NonNullList itemList = NonNullList.func_191196_a();
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    itemList.add((Object)new ItemStack(tagList.func_150305_b(i)));
                }
                return itemList;
            }
        }
        return NonNullList.func_191196_a();
    }

    @Nonnull
    public static ItemStack getMagnetFromWCT(@Nonnull ItemStack wirelessTerm) {
        if (!wirelessTerm.func_190926_b() && wirelessTerm.func_77942_o() && (wirelessTerm.func_77973_b() instanceof IWirelessCraftingTerminalItem || WTApi.instance().getWUTUtility().doesWUTSupportType(wirelessTerm, IWirelessCraftingTerminalItem.class))) {
            NBTTagList magnetSlot;
            ItemStack magnetItem;
            NBTTagCompound magnetNBT;
            if (WTApi.instance().getWUTUtility().isWUT(wirelessTerm)) {
                // empty if block
            }
            if ((magnetNBT = wirelessTerm.func_179543_a(MAGNET_SLOT_NBT)) != null && (magnetItem = new ItemStack((magnetSlot = magnetNBT.func_150295_c(ITEMS_NBT, 10)).func_150305_b(0))) != null && !magnetItem.func_190926_b() && magnetItem.func_77973_b() == ModItems.MAGNET_CARD) {
                return magnetItem;
            }
        }
        return ItemStack.field_190927_a;
    }

    private static ItemStack getWCTFromWUT(ItemStack wut) {
        ItemStack wct;
        if (!wut.func_190926_b() && wut.func_77942_o() && WTApi.instance().getWUTUtility().doesWUTSupportType(wut, IWirelessCraftingTerminalItem.class) && WTApi.instance().getWUTUtility().isWUT(wut) && WCTUtils.isAnyWCT(wct = ItemWUT.getStoredTerminalByHandler((ItemStack)wut, IWirelessCraftingTerminalItem.class), true) && !WTApi.instance().getWUTUtility().isWUT(wct)) {
            return wct;
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public static ItemStack getMagnetFromInv(@Nonnull InventoryPlayer inv, int slot) {
        ItemStack magnetItem = inv.func_70301_a(slot);
        if (magnetItem != null && !magnetItem.func_190926_b() && magnetItem.func_77973_b() == ModItems.MAGNET_CARD) {
            return magnetItem;
        }
        return ItemStack.field_190927_a;
    }

    private boolean getListMode(@Nonnull ItemStack magnet) {
        if (magnet.func_77973_b() == ModItems.MAGNET_CARD) {
            return ItemMagnet.getItemMode(magnet, 1);
        }
        return true;
    }

    public static boolean getItemMode(@Nonnull ItemStack magnet, int type) {
        if (!magnet.func_77942_o()) {
            magnet.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nbtTC = magnet.func_77978_p();
        if (type == 1) {
            if (nbtTC.func_74764_b(WHITELISTING_NBT)) {
                return nbtTC.func_74767_n(WHITELISTING_NBT);
            }
            return true;
        }
        if (type == 2) {
            if (nbtTC.func_74764_b(IGNORE_NBT)) {
                return nbtTC.func_74767_n(IGNORE_NBT);
            }
            return false;
        }
        if (type == 3) {
            if (nbtTC.func_74764_b(IGNORE_META_NBT)) {
                return nbtTC.func_74767_n(IGNORE_META_NBT);
            }
            return false;
        }
        if (type == 4) {
            if (nbtTC.func_74764_b(USE_OREDICT_NBT)) {
                return nbtTC.func_74767_n(USE_OREDICT_NBT);
            }
            return false;
        }
        return true;
    }

    public static void setItemMode(@Nonnull ItemStack magnet, MagnetItemMode whichMode, boolean isActive) {
        if (!magnet.func_190926_b()) {
            if (!magnet.func_77942_o()) {
                magnet.func_77982_d(new NBTTagCompound());
            }
            magnet.func_77978_p().func_74757_a(whichMode.getNBTKey(), isActive);
        }
    }

    private WTGuiObject<IAEItemStack> getGuiObject(@Nonnull ItemStack it, EntityPlayer player) {
        ICustomWirelessTerminalItem wh;
        if (!it.func_190926_b() && (wh = (ICustomWirelessTerminalItem)AEApi.instance().registries().wireless().getWirelessTerminalHandler(it)) != null) {
            return WTApi.instance().getGUIObject(wh, it, player);
        }
        return null;
    }

    public static List<Entity> getEntitiesInRange(Class<? extends Entity> entityType, World world, BlockPos playerPos, int distance) {
        return world.func_72872_a(entityType, new AxisAlignedBB(playerPos.func_177979_c(distance).func_177985_f(distance).func_177970_e(distance), playerPos.func_177981_b(distance).func_177965_g(distance).func_177964_d(distance)));
    }

    @Nonnull
    public ItemStack getStack() {
        return this.getStack(1);
    }

    @Nonnull
    public ItemStack getStack(int size) {
        return new ItemStack((Item)this, size);
    }

    public static boolean isActivated(@Nonnull ItemStack magnet) {
        return ItemMagnet.isActivated(magnet, false);
    }

    public static boolean isActivated(@Nonnull ItemStack stack, boolean isWCT) {
        ItemStack magnet;
        ItemStack itemStack = magnet = isWCT ? ItemMagnet.getMagnetFromWCT(stack) : stack;
        if (magnet.func_190926_b()) {
            return false;
        }
        return ItemMagnet.getMagnetFunctionMode(magnet) != MagnetFunctionMode.INACTIVE;
    }

    public int func_77626_a(@Nonnull ItemStack stack) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        for (int i = 0; i < 3; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)this, (int)i, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        }
    }

    public static MagnetFunctionMode getMagnetFunctionMode(@Nonnull ItemStack magnet) {
        if (!magnet.func_190926_b()) {
            NBTTagCompound nbt;
            if (!magnet.func_77942_o()) {
                magnet.func_77982_d(new NBTTagCompound());
            }
            if (!(nbt = magnet.func_77978_p()).func_74764_b(MAGNET_MODE_NBT)) {
                nbt.func_74768_a(MAGNET_MODE_NBT, 0);
            }
            int val = nbt.func_74762_e(MAGNET_MODE_NBT);
            return MagnetFunctionMode.VALUES[val];
        }
        return MagnetFunctionMode.INACTIVE;
    }

    @SideOnly(value=Side.CLIENT)
    public static void displayMessage(MagnetFunctionMode mode) {
        Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentString(mode.getMessage()));
    }

    public static void setMagnetFunctionMode(@Nonnull ItemStack stack, MagnetFunctionMode mode) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a(MAGNET_MODE_NBT, mode.ordinal());
    }

    public static MagnetFunctionMode cycleMagnetFunctionMode(@Nonnull ItemStack magnet) {
        if (!magnet.func_190926_b()) {
            int max;
            int newMode = ItemMagnet.getMagnetFunctionMode(magnet).ordinal() + 1;
            if (newMode > (max = MagnetFunctionMode.VALUES.length - 1)) {
                newMode = 0;
            }
            ItemMagnet.setMagnetFunctionMode(magnet, MagnetFunctionMode.VALUES[newMode]);
            return MagnetFunctionMode.VALUES[newMode];
        }
        return MagnetFunctionMode.INACTIVE;
    }

    public static MagnetFunctionMode cycleMagnetFunctionModeWCT(EntityPlayer player, int wctSlot, boolean isBauble) {
        ItemStack magnet = ItemMagnet.getMagnetFromWCT(isBauble ? WTApi.instance().getBaublesUtility().getWTBySlot(player, wctSlot, IWirelessCraftingTerminalItem.class) : WCTUtils.getWCTBySlot(player, wctSlot, false));
        if (player == null || magnet.func_190926_b() || wctSlot < 0) {
            return MagnetFunctionMode.INACTIVE;
        }
        if (!magnet.func_77942_o()) {
            ItemMagnet.setItemMode(magnet, MagnetItemMode.INIT, true);
        }
        MagnetFunctionMode mode = ItemMagnet.cycleMagnetFunctionMode(magnet);
        if (!(player instanceof EntityPlayerMP)) {
            // empty if block
        }
        return mode;
    }

    public static void cycleMagnetFunctionModeHeld(@Nonnull EntityPlayer player) {
        if (player == null || player.func_184614_ca().func_190926_b() || player.func_184614_ca().func_77973_b() != ModItems.MAGNET_CARD) {
            return;
        }
        ItemStack magnet = ItemMagnet.getHeldMagnet(player);
        if (magnet.func_190926_b()) {
            return;
        }
        if (!magnet.func_77942_o()) {
            ItemMagnet.setItemMode(magnet, MagnetItemMode.INIT, true);
        }
        MagnetFunctionMode mode = ItemMagnet.cycleMagnetFunctionMode(magnet);
        if (!(player instanceof EntityPlayerMP)) {
            ItemMagnet.displayMessage(mode);
            ModNetworking.instance().sendToServer(new PacketSetMagnetHeld(mode));
        }
    }

    @Nonnull
    public static ItemStack getHeldMagnet(EntityPlayer player) {
        if (!player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b() == ModItems.MAGNET_CARD) {
            return player.func_184614_ca();
        }
        return ItemStack.field_190927_a;
    }

    public static boolean isMagnetInitialized(@Nonnull ItemStack magnetItem) {
        if (!magnetItem.func_190926_b() && magnetItem.func_77973_b() == ModItems.MAGNET_CARD) {
            if (!magnetItem.func_77942_o()) {
                magnetItem.func_77982_d(new NBTTagCompound());
            }
            if (!magnetItem.func_77978_p().func_74764_b(INIT_NBT)) {
                magnetItem.func_77978_p().func_74757_a(INIT_NBT, true);
            }
        }
        return magnetItem.func_77978_p().func_74767_n(INIT_NBT);
    }

    public static boolean isMagnetInstalled(EntityPlayer player, boolean isBauble, int slot) {
        return ItemMagnet.isMagnetInstalled(isBauble ? WTApi.instance().getBaublesUtility().getWTBySlot(player, slot, IWirelessCraftingTerminalItem.class) : WCTUtils.getWCTBySlot(player, slot, false));
    }

    public static boolean isMagnetInstalled(ItemStack wirelessTerm) {
        ItemStack magnetItem;
        NBTTagCompound magnetNBTForm;
        NBTTagList magnetList;
        NBTTagCompound magnetNBT;
        return !wirelessTerm.func_190926_b() && WCTUtils.isAnyWCT(wirelessTerm) && wirelessTerm.func_77942_o() && wirelessTerm.func_77978_p().func_74764_b(MAGNET_SLOT_NBT) && (magnetNBT = wirelessTerm.func_179543_a(MAGNET_SLOT_NBT)) != null && (magnetList = magnetNBT.func_150295_c(ITEMS_NBT, 10)) != null && !magnetList.func_82582_d() && (magnetNBTForm = magnetList.func_150305_b(0)) != null && !(magnetItem = new ItemStack(magnetNBTForm)).func_190926_b() && magnetItem.func_77973_b() instanceof ItemMagnet;
    }

    public static void removeTimerTags(ItemStack is) {
        if (is.func_190926_b() || !is.func_77942_o()) {
            return;
        }
        if (is.func_77978_p().func_74764_b(TIMER_RESET_NBT)) {
            is.func_77982_d(null);
        }
        if (is.func_77978_p() != null && is.func_77978_p().func_74764_b(TIMER_PICKUP_NBT)) {
            is.func_77978_p().func_82580_o(TIMER_PICKUP_NBT);
        }
    }

    public static enum MagnetItemMode {
        INIT("Initialized"),
        WHITELIST("Whitelisting"),
        IGNORENBT("IgnoreNBT"),
        IGNOREMETA("IgnoreMeta"),
        USEOREDICT("UseOreDict");

        String nbtKey;
        public static MagnetItemMode[] VALUES;

        private MagnetItemMode(String nbtKey) {
            this.nbtKey = nbtKey;
        }

        public String getNBTKey() {
            return this.nbtKey;
        }

        static {
            VALUES = new MagnetItemMode[]{INIT, WHITELIST, IGNORENBT, IGNOREMETA, USEOREDICT};
        }
    }

    public static enum MagnetFunctionMode {
        INACTIVE(I18n.func_74838_a((String)"chatmessages.magnet_deactivated.desc")),
        ACTIVE_KEEP_IN_INVENTORY(I18n.func_74838_a((String)"chatmessages.magnet_activated.desc") + " - " + I18n.func_74838_a((String)"tooltip.magnet_active_1.desc")),
        ACTIVE_LEAVE_ON_GROUND(I18n.func_74838_a((String)"chatmessages.magnet_activated.desc") + " - " + I18n.func_74838_a((String)"tooltip.magnet_active_2.desc"));

        String message;
        public static MagnetFunctionMode[] VALUES;

        private MagnetFunctionMode(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        static {
            VALUES = new MagnetFunctionMode[]{INACTIVE, ACTIVE_KEEP_IN_INVENTORY, ACTIVE_LEAVE_ON_GROUND};
        }
    }
}

