/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.render;

import com.google.common.collect.Maps;
import java.beans.ConstructorProperties;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import team.chisel.api.block.ICarvable;
import team.chisel.api.block.VariationData;
import team.chisel.common.Reference;

public enum ChiselModelRegistry implements Reference
{
    INSTANCE;


    public <T extends Block> void register(@Nonnull T block) {
        ChiselStateMapper<T> mapper = new ChiselStateMapper<T>(block);
        ModelLoader.setCustomStateMapper(block, mapper);
        Item item = Item.func_150898_a(block);
        if (item == null) {
            return;
        }
        for (VariationData var : ((ICarvable)block).getVariations()) {
            if (var.name.isEmpty()) continue;
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)(var.index - ((ICarvable)block).getIndex() * 16), (ModelResourceLocation)mapper.getModelResourceLocation(var, "inventory"));
        }
        ModelLoader.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[0]);
    }

    private static class ChiselStateMapper<T extends Block>
    extends StateMapperBase {
        private final T block;

        ModelResourceLocation getModelResourceLocation(VariationData data, String variant) {
            String name = this.block.getRegistryName().func_110623_a();
            while (Character.isDigit(name.charAt(name.length() - 1))) {
                name = name.substring(0, name.length() - 1);
            }
            if (this.block.func_176194_O().func_177623_d().size() > 1) {
                return new ModelResourceLocation(new ResourceLocation("chisel", data.path), variant);
            }
            int lastslash = data.path.lastIndexOf(47);
            return new ModelResourceLocation(new ResourceLocation("chisel", data.path.substring(0, lastslash)), data.path.substring(lastslash + 1));
        }

        protected ModelResourceLocation func_178132_a(@Nonnull IBlockState state) {
            VariationData data = ((ICarvable)this.block).getVariationData(((ICarvable)this.block).getVariationIndex(state));
            LinkedHashMap map = Maps.newLinkedHashMap((Map)state.func_177228_b());
            map.remove(((ICarvable)this.block).getMetaProp());
            return this.getModelResourceLocation(data, this.func_178131_a(map));
        }

        @ConstructorProperties(value={"block"})
        public ChiselStateMapper(T block) {
            this.block = block;
        }

        public T getBlock() {
            return this.block;
        }
    }
}

