/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.utils.portals.description;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import divinerpg.utils.PositionHelper;
import divinerpg.utils.portals.description.IPortalDescription;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockWorldState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.block.state.pattern.BlockStateMatcher;
import net.minecraft.block.state.pattern.FactoryBlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class NetherLikePortalDescription
implements IPortalDescription {
    private final BlockPattern fullPattern;
    private final BlockPattern framePattern;
    private final Block frame;
    private final Block portal;

    public NetherLikePortalDescription(Block frame, Block portal) {
        this.frame = frame;
        this.portal = portal;
        this.fullPattern = FactoryBlockPattern.func_177660_a().func_177659_a(new String[]{"?xx?"}).func_177659_a(new String[]{"x..x"}).func_177659_a(new String[]{"x..x"}).func_177659_a(new String[]{"x..x"}).func_177659_a(new String[]{"?xx?"}).func_177662_a('?', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.field_185928_a)).func_177662_a('x', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)this.getFrame()))).func_177662_a('.', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)this.getPortal()))).func_177661_b();
        this.framePattern = FactoryBlockPattern.func_177660_a().func_177659_a(new String[]{"?xx?"}).func_177659_a(new String[]{"x??x"}).func_177659_a(new String[]{"x??x"}).func_177659_a(new String[]{"x??x"}).func_177659_a(new String[]{"?xx?"}).func_177662_a('?', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.field_185928_a)).func_177662_a('x', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)this.getFrame()))).func_177661_b();
    }

    @Override
    public Block getFrame() {
        return this.frame;
    }

    @Override
    public Block getPortal() {
        return this.portal;
    }

    @Override
    public BlockPos getMaxSize() {
        return new BlockPos(4, 4, 4);
    }

    @Override
    public List<BlockPos> checkChunk(World world, BlockPos min, BlockPos max) {
        ArrayList<BlockPos> poses = new ArrayList<BlockPos>();
        Iterable zDirPoses = BlockPos.func_177980_a((BlockPos)min, (BlockPos)new BlockPos(min.func_177958_n(), min.func_177956_o(), max.func_177952_p()));
        Iterable xDirPoses = BlockPos.func_177980_a((BlockPos)new BlockPos(min.func_177958_n(), max.func_177956_o(), min.func_177952_p()), (BlockPos)new BlockPos(max.func_177958_n(), max.func_177956_o(), min.func_177952_p()));
        Iterables.concat((Iterable)zDirPoses, (Iterable)xDirPoses).forEach(x -> {
            Block block = world.func_180495_p(x).func_177230_c();
            if (block == this.getFrame() || block == this.getPortal()) {
                poses.add((BlockPos)x);
            }
        });
        return poses;
    }

    @Override
    public BlockPattern.PatternHelper createPortal(World world, BlockPos pos) {
        int i;
        BlockPos rightBottom = pos.func_177974_f();
        BlockPos leftTop = rightBottom.func_177967_a(EnumFacing.WEST, 3).func_177967_a(EnumFacing.UP, 4);
        for (i = 0; i < 5; ++i) {
            world.func_175656_a(leftTop.func_177979_c(i), this.frame.func_176223_P());
            world.func_175656_a(rightBottom.func_177981_b(i), this.frame.func_176223_P());
        }
        for (i = 0; i < 4; ++i) {
            world.func_175656_a(leftTop.func_177965_g(i), this.frame.func_176223_P());
            world.func_175656_a(rightBottom.func_177985_f(i), this.frame.func_176223_P());
        }
        List<BlockPos> platformBlocks = Arrays.asList(rightBottom.func_177976_e().func_177978_c(), rightBottom.func_177976_e().func_177968_d(), rightBottom.func_177985_f(2).func_177978_c(), rightBottom.func_177985_f(2).func_177968_d());
        if (platformBlocks.stream().flatMap(x -> Stream.of(x, x.func_177977_b())).anyMatch(arg_0 -> ((World)world).func_175623_d(arg_0))) {
            platformBlocks.forEach(x -> world.func_175656_a(x, this.frame.func_176223_P()));
        }
        this.lightPortal(world, leftTop, EnumFacing.SOUTH, EnumFacing.DOWN);
        return this.matchFrame(world, pos);
    }

    @Override
    public void lightPortal(World world, BlockPattern.PatternHelper frameMatch) {
        EnumFacing right = frameMatch.func_177668_c();
        EnumFacing down = frameMatch.func_177669_b();
        BlockPos topLeft = frameMatch.func_181117_a();
        this.lightPortal(world, topLeft, right, down);
    }

    @Override
    @Nullable
    public BlockPattern.PatternHelper matchWorkingPortal(World world, BlockPos pos) {
        return this.fullPattern.func_177681_a(world, pos);
    }

    @Override
    @Nullable
    public BlockPattern.PatternHelper matchFrame(World world, BlockPos pos) {
        return this.framePattern.func_177681_a(world, pos);
    }

    @Override
    public BlockPos getPlayerPortalPosition(World world, Entity e, BlockPattern.PatternHelper fullMatch) {
        BlockPos.MutableBlockPos topLeft = new BlockPos.MutableBlockPos(fullMatch.func_181117_a());
        BlockPos bottomBlock = topLeft.func_177967_a(fullMatch.func_177668_c(), fullMatch.func_181119_e());
        if (topLeft.func_177956_o() > bottomBlock.func_177956_o()) {
            topLeft.func_185336_p(bottomBlock.func_177956_o());
        }
        bottomBlock = topLeft.func_177967_a(fullMatch.func_177669_b(), fullMatch.func_181118_d());
        if (topLeft.func_177956_o() > bottomBlock.func_177956_o()) {
            topLeft.func_185336_p(bottomBlock.func_177956_o());
        }
        return PositionHelper.searchInRadius(world, (BlockPos)topLeft, 3, x -> {
            if (x.func_177956_o() != topLeft.func_177956_o()) {
                return false;
            }
            IBlockState state = world.func_180495_p(x);
            if (!state.isSideSolid((IBlockAccess)world, x, EnumFacing.UP)) {
                return false;
            }
            return !world.func_180495_p(x.func_177984_a()).func_191058_s() && !world.func_180495_p(x.func_177981_b(2)).func_191058_s();
        }).func_177984_a();
    }

    private void lightPortal(World world, BlockPos topLeft, EnumFacing right, EnumFacing down) {
        right = right.func_176735_f();
        topLeft = topLeft.func_177967_a(right, 1).func_177967_a(down, 1);
        IBlockState state = this.fillWithProps(this.portal.func_176223_P(), right);
        for (int i = 0; i < 3; ++i) {
            world.func_175656_a(topLeft.func_177967_a(down, i), state);
            world.func_175656_a(topLeft.func_177967_a(down, i).func_177972_a(right), state);
        }
    }

    private IBlockState fillWithProps(IBlockState state, EnumFacing facing) {
        if (state.func_177227_a().contains(BlockPortal.field_176550_a)) {
            state = state.func_177226_a((IProperty)BlockPortal.field_176550_a, (Comparable)facing.func_176740_k());
        }
        return state;
    }
}

