/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.utils.portals.description;

import com.google.common.base.Predicate;
import divinerpg.registry.DimensionRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockWorldState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.block.state.pattern.BlockStateMatcher;
import net.minecraft.block.state.pattern.FactoryBlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;

public class ArcanaPortalRoomDescription {
    private final DimensionType arcanaDimType;
    private final BlockPattern fullPattern;
    private final BlockPattern fullSizePattern;
    private final BlockPattern fullSizeFramePattern;
    private final BlockPattern framePattern;
    private final Block frame;
    private final Block portal;

    public ArcanaPortalRoomDescription(Block frame, Block portal) {
        this.frame = frame;
        this.portal = portal;
        this.arcanaDimType = DimensionRegistry.arcanaDimension;
        BlockStateMatcher southFrame = BlockStateMatcher.func_177638_a((Block)this.getFrame()).func_177637_a((IProperty)BlockHorizontal.field_185512_D, enumFacing -> Objects.equals(enumFacing, EnumFacing.SOUTH));
        BlockStateMatcher westFrame = BlockStateMatcher.func_177638_a((Block)this.getFrame()).func_177637_a((IProperty)BlockHorizontal.field_185512_D, enumFacing -> Objects.equals(enumFacing, EnumFacing.WEST));
        BlockStateMatcher northFrame = BlockStateMatcher.func_177638_a((Block)this.getFrame()).func_177637_a((IProperty)BlockHorizontal.field_185512_D, enumFacing -> Objects.equals(enumFacing, EnumFacing.NORTH));
        BlockStateMatcher eastFrame = BlockStateMatcher.func_177638_a((Block)this.getFrame()).func_177637_a((IProperty)BlockHorizontal.field_185512_D, enumFacing -> Objects.equals(enumFacing, EnumFacing.EAST));
        this.framePattern = FactoryBlockPattern.func_177660_a().func_177659_a(new String[]{"?vvv?", ">???<", ">???<", ">???<", "?^^^?"}).func_177662_a('?', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.field_185928_a)).func_177662_a('^', BlockWorldState.func_177510_a((Predicate)southFrame)).func_177662_a('>', BlockWorldState.func_177510_a((Predicate)westFrame)).func_177662_a('v', BlockWorldState.func_177510_a((Predicate)northFrame)).func_177662_a('<', BlockWorldState.func_177510_a((Predicate)eastFrame)).func_177661_b();
        this.fullPattern = FactoryBlockPattern.func_177660_a().func_177659_a(new String[]{"?vvv?", ">ppp<", ">ppp<", ">ppp<", "?^^^?"}).func_177662_a('?', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.field_185928_a)).func_177662_a('p', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)this.getPortal()))).func_177662_a('^', BlockWorldState.func_177510_a((Predicate)southFrame)).func_177662_a('>', BlockWorldState.func_177510_a((Predicate)westFrame)).func_177662_a('v', BlockWorldState.func_177510_a((Predicate)northFrame)).func_177662_a('<', BlockWorldState.func_177510_a((Predicate)eastFrame)).func_177661_b();
        this.fullSizePattern = FactoryBlockPattern.func_177660_a().func_177659_a(new String[]{"?vvvv?", ">pppp<", ">pppp<", ">pppp<", ">pppp<", "?^^^^?"}).func_177662_a('?', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.field_185928_a)).func_177662_a('p', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)this.getPortal()))).func_177662_a('^', BlockWorldState.func_177510_a((Predicate)southFrame)).func_177662_a('>', BlockWorldState.func_177510_a((Predicate)westFrame)).func_177662_a('v', BlockWorldState.func_177510_a((Predicate)northFrame)).func_177662_a('<', BlockWorldState.func_177510_a((Predicate)eastFrame)).func_177661_b();
        this.fullSizeFramePattern = FactoryBlockPattern.func_177660_a().func_177659_a(new String[]{"?vvvv?", ">????<", ">????<", ">????<", ">????<", "?^^^^?"}).func_177662_a('?', BlockWorldState.func_177510_a((Predicate)BlockStateMatcher.field_185928_a)).func_177662_a('^', BlockWorldState.func_177510_a((Predicate)southFrame)).func_177662_a('>', BlockWorldState.func_177510_a((Predicate)westFrame)).func_177662_a('v', BlockWorldState.func_177510_a((Predicate)northFrame)).func_177662_a('<', BlockWorldState.func_177510_a((Predicate)eastFrame)).func_177661_b();
    }

    public Block getFrame() {
        return this.frame;
    }

    public Block getPortal() {
        return this.portal;
    }

    public BlockPos getMaxSize() {
        return new BlockPos(5, 1, 5);
    }

    public List<BlockPos> checkChunk(World world, BlockPos min, BlockPos max) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        BlockPos pos = min.func_177982_a(2, 0, 2);
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block == this.getFrame() || block == this.getPortal()) {
            result.add(pos);
        }
        return result;
    }

    public void lightPortal(World world, BlockPattern.PatternHelper frameMatch) {
        int width = frameMatch.func_181118_d() - 2;
        EnumFacing forward = frameMatch.func_177668_c().func_176734_d();
        EnumFacing right = forward.func_176735_f();
        BlockPos pos = frameMatch.func_181117_a();
        IBlockState portalState = this.getPortal().func_176223_P();
        for (int x = 1; x <= width; ++x) {
            for (int z = 1; z <= width; ++z) {
                world.func_175656_a(pos.func_177967_a(right, x).func_177967_a(forward, z), portalState);
            }
        }
    }

    public BlockPattern.PatternHelper matchWorkingPortal(World world, BlockPos pos) {
        if (world.field_73011_w.func_186058_p() == this.arcanaDimType) {
            return this.fullSizePattern.func_177681_a(world, pos);
        }
        return this.fullPattern.func_177681_a(world, pos);
    }

    public BlockPattern.PatternHelper matchFrame(World world, BlockPos pos) {
        if (world.field_73011_w.func_186058_p() == this.arcanaDimType) {
            return this.fullSizeFramePattern.func_177681_a(world, pos);
        }
        return this.framePattern.func_177681_a(world, pos);
    }

    public BlockPos getPlayerPortalPosition(World world, Entity e, BlockPattern.PatternHelper fullMatch) {
        return fullMatch.func_181117_a().func_177972_a(fullMatch.func_177668_c()).func_177972_a(fullMatch.func_177668_c().func_176735_f()).func_177984_a();
    }
}

