/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.objects.items.vanilla;

import divinerpg.objects.items.base.ItemMod;
import divinerpg.registry.DivineRPGTabs;
import divinerpg.utils.LocalizeUtils;
import divinerpg.utils.SecondaryTeleporter;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ITeleporter;

public class ItemTeleportationCrystal
extends ItemMod {
    public ItemTeleportationCrystal(String name) {
        super(name);
        this.func_77637_a(DivineRPGTabs.UTILITY);
        this.func_77656_e(10);
        this.func_77625_d(1);
    }

    public static void teleportToDimension(Entity player, DimensionType dimension, BlockPos pos) {
        if (player == null || dimension == null || pos == null) {
            return;
        }
        MinecraftServer server = player.func_184102_h();
        if (server == null) {
            return;
        }
        if (player.field_70170_p.field_73011_w.func_186058_p() != dimension) {
            SecondaryTeleporter teleporter = new SecondaryTeleporter(server.func_71218_a(dimension.func_186068_a()), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            player.changeDimension(dimension.func_186068_a(), (ITeleporter)teleporter);
        }
        player.func_70634_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flagIn) {
        list.add(LocalizeUtils.i18n("tooltip.teleport_bed_spawn", new Object[0]));
        list.add(LocalizeUtils.usesRemaining(stack.func_77958_k() - stack.func_77960_j()));
    }

    @Nullable
    protected BlockPos getSavedPos(EntityPlayer player, ItemStack stack) {
        BlockPos bedLocation = player.getBedLocation(this.getSavedDimType(player, stack).func_186068_a());
        if (bedLocation != null) {
            if (EntityPlayer.func_180467_a((World)player.field_70170_p, (BlockPos)bedLocation, (boolean)true) == null) {
                bedLocation = player.field_70170_p.func_175672_r(bedLocation);
            }
        } else if (player.func_184102_h() != null) {
            bedLocation = player.func_184102_h().func_71218_a(this.getSavedDimType(player, stack).func_186068_a()).func_175694_M();
        }
        return bedLocation;
    }

    protected DimensionType getSavedDimType(EntityPlayer player, ItemStack stack) {
        return DimensionType.OVERWORLD;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.field_70170_p.field_72995_K) {
            BlockPos pos = this.getSavedPos(player, stack);
            DimensionType dimType = this.getSavedDimType(player, stack);
            ItemTeleportationCrystal.teleportToDimension((Entity)player, dimType, pos);
            if (!player.func_184812_l_()) {
                stack.func_77972_a(1, (EntityLivingBase)player);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }
}

