/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.objects.items.base;

import divinerpg.DivineRPG;
import divinerpg.api.DivineAPI;
import divinerpg.api.arcana.IArcana;
import divinerpg.enums.BulletType;
import divinerpg.enums.ParticleType;
import divinerpg.objects.entities.entity.projectiles.EntityColoredBullet;
import divinerpg.objects.entities.entity.projectiles.EntityParticleBullet;
import divinerpg.objects.entities.entity.projectiles.EntityShooterBullet;
import divinerpg.objects.items.base.ItemMod;
import divinerpg.registry.DivineRPGTabs;
import divinerpg.utils.LocalizeUtils;
import divinerpg.utils.PositionHelper;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RangedWeaponBase
extends ItemMod {
    private final Class<? extends EntityThrowable> clazz;
    private final SoundEvent sound;
    private final SoundCategory soundCategory;
    private final int delay;
    private final Supplier<Item> ammoSupplier;
    private int arcanaConsuming;
    private final String delayTagName = "CanShootTime";
    protected BulletType bulletType;

    public RangedWeaponBase(String name, Class<? extends EntityThrowable> clazz, BulletType bulletType, SoundEvent sound, SoundCategory soundCategory, int maxDamage, int delay, Supplier<Item> ammoSupplier, int arcanaConsuming) {
        super(name, DivineRPGTabs.RANGED_WEAPONS);
        this.func_77656_e(maxDamage);
        this.func_77625_d(1);
        this.clazz = clazz;
        this.sound = sound;
        this.soundCategory = soundCategory;
        this.delay = delay;
        this.ammoSupplier = ammoSupplier == null ? () -> null : ammoSupplier;
        this.arcanaConsuming = arcanaConsuming;
        this.bulletType = bulletType;
    }

    public RangedWeaponBase(String name, BulletType bulletType, SoundEvent shotSound, Supplier<Item> ammoSupplier, int maxDamange, int counter) {
        this(name, null, bulletType, shotSound, SoundCategory.MASTER, maxDamange, counter, ammoSupplier, 0);
    }

    public RangedWeaponBase(String name, BulletType bulletType, SoundEvent shotSound, int uses, int counter) {
        this(name, bulletType, shotSound, () -> null, uses, counter);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (this.bulletType != null) {
            tooltip.add(LocalizeUtils.rangedDam(this.bulletType.getDamage()));
        }
        EntityPlayer player = DivineRPG.proxy.getPlayer();
        if (!this.needsAmmo() || player == null) {
            tooltip.add(LocalizeUtils.infiniteAmmo());
        } else {
            ItemStack ammo = this.findAmmo(player);
            tooltip.add(LocalizeUtils.ammo(this.getAmmo(), ammo != null));
        }
        tooltip.add(stack.func_77958_k() == -1 ? LocalizeUtils.infiniteUses() : LocalizeUtils.usesRemaining(stack.func_77958_k() - stack.func_77960_j()));
        if (this.arcanaConsuming > 0) {
            tooltip.add(LocalizeUtils.arcanaConsumed(this.arcanaConsuming));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        EnumActionResult result = EnumActionResult.FAIL;
        if (this.canUseRangedWeapon(player, stack)) {
            ActionResult<ItemStack> ammo = this.tryFindAmmo(player);
            ActionResult<IArcana> checkArcana = this.tryCheckArcana(player);
            if (ammo.func_188397_a() == EnumActionResult.SUCCESS && checkArcana.func_188397_a() == EnumActionResult.SUCCESS) {
                ItemStack ammoStack;
                IArcana arcana;
                this.doPreUsageEffects(world, player);
                if (!world.field_72995_K) {
                    world.func_184133_a(null, player.func_180425_c(), this.sound != null ? this.sound : SoundEvents.field_187737_v, this.soundCategory != null ? this.soundCategory : SoundCategory.MASTER, 1.0f, 1.0f);
                    this.spawnEntity(world, player, stack, this.bulletType, this.clazz);
                }
                if ((arcana = (IArcana)checkArcana.func_188398_b()) != null) {
                    arcana.consume(player, this.arcanaConsuming);
                }
                if ((ammoStack = (ItemStack)ammo.func_188398_b()) != null) {
                    ammoStack.func_190918_g(1);
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_77972_a(1, (EntityLivingBase)player);
                }
                player.func_184811_cZ().func_185145_a(stack.func_77973_b(), this.delay * 4 + 1);
                if (player instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)player).func_71120_a(player.field_71069_bz);
                }
                this.doPostUsageEffects(world, player);
            }
        }
        return new ActionResult(result, (Object)stack);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    private Item getAmmo() {
        return this.ammoSupplier.get();
    }

    private boolean needsAmmo() {
        return this.ammoSupplier.get() != null;
    }

    private boolean isAmmo(@Nullable ItemStack stack) {
        return stack != null && stack.func_77973_b() == this.getAmmo();
    }

    private ItemStack findAmmo(EntityPlayer player) {
        if (this.isAmmo(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (this.isAmmo(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.isAmmo(itemstack)) continue;
            return itemstack;
        }
        return null;
    }

    protected ActionResult<ItemStack> tryFindAmmo(EntityPlayer player) {
        ItemStack stack = null;
        EnumActionResult result = EnumActionResult.SUCCESS;
        if (!player.field_71075_bZ.field_75098_d && this.needsAmmo() && ((stack = this.findAmmo(player)) == null || stack.func_190916_E() < 1)) {
            result = EnumActionResult.FAIL;
        }
        return new ActionResult(result, stack);
    }

    protected ActionResult<IArcana> tryCheckArcana(EntityPlayer player) {
        IArcana arcana = null;
        EnumActionResult result = EnumActionResult.SUCCESS;
        if (!player.field_71075_bZ.field_75098_d && this.arcanaConsuming > 0 && ((arcana = DivineAPI.getArcana((Entity)player)) == null || arcana.getArcana() < (float)this.arcanaConsuming)) {
            result = EnumActionResult.FAIL;
        }
        return new ActionResult(result, arcana);
    }

    protected boolean canUseRangedWeapon(EntityPlayer player, ItemStack stack) {
        return player.field_71075_bZ.field_75098_d || stack.func_77958_k() <= 0 || stack.func_77952_i() < stack.func_77958_k();
    }

    protected void spawnEntity(World world, EntityPlayer player, ItemStack stack, BulletType bulletType, Class<? extends EntityThrowable> clazz) {
        EntityShooterBullet bullet = null;
        if (clazz != null) {
            try {
                bullet = clazz.getConstructor(World.class, EntityPlayer.class).newInstance(world, player);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e.getMessage());
            }
        } else {
            bullet = bulletType.getParticle() != ParticleType.NONE ? new EntityParticleBullet(world, (EntityLivingBase)player, bulletType) : (bulletType.getColor() != null ? new EntityColoredBullet(world, (EntityLivingBase)player, bulletType) : new EntityShooterBullet(world, (EntityLivingBase)player, bulletType));
        }
        PositionHelper.moveBullet(player, bullet);
        bullet.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.5f, 1.0f);
        world.func_72838_d((Entity)bullet);
    }

    protected void doPreUsageEffects(World world, EntityPlayer player) {
    }

    protected void doPostUsageEffects(World world, EntityPlayer player) {
    }
}

