/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.objects.items.arcana;

import com.google.common.collect.Multimap;
import divinerpg.api.DivineAPI;
import divinerpg.api.arcana.IArcana;
import divinerpg.capabilities.item.DivineItemStackCapability;
import divinerpg.capabilities.item.DivineItemStackCapabilityProvider;
import divinerpg.objects.items.base.ItemModSword;
import divinerpg.utils.LocalizeUtils;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class ItemArcanaPoweredSword
extends ItemModSword {
    public int arcanaConsumed;
    public float weakenedDamageValue;

    public ItemArcanaPoweredSword(String name, Item.ToolMaterial material, int arcanaConsumed, float weakenedDamageValue) {
        super(material, name);
        this.arcanaConsumed = arcanaConsumed;
        this.weakenedDamageValue = weakenedDamageValue;
    }

    @Override
    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        IArcana arcana = DivineAPI.getArcana((Entity)player);
        if (!player.field_70170_p.field_72995_K && entity instanceof EntityLivingBase && arcana.getArcana() >= (float)this.arcanaConsumed) {
            arcana.consume(player, this.arcanaConsumed);
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        DivineItemStackCapability cap;
        if (world.func_82737_E() % 10L == 0L && entity instanceof EntityLivingBase && (cap = (DivineItemStackCapability)stack.getCapability(DivineItemStackCapabilityProvider.DIVINE_ITEM_STACK, null)) != null) {
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)entity;
                IArcana arcana = DivineAPI.getArcana((Entity)player);
                float damageValue = arcana.getArcana() < (float)this.arcanaConsumed ? this.weakenedDamageValue - 1.0f : this.getToolMaterial().func_78000_c() + 4.0f - 1.0f;
                player.func_110140_aT().func_111148_a(this.getAttributeModifiers(EntityEquipmentSlot.MAINHAND, stack));
                cap.setValue(damageValue);
                player.func_110140_aT().func_111147_b(this.getAttributeModifiers(EntityEquipmentSlot.MAINHAND, stack));
            } else {
                EntityLivingBase entityLivingBase = (EntityLivingBase)entity;
                entityLivingBase.func_110140_aT().func_111148_a(this.getAttributeModifiers(EntityEquipmentSlot.MAINHAND, stack));
                cap.setValue(this.weakenedDamageValue - 1.0f);
                entityLivingBase.func_110140_aT().func_111147_b(this.getAttributeModifiers(EntityEquipmentSlot.MAINHAND, stack));
            }
        }
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Collection modifiers;
        Optional<AttributeModifier> mod;
        DivineItemStackCapability capability;
        Multimap attributeMap = super.getAttributeModifiers(slot, stack);
        if (slot == EntityEquipmentSlot.MAINHAND && (capability = (DivineItemStackCapability)stack.getCapability(DivineItemStackCapabilityProvider.DIVINE_ITEM_STACK, null)) != null && (mod = (modifiers = attributeMap.get((Object)SharedMonsterAttributes.field_111264_e.func_111108_a())).stream().filter(attributeModifier -> attributeModifier.func_111167_a().equals(field_111210_e)).findFirst()).isPresent()) {
            modifiers.remove(mod.get());
            attributeMap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)capability.getValue(), 0));
        }
        return attributeMap;
    }

    public void addAdditionalInformation(List list) {
        list.add(LocalizeUtils.arcanaConsumed(this.arcanaConsumed));
        list.add(LocalizeUtils.weakenedWithoutArcana());
    }
}

