/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.objects.entities.entity.projectiles;

import divinerpg.enums.BulletType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EntityShooterBullet
extends EntityThrowable {
    private static final DataParameter<Byte> BULLET_ID = EntityDataManager.func_187226_a(EntityShooterBullet.class, (DataSerializer)DataSerializers.field_187191_a);
    private BulletType bulletType;

    public EntityShooterBullet(World world) {
        super(world);
    }

    public EntityShooterBullet(World world, EntityLivingBase entity, BulletType bulletType) {
        super(world, entity);
        this.bulletType = bulletType;
        this.setBulletId((byte)bulletType.ordinal());
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BULLET_ID, (Object)0);
    }

    public void func_70184_a(RayTraceResult result) {
        if (result.field_72308_g != null) {
            result.field_72308_g.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), this.getBulletType().getDamage());
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74774_a("projectileId", this.getBulletId());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setBulletId(compound.func_74771_c("projectileId"));
        this.bulletType = BulletType.getBulletFromOrdinal(this.getBulletId());
    }

    private byte getBulletId() {
        return (Byte)this.field_70180_af.func_187225_a(BULLET_ID);
    }

    private void setBulletId(byte projectileId) {
        this.field_70180_af.func_187227_b(BULLET_ID, (Object)projectileId);
    }

    public BulletType getBulletType() {
        if (this.bulletType == null) {
            this.bulletType = BulletType.getBulletFromOrdinal(this.getBulletId());
        }
        return this.bulletType;
    }

    public ResourceLocation getTexture() {
        return this.getBulletType().getTexture();
    }
}

