/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.objects.blocks.tile.entity;

import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public abstract class TileEntityModFurnace
extends TileEntity
implements ISidedInventory,
ITickable {
    private static final int[] SLOTS_TOP = new int[]{0};
    private static final int[] SLOTS_BOTTOM = new int[]{2, 1};
    private static final int[] SLOTS_SIDES = new int[]{1};
    private NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    public int furnaceBurnTime;
    public int currentItemBurnTime;
    public int cookTime;
    public int totalCookTime;
    public String customName;
    public boolean wasBurning;

    public abstract String getFuranceName();

    abstract int getFurnaceSpeed();

    public abstract boolean needsFuel();

    public String func_70005_c_() {
        return this.func_145818_k_() ? this.customName : this.getFuranceName();
    }

    public boolean func_145818_k_() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    @Nullable
    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.inventory) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inventory.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.inventory, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.inventory, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemStack = (ItemStack)this.inventory.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemStack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemStack);
        this.inventory.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !flag) {
            ItemStack stack1 = (ItemStack)this.inventory.get(index + 1);
            this.totalCookTime = this.getFurnaceSpeed();
            this.cookTime = 0;
            this.func_70296_d();
        }
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.inventory);
        this.furnaceBurnTime = compound.func_74762_e("BurnTime");
        this.cookTime = compound.func_74762_e("CookTime");
        this.totalCookTime = compound.func_74762_e("CookTimeTotal");
        this.currentItemBurnTime = TileEntityFurnace.func_145952_a((ItemStack)((ItemStack)this.inventory.get(1)));
        if (compound.func_150297_b("CustomName", 8)) {
            this.customName = compound.func_74779_i("CustomName");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("BurnTime", (int)((short)this.furnaceBurnTime));
        compound.func_74768_a("CookTime", (int)((short)this.cookTime));
        compound.func_74768_a("CookTimeTotal", (int)((short)this.totalCookTime));
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.inventory);
        if (compound.func_150297_b("CustomName", 8)) {
            compound.func_74778_a("CustomName", this.customName);
        }
        return compound;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean canSmelt() {
        if (((ItemStack)this.inventory.get(0)).func_190926_b()) {
            return false;
        }
        ItemStack result = this.getSmeltingResult((ItemStack)this.inventory.get(0));
        if (result.func_190926_b()) {
            return false;
        }
        ItemStack output = (ItemStack)this.inventory.get(2);
        if (output.func_190926_b()) {
            return true;
        }
        if (!output.func_77969_a(result)) {
            return false;
        }
        int res = output.func_190916_E() + result.func_190916_E();
        return res <= this.func_70297_j_() && res <= output.func_77976_d();
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack input = (ItemStack)this.inventory.get(0);
            ItemStack output = (ItemStack)this.inventory.get(2);
            ItemStack result = this.getSmeltingResult(input);
            if (output.func_190926_b()) {
                this.inventory.set(2, (Object)result.func_77946_l());
            } else if (output.func_77973_b() == result.func_77973_b()) {
                output.func_190917_f(result.func_190916_E());
            }
            input.func_190918_g(1);
        }
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index == 0 || this.needsFuel() && index == 1 && TileEntityFurnace.func_145954_b((ItemStack)stack);
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.furnaceBurnTime;
            }
            case 1: {
                return this.currentItemBurnTime;
            }
            case 2: {
                return this.cookTime;
            }
            case 3: {
                return this.totalCookTime;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.furnaceBurnTime = value;
                break;
            }
            case 1: {
                this.currentItemBurnTime = value;
                break;
            }
            case 2: {
                this.cookTime = value;
                break;
            }
            case 3: {
                this.totalCookTime = value;
            }
        }
    }

    public int func_174890_g() {
        return 4;
    }

    public void func_174888_l() {
        this.inventory.clear();
    }

    public abstract void updateBlockState(boolean var1);

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            boolean isDirty = false;
            boolean isBurning = false;
            if (this.needsFuel()) {
                ItemStack itemstack = (ItemStack)this.inventory.get(1);
                if (this.furnaceBurnTime > 0) {
                    --this.furnaceBurnTime;
                    if (this.furnaceBurnTime <= 0) {
                        isDirty = true;
                    } else {
                        isBurning = true;
                    }
                }
                if (!(!isBurning && itemstack.func_190926_b() || ((ItemStack)this.inventory.get(0)).func_190926_b() || isBurning || !this.canSmelt())) {
                    this.furnaceBurnTime = this.currentItemBurnTime = this.getItemBurnTime(itemstack);
                    if (this.furnaceBurnTime > 0) {
                        isDirty = true;
                        isBurning = true;
                        if (!itemstack.func_190926_b()) {
                            Item item = itemstack.func_77973_b();
                            itemstack.func_190918_g(1);
                            if (itemstack.func_190926_b()) {
                                ItemStack item1 = item.getContainerItem(itemstack);
                                this.inventory.set(1, (Object)item1);
                            }
                        }
                    }
                }
            } else {
                isBurning = this.canSmelt();
            }
            if (isBurning) {
                if (this.canSmelt()) {
                    ++this.cookTime;
                    if (this.cookTime == this.totalCookTime) {
                        this.cookTime = 0;
                        this.totalCookTime = this.getFurnaceSpeed();
                        this.smeltItem();
                        isDirty = true;
                    }
                }
            } else if (this.cookTime > 0) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.totalCookTime);
            }
            if (this.wasBurning != isBurning) {
                this.updateBlockState(isBurning);
            }
            this.wasBurning = isBurning;
            if (isDirty) {
                this.func_70296_d();
            }
        }
    }

    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.DOWN) {
            return SLOTS_BOTTOM;
        }
        return side == EnumFacing.UP ? SLOTS_TOP : SLOTS_SIDES;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return index == 1;
    }

    public int getItemBurnTime(ItemStack stack) {
        return TileEntityFurnace.func_145952_a((ItemStack)stack);
    }

    public ItemStack getSmeltingResult(ItemStack stack) {
        return FurnaceRecipes.func_77602_a().func_151395_a(stack);
    }
}

