/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.objects.blocks.arcana;

import divinerpg.config.GeneralConfig;
import divinerpg.events.DimensionHelper;
import divinerpg.registry.BlockRegistry;
import divinerpg.registry.DimensionRegistry;
import divinerpg.registry.DivineRPGTabs;
import divinerpg.utils.portals.description.ArcanaTeleporter;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockArcanaPortal
extends Block {
    private int firetick;
    private int firemax = 200;
    private int dimId;
    protected static final AxisAlignedBB ARCANA_PORTAL_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);

    public BlockArcanaPortal(String name, int dimId) {
        super(Material.field_151567_E);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149663_c(name);
        this.setRegistryName("divinerpg", name);
        this.func_149647_a(DivineRPGTabs.BLOCKS);
        this.func_149715_a(1.0f);
        this.func_149722_s();
        this.func_149752_b(6000000.0f);
        this.dimId = dimId;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return ARCANA_PORTAL_AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
    }

    public int func_149745_a(Random par1Random) {
        return 0;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entity) {
        if (worldIn.field_72995_K) {
            return;
        }
        boolean canTransfer = entity.field_71088_bW <= 0;
        entity.field_71088_bW = 40;
        if (!canTransfer) {
            return;
        }
        DimensionType destination = DimensionRegistry.arcanaDimension;
        if (destination == worldIn.field_73011_w.func_186058_p()) {
            destination = DimensionType.OVERWORLD;
        }
        BlockArcanaPortal.transferEntity(entity, destination);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        BlockPattern.PatternHelper frame;
        if (blockIn == BlockRegistry.arcanaPortalFrame && (frame = DimensionHelper.arcanaPortalHelper.matchFrame(worldIn, pos)) == null) {
            worldIn.func_175698_g(pos);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        double distanceX = (float)pos.func_177958_n() + rand.nextFloat();
        double distanceY = (float)pos.func_177956_o() + 0.8f;
        double distanceZ = (float)pos.func_177952_p() + rand.nextFloat();
        worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, distanceX, distanceY, distanceZ, 0.0, 0.0, 0.0, new int[0]);
    }

    public static void transferEntity(Entity e, DimensionType modDimension) {
        if (e == null || modDimension == null) {
            return;
        }
        ArcanaTeleporter teleporter = e.field_71093_bK == GeneralConfig.dimensionIDs.arcanaDimensionID ? new ArcanaTeleporter(e.func_184102_h().func_71218_a(0)) : new ArcanaTeleporter(e.func_184102_h().func_71218_a(GeneralConfig.dimensionIDs.arcanaDimensionID));
        e.changeDimension(modDimension.func_186068_a(), (ITeleporter)teleporter);
    }
}

