/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.objects.blocks;

import divinerpg.registry.BlockRegistry;
import divinerpg.registry.DivineRPGTabs;
import divinerpg.registry.ItemRegistry;
import divinerpg.utils.Utils;
import java.util.Collection;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockModLeaves
extends BlockLeaves
implements IShearable {
    private Supplier<Block> saplingSupplier;
    private MapColor mapColor;
    private final int radius;
    private int[] surroundings;

    public BlockModLeaves(String name, float hardness, @Nonnull MapColor mapColorIn) {
        this(name, hardness, () -> null, mapColorIn);
    }

    public BlockModLeaves(String name, float hardness, Supplier<Block> saplingSupplier, @Nonnull MapColor mapColorIn) {
        this(name, hardness, saplingSupplier, mapColorIn, 4);
    }

    public BlockModLeaves(String name, float hardness, Supplier<Block> saplingSupplier, @Nonnull MapColor mapColorIn, int radius) {
        this.radius = radius;
        this.saplingSupplier = () -> null;
        this.setMapColor(mapColorIn);
        this.func_149663_c(name);
        this.setRegistryName("divinerpg", name);
        this.func_149711_c(hardness);
        this.func_149647_a(DivineRPGTabs.BLOCKS);
        this.func_149675_a(true);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf(true)));
        this.saplingSupplier = saplingSupplier;
        int dim = radius * 2 + 1;
        this.surroundings = new int[Utils.getIndex(dim, dim, dim, radius * 2) + 1];
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (worldIn.field_72995_K) {
            return;
        }
        if (!((Boolean)state.func_177229_b((IProperty)field_176236_b)).booleanValue()) {
            return;
        }
        if (!((Boolean)state.func_177229_b((IProperty)field_176237_a)).booleanValue()) {
            return;
        }
        if (!worldIn.func_175697_a(pos, 1)) {
            return;
        }
        if (worldIn.func_175697_a(pos, this.radius + 2)) {
            BlockPos.MutableBlockPos current = new BlockPos.MutableBlockPos();
            int diameter = this.radius * 2;
            for (int x = -this.radius; x <= this.radius; ++x) {
                for (int y = -this.radius; y <= this.radius; ++y) {
                    for (int z = -this.radius; z <= this.radius; ++z) {
                        int index;
                        current.func_181079_c(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z);
                        int xIndex = x + this.radius;
                        int yIndex = y + this.radius;
                        int zIndex = z + this.radius;
                        IBlockState blockState = worldIn.func_180495_p((BlockPos)current);
                        Block block = blockState.func_177230_c();
                        this.surroundings[Utils.getIndex((int)xIndex, (int)yIndex, (int)zIndex, (int)diameter)] = index = block.canSustainLeaves(blockState, (IBlockAccess)worldIn, (BlockPos)current) ? 0 : (block.isLeaves(blockState, (IBlockAccess)worldIn, (BlockPos)current) ? -2 : -1);
                    }
                }
            }
            for (int i3 = 1; i3 < this.radius; ++i3) {
                for (int x = 1; x < diameter; ++x) {
                    for (int y = 1; y < diameter; ++y) {
                        for (int z = 1; z < diameter; ++z) {
                            if (this.surroundings[Utils.getIndex(x, y, z, diameter)] != i3 - 1) continue;
                            if (this.surroundings[Utils.getIndex(x - 1, y, z, diameter)] == -2) {
                                this.surroundings[Utils.getIndex((int)(x - 1), (int)y, (int)z, (int)diameter)] = i3;
                            }
                            if (this.surroundings[Utils.getIndex(x + 1, y, z, diameter)] == -2) {
                                this.surroundings[Utils.getIndex((int)(x + 1), (int)y, (int)z, (int)diameter)] = i3;
                            }
                            if (this.surroundings[Utils.getIndex(x, y - 1, z, diameter)] == -2) {
                                this.surroundings[Utils.getIndex((int)x, (int)(y - 1), (int)z, (int)diameter)] = i3;
                            }
                            if (this.surroundings[Utils.getIndex(x, y + 1, z, diameter)] == -2) {
                                this.surroundings[Utils.getIndex((int)x, (int)(y + 1), (int)z, (int)diameter)] = i3;
                            }
                            if (this.surroundings[Utils.getIndex(x, y, z + 1, diameter)] == -2) {
                                this.surroundings[Utils.getIndex((int)x, (int)y, (int)(z + 1), (int)diameter)] = i3;
                            }
                            if (this.surroundings[Utils.getIndex(x, y, z - 1, diameter)] != -2) continue;
                            this.surroundings[Utils.getIndex((int)x, (int)y, (int)(z - 1), (int)diameter)] = i3;
                        }
                    }
                }
            }
            if (this.surroundings[Utils.getIndex(this.radius, this.radius, this.radius, diameter)] >= 0) {
                worldIn.func_180501_a(pos, state.func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf(false)), 4);
            } else {
                this.destroy(worldIn, pos);
            }
        }
    }

    private void destroy(World worldIn, BlockPos pos) {
        this.func_176226_b(worldIn, pos, worldIn.func_180495_p(pos), 0);
        worldIn.func_175698_g(pos);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176236_b, field_176237_a});
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        Block sapling = this.saplingSupplier.get();
        return sapling != null ? Item.func_150898_a((Block)sapling) : null;
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        if (!((Boolean)state.func_177229_b((IProperty)field_176237_a)).booleanValue()) {
            i |= 4;
        }
        if (((Boolean)state.func_177229_b((IProperty)field_176236_b)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)field_176237_a, (Comparable)Boolean.valueOf((meta & 4) == 0)).func_177226_a((IProperty)field_176236_b, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public BlockPlanks.EnumType func_176233_b(int meta) {
        return BlockPlanks.EnumType.OAK;
    }

    public NonNullList<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return NonNullList.func_191197_a((int)1, (Object)new ItemStack((Block)this, 1, 0));
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return new ItemStack(Item.func_150898_a((Block)this));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        if (Minecraft.func_71375_t()) {
            return BlockRenderLayer.CUTOUT_MIPPED;
        }
        return BlockRenderLayer.SOLID;
    }

    public boolean func_149662_c(IBlockState state) {
        return Blocks.field_150362_t.func_149662_c(state);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return Blocks.field_150362_t.func_176225_a(state, world, pos, side);
    }

    private void setMapColor(MapColor mapColorIn) {
        this.mapColor = mapColorIn == null ? Material.field_151584_j.func_151565_r() : mapColorIn;
    }

    @Deprecated
    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (this.mapColor == null) {
            return super.func_180659_g(state, worldIn, pos);
        }
        return this.mapColor;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ItemStack drop;
        Random rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        int chance = this.func_176232_d(state);
        if (fortune > 0 && (chance -= 2 << fortune) < 10) {
            chance = 10;
        }
        if (rand.nextInt(chance) == 0 && !(drop = new ItemStack(this.func_180660_a(state, rand, fortune), 1, this.func_180651_a(state))).func_190926_b()) {
            drops.add((Object)drop);
        }
        chance = 200;
        if (fortune > 0 && (chance -= 10 << fortune) < 40) {
            chance = 40;
        }
        if (this == BlockRegistry.edenLeaves && rand.nextInt(1500) == 0) {
            drops.add((Object)new ItemStack(ItemRegistry.forbiddenFruit));
        }
        this.captureDrops(true);
        if (world instanceof World) {
            this.func_176234_a((World)world, pos, state, chance);
        }
        drops.addAll((Collection)this.captureDrops(false));
    }
}

