/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.networking.message;

import divinerpg.DivineRPG;
import divinerpg.api.DivineAPI;
import divinerpg.api.armor.cap.IArmorPowers;
import divinerpg.events.ArmorWearingEvents;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class ArmorStatusChangedMessage
implements IMessage {
    private boolean isOn;
    private ResourceLocation id;

    public ArmorStatusChangedMessage() {
    }

    public ArmorStatusChangedMessage(ResourceLocation id, boolean isOn) {
        this.id = id;
        this.isOn = isOn;
    }

    public void fromBytes(ByteBuf buf) {
        this.isOn = buf.readBoolean();
        int length = buf.readInt();
        this.id = new ResourceLocation(buf.readCharSequence(length, Charset.defaultCharset()).toString());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.isOn);
        String text = this.id.toString();
        buf.writeInt(text.length());
        buf.writeCharSequence((CharSequence)text, Charset.defaultCharset());
    }

    public static class Handler
    implements IMessageHandler<ArmorStatusChangedMessage, IMessage> {
        public IMessage onMessage(ArmorStatusChangedMessage message, MessageContext ctx) {
            IArmorPowers powers;
            if (ctx.side == Side.CLIENT && (powers = DivineAPI.getArmorPowers((Entity)DivineRPG.proxy.getPlayer())) != null) {
                if (message.isOn) {
                    powers.putOn(message.id);
                } else {
                    powers.takeOff(message.id);
                }
            }
            if (ctx.side == Side.SERVER) {
                ArmorWearingEvents.recheckAllWearing((Entity)ctx.getServerHandler().field_147369_b, true);
            }
            return null;
        }
    }
}

