/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.events.enchants;

import divinerpg.registry.EnchantmentRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class WorldBreakEnchantHandler {
    @SubscribeEvent
    public void handleWorldBreak(BlockEvent.BreakEvent event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        EntityPlayer player = event.getPlayer();
        if (player.func_70093_af()) {
            return;
        }
        ItemStack itemStack = event.getPlayer().func_184614_ca();
        if (!(itemStack.func_77973_b() instanceof ItemTool)) {
            return;
        }
        int level = EnchantmentHelper.func_77506_a((Enchantment)EnchantmentRegistry.RIVE, (ItemStack)itemStack);
        if (level < 1) {
            return;
        }
        EnumFacing facing = player.func_174811_aO();
        int[] dimensions = this.getSizeByDirection(facing, level);
        for (int x = dimensions[0]; x <= dimensions[3]; ++x) {
            for (int y = dimensions[1]; y <= dimensions[4]; ++y) {
                for (int z = dimensions[2]; z <= dimensions[5]; ++z) {
                    BlockPos pos = event.getPos().func_177982_a(x, y, z);
                    this.tryToBreakBlock(world, player, pos, world.func_180495_p(pos), itemStack);
                }
            }
        }
    }

    private void tryToBreakBlock(World world, EntityPlayer player, BlockPos pos, IBlockState blockState, ItemStack tool) {
        if (blockState.func_177230_c() == Blocks.field_150350_a || blockState.func_185887_b(world, pos) < 0.0f) {
            return;
        }
        Block block = blockState.func_177230_c();
        if (block.canHarvestBlock((IBlockAccess)world, pos, player)) {
            block.func_180657_a(world, player, pos, blockState, null, tool);
            world.func_175655_b(pos, false);
            tool.func_77972_a(1, (EntityLivingBase)player);
        }
    }

    private int[] getSizeByDirection(EnumFacing facing, int level) {
        int depth = level - 1;
        switch (facing) {
            case NORTH: {
                return new int[]{-1, -1, 0 - depth, 1, 1, 0};
            }
            case EAST: {
                return new int[]{0, -1, -1, 0 + depth, 1, 1};
            }
            case WEST: {
                return new int[]{0 - depth, -1, -1, 0, 1, 1};
            }
            case SOUTH: {
                return new int[]{-1, -1, 0, 1, 1, 0 + depth};
            }
            case UP: {
                return new int[]{-1, 0, -1, 1, 0 + depth, 1};
            }
            case DOWN: {
                return new int[]{-1, 0 - depth, -1, 1, 0, 1};
            }
        }
        return new int[]{0, 0, 0, 0, 0, 0};
    }
}

