/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.dimensions.vethea;

import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class TempleWorldGenerator
extends WorldGenerator {
    private final ResourceLocation location;
    private final BlockPos possibleSize;

    public TempleWorldGenerator(ResourceLocation location) {
        this(location, null);
    }

    public TempleWorldGenerator(ResourceLocation location, boolean checkCanPlace) {
        this(location, (BlockPos)(checkCanPlace ? BlockPos.field_177992_a : null));
    }

    public TempleWorldGenerator(ResourceLocation location, BlockPos possibleSize) {
        this.location = location;
        this.possibleSize = possibleSize;
    }

    private Template getTemplate(World world) {
        TemplateManager manager = world.func_72860_G().func_186340_h();
        Template template = manager.func_186237_a(null, this.location);
        return template;
    }

    public boolean func_180709_b(World world, Random random, BlockPos blockPos) {
        if (this.possibleSize != null && !this.canPlace(world, blockPos)) {
            BlockPos innerCopy = new BlockPos((Vec3i)blockPos);
            blockPos = null;
            int x = Math.max(1, this.possibleSize.func_177958_n());
            int y = Math.max(1, this.possibleSize.func_177956_o());
            int z = Math.max(1, this.possibleSize.func_177952_p());
            for (int i = 0; i < 5; ++i) {
                BlockPos pos = innerCopy.func_177982_a(random.nextInt(x), random.nextInt(y), random.nextInt(z));
                if (!this.canPlace(world, pos)) continue;
                blockPos = pos;
                break;
            }
        }
        if (blockPos == null) {
            return false;
        }
        this.getTemplate(world).func_186260_a(world, blockPos, new PlacementSettings());
        return true;
    }

    public boolean canPlace(World world, BlockPos pos) {
        Template template = this.getTemplate(world);
        BlockPos size = template.func_186259_a();
        AtomicBoolean canPlace = new AtomicBoolean(true);
        BlockPos.func_177980_a((BlockPos)pos.func_177982_a(0, 1, 0), (BlockPos)pos.func_177971_a((Vec3i)size)).forEach(x -> {
            if (canPlace.get() && !world.func_175623_d(x) && !world.func_180495_p(x).func_177230_c().func_176200_f((IBlockAccess)world, x)) {
                canPlace.set(false);
            }
        });
        return canPlace.get();
    }
}

