/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.dimensions;

import divinerpg.utils.Lazy;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.LazyLoadBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;

public class TwilightTree
extends WorldGenAbstractTree {
    private final LazyLoadBase<IBlockState> log;
    private final LazyLoadBase<IBlockState> leaves;
    private final LazyLoadBase<Block> sapling;
    private int minTreeHeight;
    private boolean isSapling;

    public TwilightTree(boolean notify, int minTreeHeightIn, Supplier<IBlockState> log, Supplier<IBlockState> leaves, Supplier<Block> sapling) {
        super(notify);
        this.isSapling = notify;
        this.minTreeHeight = minTreeHeightIn;
        this.log = new Lazy<IBlockState>(log);
        this.leaves = new Lazy<IBlockState>(leaves);
        this.sapling = new Lazy<Block>(sapling);
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        boolean isSoil = ((Block)this.sapling.func_179281_c()).func_176196_c(worldIn, position);
        int treeHeight = rand.nextInt(3) + this.minTreeHeight;
        int treeTopPos = position.func_177956_o() + treeHeight;
        if (position.func_177956_o() < 1 || treeTopPos + 1 > 256 || !isSoil) {
            return false;
        }
        if (this.isSapling) {
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
            for (int iPosY = position.func_177956_o(); iPosY <= treeTopPos + 1; ++iPosY) {
                int k = iPosY > position.func_177956_o() + 1 ? 0 : (iPosY == position.func_177956_o() ? 2 : 1);
                int halflength = position.func_177958_n() + k;
                for (int iPosX = position.func_177958_n() - k; iPosX <= halflength + k; ++iPosX) {
                    int halfLength = position.func_177952_p() + k;
                    for (int iPosZ = position.func_177952_p() - k; iPosZ <= halfLength + k; ++iPosZ) {
                        if (iPosY >= 0 && iPosY < 256) {
                            if (this.isReplaceable(worldIn, (BlockPos)mutableBlockPos.func_181079_c(iPosX, iPosY, iPosZ))) continue;
                            return false;
                        }
                        return false;
                    }
                }
            }
        }
        this.buildTrunk(worldIn, position, treeHeight);
        return true;
    }

    private void buildTrunk(World world, BlockPos pos, int treeHeight) {
        IBlockState log = (IBlockState)this.log.func_179281_c();
        IBlockState leaves = (IBlockState)this.leaves.func_179281_c();
        Random random = new Random();
        int rand = random.nextInt(1) + 1;
        int extraHeight = treeHeight + rand;
        this.func_175903_a(world, pos.func_177982_a(1, 1, 0), log);
        this.func_175903_a(world, pos.func_177982_a(0, 1, 1), log);
        this.func_175903_a(world, pos.func_177982_a(-1, 1, 0), log);
        this.func_175903_a(world, pos.func_177982_a(0, 1, -1), log);
        this.drawLeafCircle(world, pos.func_177982_a(0, 0, 0), 2, log);
        this.drawLeafCircle(world, pos.func_177982_a(0, extraHeight - 1, 0), 1, leaves);
        this.drawLeafCircle(world, pos.func_177982_a(0, extraHeight, 0), 2, leaves);
        this.drawLeafCircle(world, pos.func_177982_a(0, extraHeight + 1, 0), 1, leaves);
        this.drawLeafCircle(world, pos.func_177982_a(0, extraHeight + 2, 0), 0, leaves);
        for (int dy = 0; dy < extraHeight; ++dy) {
            this.func_175903_a(world, pos.func_177982_a(0, dy, 0), log);
        }
    }

    private void drawLeafCircle(World world, BlockPos pos, int rad, IBlockState leaves) {
        for (int dx = 0; dx <= rad; dx = (int)((byte)(dx + 1))) {
            for (int dz = 0; dz <= rad; dz = (int)((byte)(dz + 1))) {
                int dist = (int)((double)Math.max(dx, dz) + (double)Math.min(dx, dz) * 0.5);
                if (dx == 3 && dz == 3) {
                    dist = 6;
                }
                if (dx == 0) {
                    if (dz < rad) {
                        this.func_175903_a(world, pos.func_177982_a(0, 0, dz), leaves);
                        this.func_175903_a(world, pos.func_177982_a(0, 0, -dz), leaves);
                        continue;
                    }
                    this.func_175903_a(world, pos.func_177982_a(0, 0, dz), leaves);
                    this.func_175903_a(world, pos.func_177982_a(0, 0, -dz), leaves);
                    continue;
                }
                if (dz == 0) {
                    if (dx < rad) {
                        this.func_175903_a(world, pos.func_177982_a(dx, 0, 0), leaves);
                        this.func_175903_a(world, pos.func_177982_a(-dx, 0, 0), leaves);
                        continue;
                    }
                    this.func_175903_a(world, pos.func_177982_a(dx, 0, 0), leaves);
                    this.func_175903_a(world, pos.func_177982_a(-dx, 0, 0), leaves);
                    continue;
                }
                if (dist < rad) {
                    this.func_175903_a(world, pos.func_177982_a(dx, 0, dz), leaves);
                    this.func_175903_a(world, pos.func_177982_a(dx, 0, -dz), leaves);
                    this.func_175903_a(world, pos.func_177982_a(-dx, 0, dz), leaves);
                    this.func_175903_a(world, pos.func_177982_a(-dx, 0, -dz), leaves);
                    continue;
                }
                if (dist != rad) continue;
                this.func_175903_a(world, pos.func_177982_a(dx, 0, dz), leaves);
                this.func_175903_a(world, pos.func_177982_a(dx, 0, -dz), leaves);
                this.func_175903_a(world, pos.func_177982_a(-dx, 0, dz), leaves);
                this.func_175903_a(world, pos.func_177982_a(-dx, 0, -dz), leaves);
            }
        }
    }
}

