/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.config;

import divinerpg.DivineRPG;
import divinerpg.config.MobStatInfo;
import divinerpg.config.OreInfo;
import divinerpg.proxy.CommonProxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.Level;

public class Config {
    public static final Map<ResourceLocation, MobStatInfo> mobStats = new HashMap<ResourceLocation, MobStatInfo>();
    public static final OreInfo realmite = new OreInfo("realmite", 5, 8, 1, 48);
    public static final OreInfo rupee = new OreInfo("rupee", 5, 4, 1, 16);
    public static final OreInfo arlemite = new OreInfo("arlemite", 5, 4, 1, 16);
    public static final OreInfo nether = new OreInfo("netherOres", 10, 4, 1, 256);
    public static final OreInfo twilight = new OreInfo("twilightOres", 10, 4, 15, 100);
    private static final String CATEGORY_GUI = "GUI";
    private static final String CATEGORY_WORLD_GEN = "World Gen";
    public static boolean generateHuts = true;
    public static boolean generateTrees = true;
    public static boolean generateTar = true;

    private static void initGeneralConfig(Configuration cfg) {
        cfg.addCustomCategoryComment(CATEGORY_WORLD_GEN, "World gen variables");
        Arrays.asList(arlemite, rupee, realmite, nether, twilight).forEach(oreInfo -> oreInfo.init(cfg, CATEGORY_WORLD_GEN));
        generateHuts = cfg.getBoolean("generateHuts", CATEGORY_WORLD_GEN, true, "Generate livestock merchant huts in the overworld");
        generateTrees = cfg.getBoolean("generateTrees", CATEGORY_WORLD_GEN, true, "Generate divine trees in the overworld");
        generateTar = cfg.getBoolean("generateTar", CATEGORY_WORLD_GEN, true, "Generate tar lakes in the overworld");
    }

    private static void initMobStats(Configuration cfg) {
        LinkedHashMap<ResourceLocation, MobStatInfo> defaultModStates = new LinkedHashMap<ResourceLocation, MobStatInfo>(){
            {
                this.put(new ResourceLocation("divinerpg", "acid_hag"), new MobStatInfo(25.0, 5.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "advanced_cori"), new MobStatInfo(35.0, 60.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "alicanto"), new MobStatInfo(75.0, 10.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "ancient_entity"), new MobStatInfo(800.0, 12.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "angry_bunny"), new MobStatInfo(60.0, 12.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "apalachia_cadillion"), new MobStatInfo(90.0, 16.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "apalachia_golem"), new MobStatInfo(250.0, 19.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "apalachia_tomo"), new MobStatInfo(115.0, 14.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "arid_warrior"), new MobStatInfo(40.0, 8.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "ayeraco_blue"), new MobStatInfo(600.0, 5.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "ayeraco_green"), new MobStatInfo(600.0, 5.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "ayeraco_purple"), new MobStatInfo(600.0, 5.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "ayeraco_red"), new MobStatInfo(600.0, 5.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "ayeraco_yellow"), new MobStatInfo(600.0, 5.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "basilisk"), new MobStatInfo(500.0, 10.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "behemoth"), new MobStatInfo(180.0, 14.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "biphron"), new MobStatInfo(40.0, 14.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "bohemite"), new MobStatInfo(60.0, 13.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "brown_grizzle"), new MobStatInfo(100.0, 0.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "bunny"), new MobStatInfo(10.0, 1.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "captain_merik"), new MobStatInfo(20.0, 0.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "cave_crawler"), new MobStatInfo(30.0, 7.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "caveclops"), new MobStatInfo(60.0, 8.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "crab"), new MobStatInfo(45.0, 6.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "crypt_keeper"), new MobStatInfo(20.0, 2.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "cyclops"), new MobStatInfo(35.0, 8.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "cymesoid"), new MobStatInfo(25.0, 8.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "datticon"), new MobStatInfo(20.0, 0.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "death_hound"), new MobStatInfo(120.0, 10.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "deathcryx"), new MobStatInfo(70.0, 10.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "demon_of_darkness"), new MobStatInfo(200.0, 21.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "densos"), new MobStatInfo(1000.0, 28.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "desert_crawler"), new MobStatInfo(40.0, 8.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "dissiment"), new MobStatInfo(70.0, 0.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "dramix"), new MobStatInfo(1400.0, 30.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "dreamwrecker"), new MobStatInfo(60.0, 8.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "dungeon_constructor"), new MobStatInfo(100.0, 19.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "dungeon_demon"), new MobStatInfo(85.0, 17.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "dungeon_prisoner"), new MobStatInfo(85.0, 17.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "duo"), new MobStatInfo(20.0, 7.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "eden_cadillion"), new MobStatInfo(75.0, 12.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "eden_tomo"), new MobStatInfo(100.0, 10.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "ehu"), new MobStatInfo(60.0, 6.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "enchanted_archer"), new MobStatInfo(100.0, 12.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "enchanted_warrior"), new MobStatInfo(200.0, 20.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "ender_spider"), new MobStatInfo(40.0, 7.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "ender_triplets"), new MobStatInfo(10.0, 0.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "ender_watcher"), new MobStatInfo(40.0, 7.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "ent"), new MobStatInfo(50.0, 20.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "enthralled_dramcryx"), new MobStatInfo(80.0, 14.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "epiphite"), new MobStatInfo(100.0, 14.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "eternal_archer"), new MobStatInfo(1550.0, 2.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "experienced_cori"), new MobStatInfo(1150.0, 16.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "fake_vhraak"), new MobStatInfo(100.0, 30.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "fractite"), new MobStatInfo(50.0, 0.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "frost"), new MobStatInfo(50.0, 6.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "frost_archer"), new MobStatInfo(40.0, 2.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "frosty"), new MobStatInfo(150.0, 20.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "fyracryx"), new MobStatInfo(60.0, 0.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "galroid"), new MobStatInfo(100.0, 25.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "glacide"), new MobStatInfo(80.0, 12.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "glacon"), new MobStatInfo(60.0, 7.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "golem_of_rejuvenation"), new MobStatInfo(30.0, 0.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "gorgosion"), new MobStatInfo(60.0, 2.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "greenfeet"), new MobStatInfo(200.0, 16.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "hastreus"), new MobStatInfo(80.0, 12.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "helio"), new MobStatInfo(140.0, 40.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "hell_pig"), new MobStatInfo(25.0, 5.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "hell_spider"), new MobStatInfo(50.0, 9.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "herbomancer"), new MobStatInfo(40.0, 5.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "herbomancer_minion"), new MobStatInfo(10.0, 5.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "hive_queen"), new MobStatInfo(1500.0, 20.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "hive_soldier"), new MobStatInfo(20.0, 6.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "hover_stinger"), new MobStatInfo(40.0, 8.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "husk"), new MobStatInfo(80.0, 8.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "jack_o_man"), new MobStatInfo(20.0, 0.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "jungle_bat"), new MobStatInfo(20.0, 5.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "jungle_dramcryx"), new MobStatInfo(40.0, 9.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "jungle_spider"), new MobStatInfo(45.0, 7.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "karos"), new MobStatInfo(4000.0, 20.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "karot"), new MobStatInfo(1250.0, 32.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "kazrotic"), new MobStatInfo(65.0, 2.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "king_crab"), new MobStatInfo(100.0, 9.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "king_of_scorchers"), new MobStatInfo(1100.0, 22.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "kobblin"), new MobStatInfo(35.0, 7.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "lady_luna"), new MobStatInfo(8000.0, 20.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "leorna"), new MobStatInfo(20.0, 0.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "lheiva"), new MobStatInfo(85.0, 19.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "liopleurodon"), new MobStatInfo(150.0, 13.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "livestock_merchant"), new MobStatInfo(20.0, 0.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "living_statue"), new MobStatInfo(60.0, 2.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "lord_vatticus"), new MobStatInfo(20.0, 0.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "lorga"), new MobStatInfo(15.0, 4.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "lorga_flight"), new MobStatInfo(40.0, 2.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "madivel"), new MobStatInfo(150.0, 18.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "mage"), new MobStatInfo(90.0, 5.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "mandragora"), new MobStatInfo(35.0, 4.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "megalith"), new MobStatInfo(350.0, 20.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "miner"), new MobStatInfo(40.0, 7.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "mortum_cadillion"), new MobStatInfo(130.0, 20.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "mysterious_man_layer_1"), new MobStatInfo(20.0, 2.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "mysterious_man_layer_2"), new MobStatInfo(20.0, 2.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "mysterious_man_layer_3"), new MobStatInfo(20.0, 2.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "mystic"), new MobStatInfo(120.0, 10.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "parasecta"), new MobStatInfo(1000.0, 16.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "paratiku"), new MobStatInfo(100.0, 0.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "pumpkin_spider"), new MobStatInfo(50.0, 9.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "quadro"), new MobStatInfo(4000.0, 8.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "raglok"), new MobStatInfo(5000.0, 30.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "rainbour"), new MobStatInfo(100.0, 18.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "razorback"), new MobStatInfo(35.0, 7.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "reyvor"), new MobStatInfo(1000.0, 20.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "roamer"), new MobStatInfo(110.0, 20.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "rollum"), new MobStatInfo(180.0, 5.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "rotatick"), new MobStatInfo(40.0, 8.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "saguaro_worm"), new MobStatInfo(80.0, 6.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "samek"), new MobStatInfo(160.0, 20.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "scorcher"), new MobStatInfo(75.0, 5.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "seimer"), new MobStatInfo(150.0, 6.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "shadahier"), new MobStatInfo(10.0, 6.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "shark"), new MobStatInfo(80.0, 8.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "skythern_archer"), new MobStatInfo(120.0, 14.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "skythern_fiend"), new MobStatInfo(80.0, 22.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "skythern_golem"), new MobStatInfo(300.0, 20.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "smelter"), new MobStatInfo(120.0, 7.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "snapper"), new MobStatInfo(150.0, 4.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "sorcerer"), new MobStatInfo(150.0, 12.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "soul_fiend"), new MobStatInfo(1100.0, 24.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "soul_spider"), new MobStatInfo(35.0, 12.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "soul_stealer"), new MobStatInfo(140.0, 25.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "spellbinder"), new MobStatInfo(95.0, 7.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "stone_golem"), new MobStatInfo(100.0, 5.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "sun_archer"), new MobStatInfo(60.0, 10.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "sunstorm"), new MobStatInfo(1000.0, 12.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "temple_guardian"), new MobStatInfo(20.0, 2.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "termasect"), new MobStatInfo(1050.0, 14.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "termid"), new MobStatInfo(40.0, 4.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "the_eye"), new MobStatInfo(40.0, 12.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "the_grue"), new MobStatInfo(30.0, 13.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "the_hunger"), new MobStatInfo(20.0, 0.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "the_watcher"), new MobStatInfo(950.0, 2.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "tocaxin"), new MobStatInfo(65.0, 10.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "twilight_archer"), new MobStatInfo(140.0, 16.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "twilight_demon"), new MobStatInfo(1600.0, 30.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "twins"), new MobStatInfo(10.0, 2.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "vamacheron"), new MobStatInfo(1350.0, 34.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "verek"), new MobStatInfo(50.0, 18.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "vermenous"), new MobStatInfo(100.0, 13.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "vhraak"), new MobStatInfo(100.0, 30.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "war_general"), new MobStatInfo(20.0, 0.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "weak_cori"), new MobStatInfo(35.0, 30.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "whale"), new MobStatInfo(80.0, 8.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "white_grizzle"), new MobStatInfo(100.0, 9.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "wildfire"), new MobStatInfo(50.0, 8.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "wildwood_cadillion"), new MobStatInfo(85.0, 14.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "wildwood_golem"), new MobStatInfo(200.0, 18.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "wildwood_tomo"), new MobStatInfo(110.0, 12.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "workshop_merchant"), new MobStatInfo(20.0, 0.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "workshop_tinkerer"), new MobStatInfo(20.0, 0.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "wraith"), new MobStatInfo(100.0, 9.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "wreck"), new MobStatInfo(5000.0, 30.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "zelus"), new MobStatInfo(20.0, 0.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "zone"), new MobStatInfo(120.0, 0.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "zoragon"), new MobStatInfo(70.0, 0.0, 0.0));
                this.put(new ResourceLocation("divinerpg", "moon_wolf"), new MobStatInfo(200.0, 1.0, 0.0));
            }
        };
        defaultModStates.forEach((location, mobStatInfo) -> {
            mobStatInfo.initConfig(cfg, (ResourceLocation)location);
            mobStats.put((ResourceLocation)location, (MobStatInfo)mobStatInfo);
        });
    }

    public static void readConfig() {
        Config.readConfig(CommonProxy.config, Config::initGeneralConfig);
        Config.readConfig(CommonProxy.mobStatsConfig, Config::initMobStats);
    }

    private static void readConfig(Configuration cfg, Consumer<Configuration> initDefault) {
        try {
            cfg.load();
            initDefault.accept(cfg);
        }
        catch (Exception e1) {
            DivineRPG.logger.log(Level.ERROR, "Problem loading config file!", (Throwable)e1);
        }
        finally {
            if (cfg.hasChanged()) {
                cfg.save();
            }
        }
    }

    public static void initEntityAttributes(EntityLivingBase e) {
        if (e == null) {
            return;
        }
        ResourceLocation id = EntityList.func_191301_a((Entity)e);
        if (id == null) {
            return;
        }
        MobStatInfo info = mobStats.get(id);
        if (info == null) {
            return;
        }
        info.initEntity(e);
    }
}

