/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.capabilities.armor;

import divinerpg.DivineRPG;
import divinerpg.api.DivineAPI;
import divinerpg.api.armor.binded.IPlayerForgeEvent;
import divinerpg.api.armor.registry.IForgeEvent;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Objects;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.logging.log4j.Level;

public class PlayerForgeEvent<T extends Event>
implements IPlayerForgeEvent<T> {
    private final IForgeEvent<T> base;
    private final WeakReference<EntityLivingBase> player;
    private boolean isListen = false;

    public PlayerForgeEvent(IForgeEvent<T> base, EntityLivingBase player) {
        this.base = base;
        this.player = new WeakReference<EntityLivingBase>(player);
        Objects.requireNonNull(base);
        Objects.requireNonNull(player);
    }

    @Override
    public EntityLivingBase getPlayer() {
        return (EntityLivingBase)this.player.get();
    }

    @Override
    public boolean isListening() {
        return this.isListen;
    }

    @Override
    public void subscribe() {
        if (this.isListening()) {
            return;
        }
        Method eventHandlingMethod = DivineAPI.reflectionHelper.findMethod(this.getClass(), "handleEvent", Event.class);
        if (eventHandlingMethod == null) {
            DivineRPG.logger.log(Level.WARN, "Can't find 'handleEvent' method there, maybe it was renamed or signature was changed");
            return;
        }
        Object wasCalled = DivineAPI.reflectionHelper.callMethod(MinecraftForge.EVENT_BUS, "register", () -> new Object[]{this.getParameterClass(), this, eventHandlingMethod, Loader.instance().activeModContainer()}, Class.class, Object.class, Method.class, ModContainer.class);
        if (Boolean.FALSE.equals(wasCalled)) {
            DivineRPG.logger.log(Level.WARN, "Can't find private 'register' method inside EventBus, maybe it was renamed or signature was changed or name was obfuscated");
            return;
        }
        this.isListen = true;
    }

    @Override
    public void unsubscribe() {
        if (!this.isListening()) {
            return;
        }
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        this.isListen = false;
    }

    @Override
    public void handle(T event) {
        this.base.handle(event);
    }

    @Override
    public Class<T> getParameterClass() {
        return this.base.getParameterClass();
    }

    @SubscribeEvent
    public void handleEvent(T event) {
        if (!this.getParameterClass().equals(event.getClass())) {
            return;
        }
        if (this.canHandle(event)) {
            this.handle(event);
        }
    }
}

