/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.capabilities.armor;

import divinerpg.DivineRPG;
import divinerpg.api.armor.IEquipped;
import divinerpg.api.armor.IPlayerSubscription;
import divinerpg.api.armor.binded.IPlayerArmorDescription;
import divinerpg.api.armor.binded.IPlayerForgeEvent;
import divinerpg.api.armor.registry.IArmorDescription;
import divinerpg.capabilities.armor.PlayerForgeEvent;
import divinerpg.networking.message.ArmorStatusChangedMessage;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PlayerArmorDescription
implements IPlayerArmorDescription {
    private final WeakReference<EntityLivingBase> player;
    private final IArmorDescription source;
    private final List<IPlayerForgeEvent<?>> handlers = new ArrayList();
    private final ResourceLocation id;

    public PlayerArmorDescription(EntityLivingBase player, IArmorDescription source) {
        Objects.requireNonNull(player);
        Objects.requireNonNull(source);
        this.player = new WeakReference<EntityLivingBase>(player);
        this.source = source;
        this.id = source.getRegistryName();
        source.getHandlers().forEach(x -> this.handlers.add(new PlayerForgeEvent(x, player)));
    }

    @Override
    public List<IPlayerForgeEvent<?>> getHandlers() {
        return this.handlers;
    }

    @Override
    public void changeStatus(boolean isOn, boolean sendMessage) {
        IEquipped handler = this.source.getEquippedHandler();
        if (handler != null) {
            handler.onEquppedChanged(this.getPlayer(), isOn);
        }
        if (isOn) {
            this.handlers.forEach(IPlayerSubscription::subscribe);
        } else {
            this.handlers.forEach(IPlayerSubscription::unsubscribe);
        }
        if (sendMessage && this.getPlayer() instanceof EntityPlayerMP) {
            DivineRPG.network.sendTo((IMessage)new ArmorStatusChangedMessage(this.id, isOn), (EntityPlayerMP)this.getPlayer());
        }
    }

    @Override
    public EntityLivingBase getPlayer() {
        return (EntityLivingBase)this.player.get();
    }
}

