/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.capabilities.armor;

import divinerpg.api.armor.IEquipped;
import divinerpg.api.armor.registry.IArmorDescription;
import divinerpg.api.armor.registry.IForgeEvent;
import divinerpg.capabilities.armor.ForgeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ArmorDescription
extends IForgeRegistryEntry.Impl<IArmorDescription>
implements IArmorDescription {
    private final List<IForgeEvent<?>> powers = new ArrayList();
    private final Map<EntityEquipmentSlot, Set<Item>> possibleItems = new LinkedHashMap<EntityEquipmentSlot, Set<Item>>();
    private final IEquipped handler;

    public ArmorDescription() {
        this(null);
    }

    public ArmorDescription(IEquipped handler) {
        this.handler = handler;
    }

    public <T extends Event> ArmorDescription withHandler(Class<T> clazz, Consumer<T> power) {
        this.powers.add(new ForgeEvent<T>(clazz, power));
        return this;
    }

    public ArmorDescription withPossibleItems(EntityEquipmentSlot slot, Item ... items) {
        if (items != null && items.length > 0) {
            Set set = this.possibleItems.computeIfAbsent(slot, x -> new HashSet());
            set.addAll(Arrays.asList(items));
        }
        return this;
    }

    @Override
    public List<IForgeEvent<?>> getHandlers() {
        return new ArrayList(this.powers);
    }

    @Override
    @Nullable
    public IEquipped getEquippedHandler() {
        return this.handler;
    }

    @Override
    public Set<Item> getPossibleItems(EntityEquipmentSlot slot) {
        Set set = this.possibleItems.computeIfAbsent(slot, x -> new HashSet());
        return new HashSet<Item>(set);
    }
}

