/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;

public final class BlockWrapper {
    public Block block;
    public int metadata;

    public static BlockWrapper fromBlockState(IBlockState state) {
        return new BlockWrapper(state);
    }

    public BlockWrapper(Block block, int metadata) {
        this.block = block;
        this.metadata = metadata;
    }

    public BlockWrapper(IBlockState state) {
        this(state.func_177230_c(), state.func_177230_c().func_176201_c(state));
    }

    public BlockWrapper(BlockWrapper wrapper) {
        this(wrapper.block, wrapper.metadata);
    }

    public BlockWrapper set(Block block, int metadata) {
        if (block != null) {
            this.block = block;
            this.metadata = metadata;
        } else {
            this.block = null;
            this.metadata = 0;
        }
        return this;
    }

    public boolean isEqual(BlockWrapper other) {
        if (other == null) {
            return false;
        }
        if (this.metadata == other.metadata) {
            if (this.block == other.block) {
                return true;
            }
            if (this.block != null && other.block != null) {
                return this.block.delegate.get() == other.block.delegate.get();
            }
        }
        return false;
    }

    public int getId() {
        return Block.func_149682_b((Block)this.block);
    }

    public BlockWrapper clone() {
        return new BlockWrapper(this);
    }

    public boolean equals(Object o) {
        return o instanceof BlockWrapper && this.isEqual((BlockWrapper)o);
    }

    public int hashCode() {
        return this.metadata | this.getId() << 16;
    }

    public String toString() {
        return this.getClass().getName() + '@' + System.identityHashCode(this) + '{' + "m:" + this.metadata + ", i:" + (this.block == null ? null : this.block.getClass().getName()) + '@' + System.identityHashCode(this.block) + ", v:" + this.getId() + '}';
    }
}

