/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.block;

import cofh.api.core.IPortableData;
import cofh.core.block.TileCore;
import cofh.core.fluid.FluidTankCore;
import cofh.core.network.ITilePacketHandler;
import cofh.core.network.PacketBase;
import cofh.core.network.PacketHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileNameable
extends TileCore
implements ITilePacketHandler,
IPortableData {
    public String customName = "";

    public void setCustomName(String name) {
        if (!name.isEmpty()) {
            this.customName = name;
        }
    }

    protected abstract Object getMod();

    protected abstract String getModVersion();

    protected abstract String getTileName();

    public int getType() {
        return 0;
    }

    protected boolean readPortableTagInternal(EntityPlayer player, NBTTagCompound tag) {
        return true;
    }

    protected boolean writePortableTagInternal(EntityPlayer player, NBTTagCompound tag) {
        return true;
    }

    public int getScaledProgress(int scale) {
        return 0;
    }

    public int getScaledSpeed(int scale) {
        return 0;
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        if (this.hasGui()) {
            player.openGui(this.getMod(), 0, this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        }
        return this.hasGui();
    }

    @Override
    public boolean openConfigGui(EntityPlayer player) {
        if (this.hasConfigGui()) {
            player.openGui(this.getMod(), 1, this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        }
        return this.hasConfigGui();
    }

    @Override
    public void sendGuiNetworkData(Container container, IContainerListener listener) {
        PacketBase guiPacket;
        if (listener instanceof EntityPlayer && (guiPacket = this.getGuiPacket()) != null) {
            PacketHandler.sendTo(guiPacket, (EntityPlayer)listener);
        }
    }

    public FluidTankCore getTank() {
        return null;
    }

    public FluidStack getTankFluid() {
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("Name")) {
            this.customName = nbt.func_74779_i("Name");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74778_a("Version", this.getModVersion());
        if (!this.customName.isEmpty()) {
            nbt.func_74778_a("Name", this.customName);
        }
        return nbt;
    }

    @Override
    public PacketBase getTilePacket() {
        PacketBase payload = super.getTilePacket();
        payload.addString(this.customName);
        return payload;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleTilePacket(PacketBase payload) {
        this.customName = payload.getString();
        this.field_145850_b.func_175664_x(this.field_174879_c);
    }

    @Override
    public String getDataType() {
        return this.getTileName();
    }

    @Override
    public void readPortableData(EntityPlayer player, NBTTagCompound tag) {
        if (!this.canPlayerAccess(player)) {
            return;
        }
        if (this.readPortableTagInternal(player, tag)) {
            this.markChunkDirty();
            this.sendTilePacket(Side.CLIENT);
        }
    }

    @Override
    public void writePortableData(EntityPlayer player, NBTTagCompound tag) {
        if (!this.canPlayerAccess(player)) {
            return;
        }
        this.writePortableTagInternal(player, tag);
    }
}

