/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.world;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;
import pokefenn.totemic.init.ModBlocks;

public class TotemTreeGeneration
extends WorldGenAbstractTree {
    public TotemTreeGeneration(boolean doNotify) {
        super(doNotify);
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        return this.growTree(world, rand, pos);
    }

    public boolean growTree(World world, Random rand, BlockPos pos) {
        int treeHeight = rand.nextInt(3) + 7;
        if (!this.canTreeGrow(world, pos, treeHeight)) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos.func_177977_b());
        state.func_177230_c().onPlantGrow(state, world, pos.func_177977_b(), pos);
        for (int curY = pos.func_177956_o() - 7 + treeHeight; curY <= pos.func_177956_o() + treeHeight; ++curY) {
            int var12 = curY - (pos.func_177956_o() + treeHeight);
            int radius = 1 - var12 / 3;
            for (int curX = pos.func_177958_n() - radius; curX <= pos.func_177958_n() + radius; ++curX) {
                int xOffset = curX - pos.func_177958_n();
                int t = xOffset >> 31;
                xOffset = xOffset + t ^ t;
                for (int curZ = pos.func_177952_p() - radius; curZ <= pos.func_177952_p() + radius; ++curZ) {
                    int zOffset = curZ - pos.func_177952_p();
                    int u = zOffset >> 31;
                    zOffset = zOffset + u ^ u;
                    BlockPos p = new BlockPos(curX, curY, curZ);
                    IBlockState s = world.func_180495_p(p);
                    Block block = s.func_177230_c();
                    if (xOffset == radius && zOffset == radius && (rand.nextInt(2) == 0 || var12 == 0) || block != null && !block.isLeaves(s, (IBlockAccess)world, p) && !block.isAir(s, (IBlockAccess)world, p)) continue;
                    this.func_175903_a(world, p, ModBlocks.cedar_leaves.func_176223_P());
                }
            }
        }
        for (int yOffset = 0; yOffset < treeHeight; ++yOffset) {
            this.func_175903_a(world, pos.func_177981_b(yOffset), ModBlocks.cedar_log.func_176223_P());
        }
        return true;
    }

    public boolean canTreeGrow(World world, BlockPos pos, int treeHeight) {
        if (pos.func_177956_o() < 1 || pos.func_177956_o() + treeHeight + 1 > world.func_72800_K()) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos.func_177977_b());
        Block block = state.func_177230_c();
        if (block == null || !block.canSustainPlant(state, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)ModBlocks.cedar_sapling)) {
            return false;
        }
        for (int yOffset = pos.func_177956_o() + 1; yOffset <= pos.func_177956_o() + 1 + treeHeight; ++yOffset) {
            int radius = 2;
            if (yOffset >= pos.func_177956_o() + 1 + treeHeight - 2) {
                radius = 1;
            }
            if (yOffset >= 0 && yOffset < world.func_72800_K()) {
                for (int xOffset = pos.func_177958_n() - radius; xOffset <= pos.func_177958_n() + radius; ++xOffset) {
                    for (int zOffset = pos.func_177952_p() - radius; zOffset <= pos.func_177952_p() + radius; ++zOffset) {
                        BlockPos p = new BlockPos(xOffset, yOffset, zOffset);
                        if (this.isReplaceable(world, p)) continue;
                        return false;
                    }
                }
                continue;
            }
            return false;
        }
        block = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        return block != null;
    }
}

