/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.util;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityUtil {
    public static <T extends Entity> List<T> listEntitiesInRange(Class<? extends T> clazz, World world, double posX, double posY, double posZ, double horizontal, double vertical, Predicate<? super T> filter) {
        return world.func_175647_a(clazz, new AxisAlignedBB(posX - horizontal, posY - vertical, posZ - horizontal, posX + horizontal, posY + vertical, posZ + horizontal), filter);
    }

    public static <T extends Entity> List<T> listEntitiesInRange(Class<? extends T> type, World world, BlockPos pos, double horizontal, double vertical, Predicate<? super T> filter) {
        Objects.requireNonNull(filter);
        AxisAlignedBB aabb = new AxisAlignedBB(pos).func_72314_b(horizontal - 1.0, vertical - 1.0, horizontal - 1.0);
        return world.func_175647_a(type, aabb, filter);
    }

    public static <T extends Entity> List<T> listEntitiesInRange(Class<? extends T> type, World world, BlockPos pos, double horizontal, double vertical) {
        return EntityUtil.listEntitiesInRange(type, world, pos, horizontal, vertical, EntitySelectors.field_180132_d);
    }

    public static <T extends TileEntity> List<T> getTileEntitiesInRange(Class<? extends T> clazz, World world, BlockPos pos, int horizontalRadius, int verticalRadius) {
        return EntityUtil.getTileEntitiesIn(clazz, world, pos.func_177982_a(-horizontalRadius, -verticalRadius, -horizontalRadius), pos.func_177982_a(horizontalRadius + 1, verticalRadius + 1, horizontalRadius + 1));
    }

    public static <T extends TileEntity> List<T> getTileEntitiesIn(Class<? extends T> clazz, World world, BlockPos min, BlockPos max) {
        ArrayList<TileEntity> list = new ArrayList<TileEntity>();
        for (int x = min.func_177958_n() & 0xFFFFFFF0; x < max.func_177958_n(); x += 16) {
            for (int z = min.func_177952_p() & 0xFFFFFFF0; z < max.func_177952_p(); z += 16) {
                Chunk chunk;
                if (!world.func_175668_a(new BlockPos(x, 0, z), true) || (chunk = world.func_72964_e(x >> 4, z >> 4)) == null || chunk.func_76621_g()) continue;
                for (TileEntity tile : chunk.func_177434_r().values()) {
                    BlockPos pos;
                    if (!clazz.isInstance(tile) || tile.func_145837_r() || (pos = tile.func_174877_v()).func_177958_n() < min.func_177958_n() || pos.func_177956_o() < min.func_177956_o() || pos.func_177952_p() < min.func_177952_p() || pos.func_177958_n() >= max.func_177958_n() || pos.func_177956_o() >= max.func_177956_o() || pos.func_177952_p() >= max.func_177952_p()) continue;
                    list.add(tile);
                }
            }
        }
        return list;
    }

    public static void spawnEntity(World world, double xPos, double yPos, double zPos, Entity entity) {
        entity.func_70107_b(xPos, yPos, zPos);
        world.func_72838_d(entity);
    }

    public static void dropItem(World world, double xPos, double yPos, double zPos, ItemStack itemStack) {
        EntityItem item = new EntityItem(world, xPos, yPos, zPos, itemStack);
        item.func_174869_p();
        world.func_72838_d((Entity)item);
    }

    @SideOnly(value=Side.CLIENT)
    public static EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }
}

