/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.totempedia.page;

import java.util.Collections;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pokefenn.totemic.api.internal.IGuiLexiconEntry;
import pokefenn.totemic.api.lexicon.LexiconEntry;
import pokefenn.totemic.api.lexicon.LexiconRecipeMappings;
import pokefenn.totemic.client.TotemicRenderHelper;
import pokefenn.totemic.totempedia.page.PageRecipe;

public class PageCraftingRecipe
extends PageRecipe {
    private static final ResourceLocation craftingOverlay = new ResourceLocation("totemic:textures/gui/crafting_overlay.png");
    private final IRecipe recipe;
    private final int recipeWidth;
    private final boolean shapelessRecipe;
    private int ticksElapsed = 0;
    private int recipeIndex = 0;
    private static final IRecipe DUMMY_RECIPE = new ShapelessRecipes("", ItemStack.field_190927_a, NonNullList.func_191196_a());

    private static IRecipe getRecipeOrDummy(ResourceLocation name) {
        IRecipe recipe = CraftingManager.func_193373_a((ResourceLocation)name);
        return recipe != null ? recipe : DUMMY_RECIPE;
    }

    public PageCraftingRecipe(String unlocalizedName, IRecipe recipe) {
        super(unlocalizedName);
        this.recipe = Objects.requireNonNull(recipe);
        if (recipe instanceof IShapedRecipe) {
            this.recipeWidth = ((IShapedRecipe)recipe).getRecipeWidth();
            this.shapelessRecipe = false;
        } else {
            this.recipeWidth = 3;
            this.shapelessRecipe = true;
        }
    }

    public PageCraftingRecipe(String unlocalizedName, String recipe) {
        this(unlocalizedName, PageCraftingRecipe.getRecipeOrDummy(new ResourceLocation(recipe)));
    }

    @Override
    public void onPageAdded(LexiconEntry entry, int index) {
        if (this.recipe != DUMMY_RECIPE) {
            LexiconRecipeMappings.map(this.recipe.func_77571_b(), entry, index);
        } else {
            this.unlocalizedName = "totemic.gui.lexicon.recipeNotAvailable";
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderRecipe(IGuiLexiconEntry gui, int mx, int my) {
        this.renderCraftingRecipe(gui);
        TextureManager render = Minecraft.func_71410_x().field_71446_o;
        render.func_110577_a(craftingOverlay);
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ((GuiScreen)gui).func_73729_b(gui.getLeft(), gui.getTop(), 0, 0, gui.getWidth(), gui.getHeight());
        if (this.shapelessRecipe) {
            int iconX = gui.getLeft() + 115;
            int iconY = gui.getTop() + 12;
            ((GuiScreen)gui).func_73729_b(iconX, iconY, 240, 0, 16, 16);
            if (mx >= iconX && my >= iconY && mx < iconX + 16 && my < iconY + 16) {
                TotemicRenderHelper.renderTooltip(mx, my, Collections.singletonList(I18n.func_135052_a((String)"totemicmisc.shapeless", (Object[])new Object[0])));
            }
        }
        GlStateManager.func_179084_k();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void updateScreen() {
        if (this.ticksElapsed % 30 == 0) {
            ++this.recipeIndex;
        }
        ++this.ticksElapsed;
    }

    @SideOnly(value=Side.CLIENT)
    private void renderCraftingRecipe(IGuiLexiconEntry gui) {
        int x = 0;
        int y = 0;
        for (Ingredient ingredient : this.recipe.func_192400_c()) {
            if (ingredient != Ingredient.field_193370_a) {
                ItemStack[] stacks = ingredient.func_193365_a();
                this.renderItemAtGridPos(gui, 1 + x, 1 + y, stacks[this.recipeIndex % stacks.length], true);
            }
            if (++x < this.recipeWidth) continue;
            x = 0;
            ++y;
        }
        this.renderItemAtGridPos(gui, 2, 0, this.recipe.func_77571_b(), false);
    }
}

