/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.tileentity.totem;

import com.google.common.collect.Multiset;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pokefenn.totemic.api.music.MusicInstrument;
import pokefenn.totemic.api.totem.TotemEffect;
import pokefenn.totemic.network.NetworkHandler;
import pokefenn.totemic.network.server.PacketTotemEffectMusic;
import pokefenn.totemic.tileentity.totem.StateSelection;
import pokefenn.totemic.tileentity.totem.TileTotemBase;
import pokefenn.totemic.tileentity.totem.TotemState;

public final class StateTotemEffect
extends TotemState {
    static final int ID = 0;
    private int musicAmount = 0;
    private boolean musicAdded = false;

    StateTotemEffect(TileTotemBase tile) {
        super(tile);
    }

    public void func_73660_a() {
        World world = this.tile.func_145831_w();
        long totalWorldTime = world.func_82737_E();
        if (totalWorldTime % (long)this.tile.getCommonTotemEffectInterval() == 0L) {
            for (Multiset.Entry entry : this.tile.getTotemEffectSet().entrySet()) {
                TotemEffect effect = (TotemEffect)((Object)entry.getElement());
                if (totalWorldTime % (long)effect.getInterval() != 0L) continue;
                effect.effect(world, this.tile.func_174877_v(), this.tile, entry.getCount());
            }
        }
        if (this.musicAmount > 0 && totalWorldTime % 47L == 0L) {
            --this.musicAmount;
            this.tile.func_70296_d();
        }
        if (this.musicAdded && !world.field_72995_K && totalWorldTime % 20L == 0L) {
            NetworkHandler.sendAround(new PacketTotemEffectMusic(this.tile.func_174877_v(), this.musicAmount), this.tile, 32.0);
            this.musicAdded = false;
        }
        if (world.field_72995_K && totalWorldTime % 40L == 0L) {
            this.spawnParticles();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnParticles() {
        for (int i = 0; i < this.musicAmount / 16; ++i) {
            float xoff = 2.0f * this.tile.func_145831_w().field_73012_v.nextFloat() - 1.0f;
            float zoff = 2.0f * this.tile.func_145831_w().field_73012_v.nextFloat() - 1.0f;
            BlockPos pos = this.tile.func_174877_v();
            this.tile.func_145831_w().func_175688_a(EnumParticleTypes.NOTE, (double)pos.func_177958_n() + 0.5 + (double)xoff, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5 + (double)zoff, 0.0, 0.5, 0.0, new int[0]);
        }
    }

    @Override
    public boolean acceptMusic(MusicInstrument instr, int amount, double x, double y, double z, @Nullable Entity entity) {
        int previous = this.musicAmount;
        this.musicAmount = Math.min(previous + amount / 2, 128);
        this.spawnParticles(this.musicAmount < 128 ? EnumParticleTypes.NOTE : EnumParticleTypes.CLOUD, 3);
        if (this.musicAmount > previous) {
            this.musicAdded = true;
            this.tile.func_70296_d();
            return true;
        }
        return false;
    }

    @Override
    public boolean canSelect() {
        return true;
    }

    @Override
    public void addSelector(@Nullable Entity entity, MusicInstrument instr) {
        this.tile.setState(new StateSelection(this.tile, entity, instr));
    }

    public int getMusicAmount() {
        return this.musicAmount;
    }

    public void handleMusicPacket(PacketTotemEffectMusic msg) {
        this.musicAmount = msg.getEffectMusic();
    }

    @Override
    int getID() {
        return 0;
    }

    @Override
    void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("musicForTotemEffect", this.musicAmount);
    }

    @Override
    void readFromNBT(NBTTagCompound tag) {
        this.musicAmount = tag.func_74762_e("musicForTotemEffect");
    }
}

