/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.tileentity.totem;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import pokefenn.totemic.Totemic;
import pokefenn.totemic.advancements.ModCriteriaTriggers;
import pokefenn.totemic.api.TotemicEntityUtil;
import pokefenn.totemic.api.TotemicRegistries;
import pokefenn.totemic.api.ceremony.Ceremony;
import pokefenn.totemic.api.ceremony.StartupContext;
import pokefenn.totemic.api.music.MusicInstrument;
import pokefenn.totemic.network.NetworkHandler;
import pokefenn.totemic.network.server.PacketCeremonyStartupFull;
import pokefenn.totemic.network.server.PacketCeremonyStartupMusic;
import pokefenn.totemic.tileentity.totem.StateCeremonyEffect;
import pokefenn.totemic.tileentity.totem.StateTotemEffect;
import pokefenn.totemic.tileentity.totem.TileTotemBase;
import pokefenn.totemic.tileentity.totem.TotemState;

public final class StateStartup
extends TotemState
implements StartupContext {
    static final int ID = 2;
    private Ceremony ceremony;
    private int time = 0;
    private final Object2IntOpenHashMap<MusicInstrument> music = new Object2IntOpenHashMap(TotemicRegistries.instruments().getEntries().size());
    private int totalMusic = 0;
    private final Object2IntOpenHashMap<MusicInstrument> timesPlayed = new Object2IntOpenHashMap(TotemicRegistries.instruments().getEntries().size());
    private final Set<EntityPlayerMP> playersInRange = Collections.newSetFromMap(new WeakHashMap());

    StateStartup(TileTotemBase tile) {
        super(tile);
    }

    StateStartup(TileTotemBase tile, @Nullable Entity initiator, Ceremony ceremony) {
        this(tile);
        this.ceremony = ceremony;
    }

    public void func_73660_a() {
        World world = this.tile.func_145831_w();
        BlockPos pos = this.tile.func_174877_v();
        if (!world.field_72995_K) {
            if (this.totalMusic >= this.ceremony.getMusicNeeded()) {
                if (this.ceremony.canStartEffect(world, pos, this)) {
                    this.startCeremony();
                } else {
                    this.failCeremony();
                }
            } else if (this.time >= this.ceremony.getAdjustedMaxStartupTime(world.func_175659_aa())) {
                this.ceremony.onStartupFail(world, pos, this);
                this.failCeremony();
            } else {
                this.ceremony.onStartup(world, pos, this);
                if (this.time % 20 == 0) {
                    List players = (List)TotemicEntityUtil.getPlayersMPInRange((WorldServer)this.tile.func_145831_w(), this.tile.func_174877_v(), 16.0, 16.0, (Predicate<? super EntityPlayerMP>)Predicates.alwaysTrue()).collect(ImmutableList.toImmutableList());
                    this.playersInRange.retainAll(players);
                    for (EntityPlayerMP player : players) {
                        if (this.playersInRange.contains(player)) continue;
                        if (this.time != 0) {
                            NetworkHandler.sendToClient(new PacketCeremonyStartupFull(pos, this.time, (Object2IntMap<MusicInstrument>)this.music), player);
                        }
                        this.playersInRange.add(player);
                    }
                }
                if (this.time != 0 && this.time % 100 == 0) {
                    NetworkHandler.sendAround(new PacketCeremonyStartupFull(pos, this.time, (Object2IntMap<MusicInstrument>)this.music), this.tile, 16.0);
                }
            }
        } else {
            this.tile.setCeremonyOverlay();
        }
        ++this.time;
    }

    private void failCeremony() {
        BlockPos pos = this.tile.func_174877_v();
        ((WorldServer)this.tile.func_145831_w()).func_175739_a(EnumParticleTypes.SMOKE_LARGE, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 16, 0.6, 0.5, 0.6, 0.0, new int[0]);
        this.tile.setState(new StateTotemEffect(this.tile));
        this.tile.getState().func_73660_a();
    }

    public void startCeremony() {
        BlockPos pos = this.tile.func_174877_v();
        ((WorldServer)this.tile.func_145831_w()).func_175739_a(EnumParticleTypes.VILLAGER_HAPPY, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 24, 0.6, 0.5, 0.6, 1.0, new int[0]);
        this.tile.setState(new StateCeremonyEffect(this.tile, this.ceremony));
        this.tile.getState().func_73660_a();
        TotemicEntityUtil.getPlayersMPInRange((WorldServer)this.tile.func_145831_w(), this.tile.func_174877_v(), 8.0, 8.0).forEach(player -> ModCriteriaTriggers.PERFORM_CEREMONY.trigger((EntityPlayerMP)player, this.ceremony));
    }

    @Override
    public boolean acceptMusic(MusicInstrument instr, int amount, double x, double y, double z, @Nullable Entity entity) {
        this.timesPlayed.addTo((Object)instr, 1);
        amount = this.getDiminishedMusic(instr, amount);
        int oldVal = this.music.getInt((Object)instr);
        int newVal = Math.min(oldVal + amount, instr.getMusicMaximum());
        this.spawnParticles(newVal < instr.getMusicMaximum() ? EnumParticleTypes.NOTE : EnumParticleTypes.CLOUD, 6);
        if (newVal == oldVal) {
            return false;
        }
        this.music.put((Object)instr, newVal);
        this.totalMusic += newVal - oldVal;
        NetworkHandler.sendAround(new PacketCeremonyStartupMusic(this.tile.func_174877_v(), instr, newVal), this.tile, 16.0);
        this.tile.func_70296_d();
        return true;
    }

    private int getDiminishedMusic(MusicInstrument instr, int amount) {
        if (this.timesPlayed.getInt((Object)instr) >= amount) {
            return amount * 3 / 4;
        }
        return amount;
    }

    @Override
    int getID() {
        return 2;
    }

    @Override
    void writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("ceremony", this.ceremony.getRegistryName().toString());
        tag.func_74768_a("time", this.time);
        tag.func_74782_a("ceremonyMusic", (NBTBase)StateStartup.writeInstrumentMap(this.music));
        tag.func_74782_a("timesPlayed", (NBTBase)StateStartup.writeInstrumentMap(this.timesPlayed));
    }

    @Override
    void readFromNBT(NBTTagCompound tag) {
        this.ceremony = (Ceremony)TotemicRegistries.ceremonies().getValue(new ResourceLocation(tag.func_74779_i("ceremony")));
        if (this.ceremony == null) {
            Totemic.logger.warn("Unknown ceremony: {}", (Object)tag.func_74779_i("ceremony"));
            this.tile.setState(new StateTotemEffect(this.tile));
        }
        this.time = tag.func_74762_e("time");
        StateStartup.readInstrumentMap(this.music, tag.func_74775_l("ceremonyMusic"));
        this.totalMusic = 0;
        IntIterator intIterator = this.music.values().iterator();
        while (intIterator.hasNext()) {
            int i = (Integer)intIterator.next();
            this.totalMusic += i;
        }
        StateStartup.readInstrumentMap(this.timesPlayed, tag.func_74775_l("timesPlayed"));
    }

    private static NBTTagCompound writeInstrumentMap(Object2IntMap<MusicInstrument> map) {
        NBTTagCompound tag = new NBTTagCompound();
        for (Object2IntMap.Entry entry : map.object2IntEntrySet()) {
            tag.func_74768_a(((MusicInstrument)((Object)entry.getKey())).getRegistryName().toString(), entry.getIntValue());
        }
        return tag;
    }

    private static void readInstrumentMap(Object2IntMap<MusicInstrument> map, NBTTagCompound tag) {
        map.clear();
        for (String key : tag.func_150296_c()) {
            MusicInstrument instr = (MusicInstrument)TotemicRegistries.instruments().getValue(new ResourceLocation(key));
            if (instr != null) {
                map.put((Object)instr, tag.func_74762_e(key));
                continue;
            }
            Totemic.logger.warn("Unknown music instrument: {}", (Object)key);
        }
    }

    public Ceremony getCeremony() {
        return this.ceremony;
    }

    @Override
    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    @Override
    public int getTotalMusic() {
        return this.totalMusic;
    }

    @Override
    public int getMusic(MusicInstrument instrument) {
        return this.music.getInt((Object)instrument);
    }

    public void handleMusicPacket(PacketCeremonyStartupMusic msg) {
        int oldVal = this.music.getInt((Object)msg.getInstrument());
        this.music.put((Object)msg.getInstrument(), msg.getAmount());
        this.totalMusic += msg.getAmount() - oldVal;
    }

    public void handleFullPacket(PacketCeremonyStartupFull msg) {
        this.time = msg.getStartupTime();
        this.music.clear();
        this.totalMusic = 0;
        for (int i = 0; i < msg.getCount(); ++i) {
            MusicInstrument instr = msg.getInstrument(i);
            int value = msg.getValue(i);
            this.music.put((Object)instr, value);
            this.totalMusic += value;
        }
    }
}

