/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.network.server;

import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import pokefenn.totemic.api.TotemicRegistries;
import pokefenn.totemic.api.music.MusicInstrument;
import pokefenn.totemic.network.CSynchronizedMessageHandler;
import pokefenn.totemic.tileentity.totem.StateStartup;
import pokefenn.totemic.tileentity.totem.TileTotemBase;

public class PacketCeremonyStartupFull
implements IMessage {
    private BlockPos pos;
    private int startupTime = 0;
    private MusicInstrument[] instruments = null;
    private int[] values = null;

    public PacketCeremonyStartupFull(BlockPos pos, int startupTime, Object2IntMap<MusicInstrument> music) {
        this.pos = pos;
        this.startupTime = startupTime;
        this.instruments = (MusicInstrument[])music.keySet().toArray((Object[])new MusicInstrument[0]);
        this.values = music.values().toIntArray();
    }

    public PacketCeremonyStartupFull() {
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.startupTime = buf.readInt();
        int len = buf.readByte();
        this.instruments = new MusicInstrument[len];
        this.values = new int[len];
        for (int i = 0; i < len; ++i) {
            this.instruments[i] = (MusicInstrument)((ForgeRegistry)TotemicRegistries.instruments()).getValue((int)buf.readByte());
            this.values[i] = buf.readShort();
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        buf.writeInt(this.startupTime);
        buf.writeByte(this.instruments.length);
        for (int i = 0; i < this.instruments.length; ++i) {
            buf.writeByte(((ForgeRegistry)TotemicRegistries.instruments()).getID((IForgeRegistryEntry)this.instruments[i]));
            buf.writeShort(this.values[i]);
        }
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public int getStartupTime() {
        return this.startupTime;
    }

    public int getCount() {
        return this.instruments.length;
    }

    public MusicInstrument getInstrument(int i) {
        return this.instruments[i];
    }

    public int getValue(int i) {
        return this.values[i];
    }

    public static class Handler
    extends CSynchronizedMessageHandler<PacketCeremonyStartupFull> {
        @Override
        protected void handleClient(PacketCeremonyStartupFull msg) {
            TileTotemBase totem;
            TileEntity tile = Minecraft.func_71410_x().field_71441_e.func_175625_s(msg.pos);
            if (tile instanceof TileTotemBase && (totem = (TileTotemBase)tile).getState() instanceof StateStartup) {
                ((StateStartup)totem.getState()).handleFullPacket(msg);
            }
        }
    }
}

