/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.entity.animal;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollow;
import net.minecraft.entity.ai.EntityAIFollowOwnerFlying;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWaterFlying;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityFlyHelper;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityFlying;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNavigateFlying;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import pokefenn.totemic.init.ModSounds;
import pokefenn.totemic.lib.Resources;

public class EntityBaldEagle
extends EntityTameable
implements EntityFlying {
    public float flap;
    public float flapSpeed;
    public float oFlapSpeed;
    public float oFlap;
    public float flapping = 1.0f;

    public EntityBaldEagle(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.0f);
        this.field_70765_h = new EntityFlyHelper((EntityLiving)this);
    }

    protected void func_184651_r() {
        this.field_70911_d = new EntityAISit((EntityTameable)this);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.25));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.field_70911_d);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFollowOwnerFlying((EntityTameable)this, 1.0, 5.0f, 1.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWanderAvoidWaterFlying((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollow((EntityLiving)this, 1.0, 3.0f, 7.0f));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_193334_e);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_193334_e).func_111128_a(0.4);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
    }

    protected PathNavigate func_175447_b(World worldIn) {
        PathNavigateFlying navigator = new PathNavigateFlying((EntityLiving)this, worldIn);
        navigator.func_192879_a(false);
        navigator.func_192877_c(true);
        navigator.func_192878_b(true);
        return navigator;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.6f;
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.calculateFlapping();
    }

    private void calculateFlapping() {
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        this.flapSpeed = (float)((double)this.flapSpeed + (double)(this.field_70122_E ? -1 : 4) * 0.3);
        this.flapSpeed = MathHelper.func_76131_a((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        if (!this.field_70122_E && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping = (float)((double)this.flapping * 0.9);
        if (!this.field_70122_E && this.field_70181_x < 0.0) {
            this.field_70181_x *= 0.6;
        }
        this.flap += this.flapping * 2.0f;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!this.func_70909_n() && stack.func_77973_b() == Items.field_151115_aP) {
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            if (!this.func_174814_R()) {
                this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_192797_eu, this.func_184176_by(), 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70146_Z.nextInt(10) == 0 && !ForgeEventFactory.onAnimalTame((EntityAnimal)this, (EntityPlayer)player)) {
                    this.func_193101_c(player);
                    this.func_70908_e(true);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                } else {
                    this.func_70908_e(false);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
            }
            return true;
        }
        if (!this.field_70170_p.field_72995_K && !this.isFlying() && this.func_70909_n() && this.func_152114_e((EntityLivingBase)player)) {
            this.field_70911_d.func_75270_a(!this.func_70906_o());
        }
        return super.func_184645_a(player, hand);
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151115_aP && stack.func_77960_j() == ItemFishFood.FishType.SALMON.func_150976_a();
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (!this.func_70909_n()) {
            return false;
        }
        if (!(otherAnimal instanceof EntityBaldEagle)) {
            return false;
        }
        EntityBaldEagle otherEagle = (EntityBaldEagle)otherAnimal;
        if (!otherEagle.func_70909_n()) {
            return false;
        }
        if (otherEagle.func_70906_o()) {
            return false;
        }
        return this.func_70880_s() && otherEagle.func_70880_s();
    }

    @Nullable
    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        EntityBaldEagle child = new EntityBaldEagle(this.field_70170_p);
        UUID uuid = this.func_184753_b();
        if (uuid != null) {
            child.func_184754_b(uuid);
            child.func_70903_f(true);
        }
        return child;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return ModSounds.baldEagleAmbient;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return ModSounds.baldEagleHurt;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return ModSounds.baldEagleDeath;
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        this.func_184185_a(SoundEvents.field_192795_es, 0.15f, 1.0f);
    }

    protected float func_191954_d(float distance) {
        this.func_184185_a(SoundEvents.field_192796_et, 0.15f, 1.0f);
        return distance + this.flapSpeed / 2.0f;
    }

    protected boolean func_191957_ae() {
        return true;
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.NEUTRAL;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (this.field_70911_d != null) {
            this.field_70911_d.func_75270_a(false);
        }
        return super.func_70097_a(source, amount);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return Resources.LOOT_BALD_EAGLE;
    }

    public boolean isFlying() {
        return !this.field_70122_E;
    }
}

