/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.block.totem;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import pokefenn.totemic.Totemic;
import pokefenn.totemic.api.TotemicRegistries;
import pokefenn.totemic.api.TotemicStaffUsage;
import pokefenn.totemic.api.totem.TotemEffect;
import pokefenn.totemic.block.totem.BlockTotemBase;
import pokefenn.totemic.item.equipment.ItemTotemWhittlingKnife;
import pokefenn.totemic.lib.WoodVariant;
import pokefenn.totemic.tileentity.totem.TileTotemPole;

public class BlockTotemPole
extends Block
implements ITileEntityProvider,
TotemicStaffUsage {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyEnum<WoodVariant> WOOD = BlockTotemBase.WOOD;
    public static final IUnlistedProperty<TotemEffect> TOTEM = new IUnlistedProperty<TotemEffect>(){

        public String getName() {
            return "totem";
        }

        public boolean isValid(TotemEffect value) {
            return true;
        }

        public Class<TotemEffect> getType() {
            return TotemEffect.class;
        }

        public String valueToString(TotemEffect value) {
            return value != null ? value.getRegistryName().toString() : "blank";
        }
    };
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);

    public BlockTotemPole() {
        super(Material.field_151575_d);
        this.setRegistryName("totem_pole");
        this.func_149663_c("totemic:totem_pole");
        this.func_149647_a(Totemic.tabsTotem);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185848_a);
        Blocks.field_150480_ab.func_180686_a((Block)this, 5, 5);
    }

    @Override
    public EnumActionResult onTotemicStaffRightClick(World world, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            TileTotemPole pole = (TileTotemPole)world.func_175625_s(pos);
            String name = pole.getEffect() != null ? pole.getEffect().getUnlocalizedName() : "totemicmisc.noEffect";
            player.func_146105_b((ITextComponent)new TextComponentTranslation("totemicmisc.activeEffect", new Object[]{new TextComponentTranslation(name, new Object[0])}), true);
        }
        return EnumActionResult.SUCCESS;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entityLiving, ItemStack stack) {
        if (stack.func_77973_b() == Item.func_150898_a((Block)this)) {
            TileTotemPole tile = (TileTotemPole)world.func_175625_s(pos);
            tile.setWoodType(WoodVariant.fromID(stack.func_77960_j()));
            tile.setEffect(ItemTotemWhittlingKnife.getCarvingEffect(stack));
        }
        this.notifyTotemBase(world, pos);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        super.func_180663_b(world, pos, state);
        this.notifyTotemBase(world, pos);
    }

    private void notifyTotemBase(World world, BlockPos pos) {
        for (int i = 0; i < 5; ++i) {
            Block block = world.func_180495_p(pos.func_177979_c(i + 1)).func_177230_c();
            if (block instanceof BlockTotemBase) {
                world.func_175641_c(pos.func_177979_c(i + 1), block, 0, 0);
                break;
            }
            if (!(block instanceof BlockTotemPole)) break;
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileTotemPole tile = (TileTotemPole)world.func_175625_s(pos);
        ItemStack stack = new ItemStack((Block)this, 1, tile.getWoodType().getID());
        TotemEffect effect = tile.getEffect();
        String effectName = effect != null ? effect.getRegistryName().toString() : "";
        stack.func_77983_a("totem", (NBTBase)new NBTTagString(effectName));
        return stack;
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (TotemEffect effect : TotemicRegistries.totemEffects()) {
            ItemStack stack = new ItemStack((Block)this, 1, 0);
            stack.func_77983_a("totem", (NBTBase)new NBTTagString(effect.getRegistryName().toString()));
            items.add((Object)stack);
        }
        ItemStack blankStack = new ItemStack((Block)this, 1, 0);
        blankStack.func_77983_a("totem", (NBTBase)new NBTTagString(""));
        items.add((Object)blankStack);
    }

    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        TotemEffect effect = ItemTotemWhittlingKnife.getCarvingEffect(stack);
        if (effect != null) {
            tooltip.add(I18n.func_135052_a((String)effect.getUnlocalizedName(), (Object[])new Object[0]));
        } else {
            tooltip.add(I18n.func_135052_a((String)(this.func_149739_a() + ".noEffect"), (Object[])new Object[0]));
        }
    }

    public int func_149745_a(Random rand) {
        return 0;
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileTotemPole) {
            return ((TileTotemPole)tile).getWoodType().getMapColor();
        }
        return MapColor.field_151663_o;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{FACING, WOOD}).add(new IUnlistedProperty[]{TOTEM}).build();
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileTotemPole) {
            return state.func_177226_a(WOOD, (Comparable)((Object)((TileTotemPole)tile).getWoodType()));
        }
        return state;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState extState = (IExtendedBlockState)state;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileTotemPole) {
            return extState.withProperty(TOTEM, (Object)((TileTotemPole)tile).getEffect());
        }
        return extState.withProperty(TOTEM, null);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        TileTotemPole tile = new TileTotemPole();
        tile.setWoodType((WoodVariant)((Object)state.func_177229_b(WOOD)));
        return tile;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileTotemPole();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing facing) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }
}

