/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic.block.tipi;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Biomes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pokefenn.totemic.Totemic;
import pokefenn.totemic.init.ModBlocks;
import pokefenn.totemic.tileentity.TileTipi;

public class BlockTipi
extends Block
implements ITileEntityProvider {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);

    public BlockTipi() {
        super(Material.field_151580_n);
        this.setRegistryName("tipi");
        this.func_149663_c("totemic:tipi");
        this.func_149711_c(0.2f);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_149647_a(Totemic.tabsTotem);
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing dir = EnumFacing.func_176733_a((double)placer.field_70177_z);
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)dir);
    }

    private boolean tipiSleep(World world, BlockPos pos, EntityPlayer player) {
        if (!world.field_72995_K) {
            if (world.func_180494_b(pos) != Biomes.field_76778_j) {
                if (world.field_73011_w.func_76567_e()) {
                    EntityPlayer otherPlayer = null;
                    for (EntityPlayer playerEntity : world.field_73010_i) {
                        BlockPos playerPos;
                        if (!playerEntity.func_70608_bn() || !(playerPos = new BlockPos(playerEntity.field_70165_t, playerEntity.field_70163_u, playerEntity.field_70161_v)).equals((Object)pos)) continue;
                        otherPlayer = playerEntity;
                    }
                    if (otherPlayer != null) {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.bed.occupied", new Object[0]), true);
                        return true;
                    }
                    EntityPlayer.SleepResult sleepresult = player.func_180469_a(pos);
                    if (sleepresult == EntityPlayer.SleepResult.OK) {
                        return true;
                    }
                    if (sleepresult == EntityPlayer.SleepResult.NOT_POSSIBLE_NOW) {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.bed.noSleep", new Object[0]), true);
                    } else if (sleepresult == EntityPlayer.SleepResult.NOT_SAFE) {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.bed.notSafe", new Object[0]), true);
                    }
                    return true;
                }
                player.func_146105_b((ITextComponent)new TextComponentTranslation("totemicmisc.tipi.nether", new Object[0]), true);
            } else {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("totemicmisc.tipi.cantSleep", new Object[0]), true);
            }
        }
        return true;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return this.tipiSleep(world, pos, player);
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        int height = 5;
        int radius = 2;
        for (int i = -radius; i <= radius; ++i) {
            for (int j = 0; j <= height; ++j) {
                for (int k = -radius; k <= radius; ++k) {
                    BlockPos p = pos.func_177982_a(i, j, k);
                    IBlockState s = world.func_180495_p(p);
                    if (s.func_177230_c() != ModBlocks.dummy_tipi) continue;
                    world.func_175698_g(p);
                }
            }
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        int height = 5;
        int radius = 2;
        for (int i = -radius; i <= radius; ++i) {
            for (int j = 0; j <= height; ++j) {
                for (int k = -radius; k <= radius; ++k) {
                    BlockPos p = pos.func_177982_a(i, j, k);
                    IBlockState s = world.func_180495_p(p);
                    if (s.func_177230_c() != ModBlocks.dummy_tipi) continue;
                    world.func_175698_g(p);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return null;
    }

    public boolean isBed(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable Entity player) {
        return true;
    }

    public void setBedOccupied(IBlockAccess world, BlockPos pos, EntityPlayer player, boolean occupied) {
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileTipi();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.field_176754_o[meta]);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state.func_177226_a((IProperty)FACING, (Comparable)mirror.func_185803_b((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing facing) {
        return BlockFaceShape.UNDEFINED;
    }
}

