/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic;

import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.datafix.FixTypes;
import net.minecraft.util.datafix.IFixType;
import net.minecraft.util.datafix.IFixableData;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.util.ModFixs;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;
import pokefenn.totemic.Totemic;
import pokefenn.totemic.advancements.ModCriteriaTriggers;
import pokefenn.totemic.api.TotemicRegistries;
import pokefenn.totemic.api.ceremony.Ceremony;
import pokefenn.totemic.api.music.DefaultMusicAcceptor;
import pokefenn.totemic.api.music.MusicAcceptor;
import pokefenn.totemic.configuration.ModConfig;
import pokefenn.totemic.datafix.CamelCaseNamesItems;
import pokefenn.totemic.datafix.CamelCaseNamesTiles;
import pokefenn.totemic.datafix.TotemWoodToTileEntity;
import pokefenn.totemic.datafix.VanillaIronNugget;
import pokefenn.totemic.entity.animal.EntityBaldEagle;
import pokefenn.totemic.entity.animal.EntityBuffalo;
import pokefenn.totemic.entity.boss.EntityBaykok;
import pokefenn.totemic.entity.projectile.EntityInvisArrow;
import pokefenn.totemic.handler.EntityConstruct;
import pokefenn.totemic.handler.EntityFall;
import pokefenn.totemic.handler.EntitySpawn;
import pokefenn.totemic.handler.PlayerInteract;
import pokefenn.totemic.handler.PlayerTick;
import pokefenn.totemic.init.ModBlocks;
import pokefenn.totemic.init.ModItems;
import pokefenn.totemic.item.ItemBuffaloDrops;
import pokefenn.totemic.item.ItemEagleDrops;
import pokefenn.totemic.item.ItemTotemicItems;
import pokefenn.totemic.network.GuiHandler;
import pokefenn.totemic.network.NetworkHandler;
import pokefenn.totemic.tileentity.TileDecoPillar;
import pokefenn.totemic.tileentity.TileTipi;
import pokefenn.totemic.tileentity.music.TileDrum;
import pokefenn.totemic.tileentity.music.TileWindChime;
import pokefenn.totemic.tileentity.totem.TileTotemBase;
import pokefenn.totemic.tileentity.totem.TileTotemPole;
import pokefenn.totemic.util.MiscUtil;
import pokefenn.totemic.world.ComponentMedicineWheel;
import pokefenn.totemic.world.ComponentTipi;

public class CommonProxy {
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.registerCapabilities();
        this.registerTileEntities();
        ModCriteriaTriggers.init();
    }

    public void init(FMLInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)Totemic.instance, (IGuiHandler)new GuiHandler());
        NetworkHandler.init();
        this.oreDictionary();
        this.furnaceRecipes();
        this.registerEventHandlers();
        this.registerStructures();
        this.registerDataFixers();
    }

    public void postInit(FMLPostInitializationEvent event) {
        this.checkCeremonySelectors();
    }

    @SubscribeEvent
    public void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new EntityEntry[]{EntityEntryBuilder.create().entity(EntityBuffalo.class).id("buffalo", 0).name("totemic:buffalo").tracker(80, 3, true).egg(2759698, 8937278).build(), EntityEntryBuilder.create().entity(EntityBaykok.class).id("baykok", 1).name("totemic:baykok").tracker(80, 3, true).egg(0xE0E0E0, 16308946).build(), EntityEntryBuilder.create().entity(EntityInvisArrow.class).id("invis_arrow", 2).name("totemic:invis_arrow").tracker(64, 20, true).build(), EntityEntryBuilder.create().entity(EntityBaldEagle.class).id("bald_eagle", 3).name("totemic:bald_eagle").tracker(80, 3, true).egg(4931894, 16115363).build()});
    }

    private void registerCapabilities() {
        CapabilityManager.INSTANCE.register(MusicAcceptor.class, (Capability.IStorage)new DefaultMusicAcceptor.Storage(), DefaultMusicAcceptor::new);
    }

    private void registerTileEntities() {
        GameRegistry.registerTileEntity(TileTotemBase.class, (ResourceLocation)new ResourceLocation("totemic", "totem_base"));
        GameRegistry.registerTileEntity(TileTotemPole.class, (ResourceLocation)new ResourceLocation("totemic", "totem_pole"));
        GameRegistry.registerTileEntity(TileDrum.class, (ResourceLocation)new ResourceLocation("totemic", "drum"));
        GameRegistry.registerTileEntity(TileWindChime.class, (ResourceLocation)new ResourceLocation("totemic", "wind_chime"));
        GameRegistry.registerTileEntity(TileTipi.class, (ResourceLocation)new ResourceLocation("totemic", "tipi"));
        GameRegistry.registerTileEntity(TileDecoPillar.class, (ResourceLocation)new ResourceLocation("totemic", "wooden_pillar"));
    }

    private void oreDictionary() {
        OreDictionary.registerOre((String)"treeLeaves", (ItemStack)new ItemStack((Block)ModBlocks.cedar_leaves));
        OreDictionary.registerOre((String)"treeSapling", (ItemStack)new ItemStack((Block)ModBlocks.cedar_sapling));
        OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack((Block)ModBlocks.cedar_log));
        OreDictionary.registerOre((String)"plankWood", (ItemStack)new ItemStack((Block)ModBlocks.cedar_plank));
        OreDictionary.registerOre((String)"slabWood", (ItemStack)new ItemStack((Block)ModBlocks.cedar_slab));
        OreDictionary.registerOre((String)"stairWood", (ItemStack)new ItemStack((Block)ModBlocks.cedar_stairs));
        OreDictionary.registerOre((String)"fenceWood", (ItemStack)new ItemStack((Block)ModBlocks.cedar_fence));
        OreDictionary.registerOre((String)"fenceGateWood", (ItemStack)new ItemStack((Block)ModBlocks.cedar_fence_gate));
        OreDictionary.registerOre((String)"bellsIron", (ItemStack)new ItemStack((Item)ModItems.sub_items, 1, ItemTotemicItems.Type.iron_bells.ordinal()));
        OreDictionary.registerOre((String)"listAllmeatraw", (ItemStack)new ItemStack((Item)ModItems.buffalo_meat));
        OreDictionary.registerOre((String)"listAllbeefraw", (ItemStack)new ItemStack((Item)ModItems.buffalo_meat));
        OreDictionary.registerOre((String)"listAllbuffaloraw", (ItemStack)new ItemStack((Item)ModItems.buffalo_meat));
        OreDictionary.registerOre((String)"listAllmeatcooked", (ItemStack)new ItemStack((Item)ModItems.cooked_buffalo_meat));
        OreDictionary.registerOre((String)"listAllbeefcooked", (ItemStack)new ItemStack((Item)ModItems.cooked_buffalo_meat));
        OreDictionary.registerOre((String)"listAllbuffalocooked", (ItemStack)new ItemStack((Item)ModItems.cooked_buffalo_meat));
        OreDictionary.registerOre((String)"hideBuffalo", (ItemStack)new ItemStack((Item)ModItems.buffalo_items, 1, ItemBuffaloDrops.Type.hide.ordinal()));
        OreDictionary.registerOre((String)"teethBuffalo", (ItemStack)new ItemStack((Item)ModItems.buffalo_items, 1, ItemBuffaloDrops.Type.teeth.ordinal()));
        OreDictionary.registerOre((String)"bone", (ItemStack)new ItemStack((Item)ModItems.eagle_drops, 1, ItemEagleDrops.Type.bone.ordinal()));
        OreDictionary.registerOre((String)"feather", (ItemStack)new ItemStack((Item)ModItems.eagle_drops, 1, ItemEagleDrops.Type.feather.ordinal()));
    }

    private void furnaceRecipes() {
        GameRegistry.addSmelting((Block)ModBlocks.stripped_cedar_log, (ItemStack)new ItemStack(Items.field_151044_h, 1, 1), (float)0.5f);
        GameRegistry.addSmelting((Block)ModBlocks.cedar_log, (ItemStack)new ItemStack(Items.field_151044_h, 1, 1), (float)0.5f);
        GameRegistry.addSmelting((Item)ModItems.buffalo_meat, (ItemStack)new ItemStack((Item)ModItems.cooked_buffalo_meat), (float)0.35f);
    }

    private void registerStructures() {
        MapGenStructureIO.func_143031_a(ComponentTipi.class, (String)"totemic:ViTi");
        if (ModConfig.general.enableVillageTipi) {
            VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new ComponentTipi.CreationHandler());
        }
        MapGenStructureIO.func_143031_a(ComponentMedicineWheel.class, (String)"totemic:ViCer");
        if (ModConfig.general.enableVillageMedicineWheel) {
            VillagerRegistry.instance().registerVillageCreationHandler((VillagerRegistry.IVillageCreationHandler)new ComponentMedicineWheel.CreationHandler());
        }
    }

    private void registerDataFixers() {
        ModFixs fixes = FMLCommonHandler.instance().getDataFixer().init("totemic", 1020);
        fixes.registerFix((IFixType)FixTypes.ITEM_INSTANCE, (IFixableData)new VanillaIronNugget());
        fixes.registerFix((IFixType)FixTypes.BLOCK_ENTITY, (IFixableData)new CamelCaseNamesTiles());
        fixes.registerFix((IFixType)FixTypes.ITEM_INSTANCE, (IFixableData)new CamelCaseNamesItems());
        fixes.registerFix((IFixType)FixTypes.CHUNK, (IFixableData)new TotemWoodToTileEntity());
    }

    protected void registerEventHandlers() {
        MinecraftForge.EVENT_BUS.register((Object)new PlayerTick());
        MinecraftForge.EVENT_BUS.register((Object)new EntityFall());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerInteract());
        if (ModConfig.general.skeletonsShouldAttackBuffalos) {
            MinecraftForge.EVENT_BUS.register((Object)new EntitySpawn());
        }
        if (ModConfig.general.randomizeVillagerProfessions) {
            MinecraftForge.EVENT_BUS.register((Object)new EntityConstruct());
        }
    }

    private void checkCeremonySelectors() {
        for (Ceremony ceremony1 : TotemicRegistries.ceremonies()) {
            for (Ceremony ceremony2 : TotemicRegistries.ceremonies()) {
                if (ceremony1 == ceremony2 || !MiscUtil.isPrefix(ceremony1.getSelectors(), ceremony2.getSelectors())) continue;
                throw new IllegalStateException(String.format("The selectors of Ceremony %1$s are prefixing the selectors of %2$s. This would make selecting %2$s impossible.\n%3$s prefixes %4$s", ceremony1.getRegistryName(), ceremony2.getRegistryName(), ceremony1.getSelectors(), ceremony2.getSelectors()));
            }
        }
    }
}

