/*
 * Decompiled with CFR 0.152.
 */
package pokefenn.totemic;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraft.world.ColorizerFoliage;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pokefenn.totemic.CommonProxy;
import pokefenn.totemic.Totemic;
import pokefenn.totemic.client.rendering.entity.BaldEagleRendering;
import pokefenn.totemic.client.rendering.entity.BaykokRendering;
import pokefenn.totemic.client.rendering.entity.BuffaloRendering;
import pokefenn.totemic.client.rendering.entity.InvisArrowRendering;
import pokefenn.totemic.client.rendering.model.ModelTotemPole;
import pokefenn.totemic.client.rendering.tileentity.TileWindChimeRenderer;
import pokefenn.totemic.configuration.ModConfig;
import pokefenn.totemic.entity.animal.EntityBaldEagle;
import pokefenn.totemic.entity.animal.EntityBuffalo;
import pokefenn.totemic.entity.boss.EntityBaykok;
import pokefenn.totemic.entity.projectile.EntityInvisArrow;
import pokefenn.totemic.handler.GameOverlay;
import pokefenn.totemic.handler.PlayerRender;
import pokefenn.totemic.init.ModBlocks;
import pokefenn.totemic.tileentity.music.TileWindChime;
import pokefenn.totemic.totempedia.LexiconData;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        OBJLoader.INSTANCE.addDomain("totemic");
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)ModelTotemPole.Loader.INSTANCE);
        RenderingRegistry.registerEntityRenderingHandler(EntityBuffalo.class, BuffaloRendering::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityInvisArrow.class, InvisArrowRendering::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityBaykok.class, BaykokRendering::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityBaldEagle.class, BaldEagleRendering::new);
        this.initTESRs();
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        this.registerBlockColors();
        LexiconData.init();
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
        if (ModConfig.client.removeNightVisionFlashing && !Loader.isModLoaded((String)"nonvflash")) {
            this.removeNightVisionFlashing();
        }
    }

    @Override
    protected void registerEventHandlers() {
        super.registerEventHandlers();
        MinecraftForge.EVENT_BUS.register((Object)new GameOverlay());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerRender());
    }

    private static int getTotemPolePaintColor(int tintIndex) {
        switch (tintIndex) {
            case 1: {
                return 0x555555;
            }
            case 2: {
                return 0xAA5555;
            }
            case 3: {
                return 0xAA55EE;
            }
            case 4: {
                return 0xBBBB66;
            }
        }
        return -1;
    }

    private void registerBlockColors() {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_184125_al().func_186722_a((state, world, pos, tintIndex) -> ColorizerFoliage.func_77466_a(), new Block[]{ModBlocks.cedar_leaves});
        mc.func_184125_al().func_186722_a((state, world, pos, tintIndex) -> ClientProxy.getTotemPolePaintColor(tintIndex), new Block[]{ModBlocks.totem_pole});
        mc.getItemColors().func_186731_a((stack, tintIndex) -> ClientProxy.getTotemPolePaintColor(tintIndex), new Block[]{ModBlocks.totem_pole});
    }

    private void initTESRs() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileWindChime.class, (TileEntitySpecialRenderer)new TileWindChimeRenderer());
    }

    private void removeNightVisionFlashing() {
        EntityRenderer newRenderer;
        Totemic.logger.debug("Replacing EntityRenderer to remove Night Vision flashing");
        Minecraft minecraft = Minecraft.func_71410_x();
        EntityRenderer oldRenderer = minecraft.field_71460_t;
        if (oldRenderer.getClass() != EntityRenderer.class) {
            Totemic.logger.warn("Another mod already replaced the EntityRenderer. This might cause problems. Class name: {}", (Object)oldRenderer.getClass().getName());
        }
        minecraft.field_71460_t = newRenderer = new EntityRenderer(minecraft, minecraft.func_110442_L()){

            protected float func_180438_a(EntityLivingBase entity, float partialTicks) {
                int duration = entity.func_70660_b(MobEffects.field_76439_r).func_76459_b();
                if (duration > 200) {
                    return 1.0f;
                }
                if (duration > 100) {
                    return (float)(duration - 100) / 100.0f;
                }
                return 0.0f;
            }
        };
        SimpleReloadableResourceManager resourceManager = (SimpleReloadableResourceManager)minecraft.func_110442_L();
        List listeners = (List)ReflectionHelper.getPrivateValue(SimpleReloadableResourceManager.class, (Object)resourceManager, (String)"reloadListeners", (String)"field_110546_b");
        listeners.remove(oldRenderer);
        resourceManager.func_110542_a((IResourceManagerReloadListener)newRenderer);
    }
}

