/*
 * Decompiled with CFR 0.152.
 */
package net.ndrei.teslacorelib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.ndrei.teslacorelib.MaterialInfo;
import net.ndrei.teslacorelib.MaterialRegistries;
import net.ndrei.teslacorelib.TeslaCoreLib;
import net.ndrei.teslacorelib.annotations.AutoRegisterColoredThingyHandler;
import net.ndrei.teslacorelib.compatibility.IBlockColorDelegate;
import net.ndrei.teslacorelib.compatibility.IItemColorDelegate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003B0\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012!\u0010\u0006\u001a\u001d\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\u0002\u0010\u000bJ7\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u00052'\u0010\u0013\u001a#\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00028\u00000\u0014\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00028\u00000\u0007J\u0016\u0010\u0016\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000e2\u0006\u0010\n\u001a\u00020\u0005J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0018J\u0015\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u000e\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u001eJ\u0014\u0010\u001f\u001a\u00020\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u0006\u001a\u001d\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u00050\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lnet/ndrei/teslacorelib/MaterialRegistry;", "T", "Lnet/minecraftforge/registries/IForgeRegistryEntry;", "", "configFlag", "", "oreDictify", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "material", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "materials", "", "Lnet/ndrei/teslacorelib/MaterialInfo;", "registeredMaterials", "", "addMaterial", "", "registerCallback", "Lnet/minecraftforge/registries/IForgeRegistry;", "registry", "getMaterial", "getMaterials", "", "postProcessThing", "item", "(Lnet/minecraftforge/registries/IForgeRegistryEntry;)V", "postRegister", "asm", "Lnet/minecraftforge/fml/common/discovery/ASMDataTable;", "registerMissing", "tesla-core-lib"})
public abstract class MaterialRegistry<T extends IForgeRegistryEntry<T>> {
    private final Map<String, MaterialInfo<T>> materials;
    private final List<T> registeredMaterials;
    private final String configFlag;
    private final Function1<String, String> oreDictify;

    public final void addMaterial(@NotNull String material, @NotNull Function1<? super IForgeRegistry<T>, ? extends T> registerCallback) {
        Intrinsics.checkParameterIsNotNull((Object)material, (String)"material");
        Intrinsics.checkParameterIsNotNull(registerCallback, (String)"registerCallback");
        if (!this.materials.containsKey(material)) {
            String oreDictName = (String)this.oreDictify.invoke((Object)material);
            Map<String, MaterialInfo<T>> map = this.materials;
            MaterialInfo<? extends T> materialInfo = new MaterialInfo<T>(oreDictName, registerCallback);
            map.put(oreDictName, materialInfo);
        }
    }

    @Nullable
    public final MaterialInfo<T> getMaterial(@NotNull String material) {
        Intrinsics.checkParameterIsNotNull((Object)material, (String)"material");
        return this.materials.get(material);
    }

    @NotNull
    public final Set<String> getMaterials() {
        return CollectionsKt.toSet((Iterable)this.materials.keySet());
    }

    public final void registerMissing(@NotNull IForgeRegistry<T> registry) {
        MaterialInfo it;
        Iterable $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(registry, (String)"registry");
        CharSequence charSequence = this.configFlag;
        if (!StringsKt.isBlank((CharSequence)charSequence) && !TeslaCoreLib.INSTANCE.getModConfigFlags().getFlag(this.configFlag)) {
            return;
        }
        Iterable $receiver$iv = this.materials.values();
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (MaterialInfo)element$iv$iv;
            if (!it.getItems().isEmpty()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (MaterialInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            T item = it.registerItem(registry);
            this.registeredMaterials.add(item);
            T t = item;
            collection.add(t);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
    }

    public final void postRegister(@NotNull ASMDataTable asm) {
        Intrinsics.checkParameterIsNotNull((Object)asm, (String)"asm");
        Iterable $receiver$iv = this.registeredMaterials;
        for (Object element$iv : $receiver$iv) {
            IForgeRegistryEntry it = (IForgeRegistryEntry)element$iv;
            if (it instanceof IItemColorDelegate || it instanceof IBlockColorDelegate) {
                AutoRegisterColoredThingyHandler.INSTANCE.getHandler().invoke((Object)it, (Object)asm, null);
            }
            this.postProcessThing(it);
        }
    }

    public void postProcessThing(@NotNull T item) {
        Intrinsics.checkParameterIsNotNull(item, (String)"item");
    }

    public MaterialRegistry(@NotNull String configFlag, @NotNull Function1<? super String, String> oreDictify) {
        Intrinsics.checkParameterIsNotNull((Object)configFlag, (String)"configFlag");
        Intrinsics.checkParameterIsNotNull(oreDictify, (String)"oreDictify");
        this.configFlag = configFlag;
        this.oreDictify = oreDictify;
        MaterialRegistry materialRegistry = this;
        Object object = new LinkedHashMap();
        materialRegistry.materials = object;
        materialRegistry = this;
        materialRegistry.registeredMaterials = object = (List)new ArrayList();
        MaterialRegistries.INSTANCE.registerRegistry(this);
    }
}

