/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.util.types;

import epicsquid.roots.util.types.RegistryItem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import javax.annotation.Nullable;

public class WeightedRegistry<T extends WeightedRegistryItem>
extends ArrayList<T> {
    public WeightedRegistry(int initialCapacity) {
        super(initialCapacity);
    }

    public WeightedRegistry() {
    }

    public WeightedRegistry(Collection<? extends T> c) {
        super(c);
    }

    public int getTotalWeight() {
        return this.stream().mapToInt(WeightedRegistryItem::getWeight).sum();
    }

    @Nullable
    public T getRandomItem(Random random, int totalWeight) {
        if (totalWeight <= 0) {
            throw new IllegalArgumentException();
        }
        return this.getRandomItem(random.nextInt(totalWeight));
    }

    @Nullable
    public T getRandomItem(int weight) {
        for (WeightedRegistryItem t : this) {
            if ((weight -= t.getWeight()) >= 0) continue;
            return (T)t;
        }
        return null;
    }

    @Nullable
    public T getRandomItem(Random random) {
        return this.getRandomItem(random, this.getTotalWeight());
    }

    public static abstract class WeightedRegistryItem
    extends RegistryItem {
        private int weight = 0;

        public int getWeight() {
            return this.weight;
        }

        public void setWeight(int weight) {
            this.weight = weight;
        }
    }
}

