/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.util;

import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.roots.api.Herb;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.item.ItemPouch;
import epicsquid.roots.item.ItemSylvanArmor;
import epicsquid.roots.network.MessageUpdateHerb;
import epicsquid.roots.util.CommonHerbUtil;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ServerHerbUtil {
    public static ItemStack getFirstPouch(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return ItemStack.field_190927_a;
        }
        return CommonHerbUtil.getFirstPouch(player);
    }

    public static List<ItemStack> getPouches(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return Collections.emptyList();
        }
        return CommonHerbUtil.getPouches(player);
    }

    public static double getHerbAmount(EntityPlayer player, Herb herb) {
        if (player.field_70170_p.field_72995_K) {
            return 0.0;
        }
        List<ItemStack> pouches = ServerHerbUtil.getPouches(player);
        if (pouches.isEmpty()) {
            return -1.0;
        }
        double quantity = 0.0;
        for (ItemStack pouch : pouches) {
            if (pouch.func_77973_b() == ModItems.creative_pouch) {
                quantity += 999.0;
                continue;
            }
            quantity += ItemPouch.getHerbQuantity(player, pouch, herb);
        }
        return quantity;
    }

    public static void removePowder(EntityPlayer player, Herb herb, double amount) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        List<ItemStack> pouches = ServerHerbUtil.getPouches(player);
        double quantity = 0.0;
        double total = amount - amount * ItemSylvanArmor.sylvanBonus(player);
        for (ItemStack pouch : pouches) {
            if (pouch.func_77973_b() == ModItems.creative_pouch) continue;
            if (total > 0.0) {
                total = ItemPouch.useQuantity(player, pouch, herb, total);
            }
            quantity += ItemPouch.getHerbQuantity(player, pouch, herb);
        }
        MessageUpdateHerb message = new MessageUpdateHerb(herb, quantity);
        PacketHandler.INSTANCE.sendTo((IMessage)message, (EntityPlayerMP)player);
    }
}

