/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.tileentity;

import com.google.common.collect.Lists;
import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.mysticallib.particle.particles.ParticleLeaf;
import epicsquid.mysticallib.proxy.ClientProxy;
import epicsquid.mysticallib.util.ItemUtil;
import epicsquid.mysticallib.util.Util;
import epicsquid.roots.config.GeneralConfig;
import epicsquid.roots.init.ModBlocks;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.init.ModRecipes;
import epicsquid.roots.init.ModSounds;
import epicsquid.roots.network.fx.MessageGrowthCrafterVisualFX;
import epicsquid.roots.recipe.FeyCraftingRecipe;
import epicsquid.roots.tileentity.TileEntityFeyCrafter;
import epicsquid.roots.util.IngredientWithStack;
import epicsquid.roots.util.ItemHandlerUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityRunicCrafter
extends TileEntityFeyCrafter
implements ITickable {
    protected FeyCraftingRecipe currentRecipe;
    public ItemStackHandler pedestal = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileEntityRunicCrafter.this.func_70296_d();
            if (!((TileEntityRunicCrafter)TileEntityRunicCrafter.this).field_145850_b.field_72995_K) {
                TileEntityRunicCrafter.this.updatePacketViaState();
                TileEntityRunicCrafter.this.field_145850_b.func_175666_e(TileEntityRunicCrafter.this.field_174879_c, ModBlocks.runic_crafter);
            }
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            return 1;
        }
    };

    @Override
    public List<ItemStack> craft(EntityPlayer player) {
        FeyCraftingRecipe recipe = this.getRecipe();
        ItemStack result = ItemStack.field_190927_a;
        ArrayList<ItemStack> inputItems = new ArrayList<ItemStack>();
        if (recipe != null) {
            int i;
            for (i = 0; i < 5; ++i) {
                inputItems.add(this.inventory.extractItem(i, 1, true));
            }
            if (!recipe.matches(inputItems)) {
                return Collections.emptyList();
            }
            inputItems.clear();
            for (i = 0; i < 5; ++i) {
                inputItems.add(this.inventory.extractItem(i, 1, false));
            }
            for (ItemStack stack : recipe.transformIngredients(inputItems, this)) {
                ItemUtil.spawnItem((World)this.field_145850_b, (BlockPos)this.field_174879_c.func_177982_a(Util.rand.nextBoolean() ? -1 : 1, 1, Util.rand.nextBoolean() ? -1 : 1), (ItemStack)stack);
            }
            result = recipe.getResult().func_77946_l();
            if (!result.func_190926_b()) {
                recipe.postCraft(result, inputItems, player);
                this.lastRecipe = recipe;
            } else {
                this.lastRecipe = null;
                this.storedItems.clear();
            }
        }
        if (!result.func_190926_b()) {
            return Lists.newArrayList((Object[])new ItemStack[]{result});
        }
        return Collections.emptyList();
    }

    @Override
    public boolean activate(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        if (!this.hasValidGroveStone()) {
            player.func_145747_a(new TextComponentTranslation("roots.message.runic_crafter.no_grove", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW)));
            return true;
        }
        ItemStack heldItem = player.func_184586_b(hand);
        ItemStack pedestalItem = this.pedestal.getStackInSlot(0);
        if (!ModItems.knives.contains(heldItem.func_77973_b())) {
            boolean update = false;
            if (!pedestalItem.func_190926_b() && heldItem.func_190916_E() < heldItem.func_77976_d() && ItemUtil.equalWithoutSize((ItemStack)heldItem, (ItemStack)pedestalItem) || heldItem.func_190926_b()) {
                if (heldItem.func_190926_b()) {
                    player.func_184611_a(hand, pedestalItem);
                } else {
                    heldItem.func_190917_f(1);
                }
                this.pedestal.setStackInSlot(0, ItemStack.field_190927_a);
                this.countdown = -1;
                update = true;
            } else if (pedestalItem.func_190926_b()) {
                ItemStack pedestalStack = heldItem.func_77946_l();
                pedestalStack.func_190920_e(1);
                this.pedestal.setStackInSlot(0, pedestalStack);
                heldItem.func_190918_g(1);
                this.countdown = -1;
                update = true;
            }
            if (update) {
                this.currentRecipe = ModRecipes.getFeyCraftingRecipe(this.pedestal.getStackInSlot(0));
                this.updatePacketViaState();
            }
        } else {
            if (this.countdown != -1) {
                return true;
            }
            this.storedItems = this.craft(player);
            if (!this.storedItems.isEmpty()) {
                this.countdown = COUNTDOWN;
                MessageGrowthCrafterVisualFX packet = new MessageGrowthCrafterVisualFX(this.func_174877_v(), world.field_73011_w.getDimension());
                PacketHandler.sendToAllTracking((IMessage)packet, (TileEntity)this);
                world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), ModSounds.WHIRLWIND, SoundCategory.NEUTRAL, 0.6f, 1.0f);
            }
        }
        return true;
    }

    @Override
    @Nullable
    public FeyCraftingRecipe getRecipe() {
        ItemStack pedestalStack = this.pedestal.getStackInSlot(0);
        if (pedestalStack.func_190926_b()) {
            return null;
        }
        if (this.currentRecipe != null && ItemUtil.equalWithoutSize((ItemStack)this.currentRecipe.getResult(), (ItemStack)pedestalStack)) {
            return this.currentRecipe;
        }
        this.currentRecipe = ModRecipes.getFeyCraftingRecipe(pedestalStack);
        this.countdown = -1;
        return this.currentRecipe;
    }

    @Override
    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            if (!this.hasValidGroveStone()) {
                if (this.field_145850_b.func_82737_E() % 3L != 0L) {
                    ClientProxy.particleRenderer.spawnParticle(this.field_145850_b, ParticleLeaf.class, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.75, (double)this.field_174879_c.func_177952_p() + 0.5, (Util.rand.nextDouble() - 0.5) * 0.005, Util.rand.nextDouble() * 0.02 * 0.5, (Util.rand.nextDouble() - 0.5) * 0.005, new double[]{100.0, 0.8588235294117647, 0.058823529411764705, 0.058823529411764705, 1.0, 1.0, 1.0});
                }
            } else if (this.field_145850_b.func_82737_E() % 3L != 0L && this.getRecipe() != null) {
                ClientProxy.particleRenderer.spawnParticle(this.field_145850_b, ParticleLeaf.class, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.75, (double)this.field_174879_c.func_177952_p() + 0.5, (Util.rand.nextDouble() - 0.5) * 0.005, Util.rand.nextDouble() * 0.02 * 0.5, (Util.rand.nextDouble() - 0.5) * 0.005, new double[]{100.0, 0.5490196078431373 + (Util.rand.nextDouble() - 0.5) * 0.1, 0.20392156862745098, 0.9607843137254902, 1.0, 1.0, 1.0});
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.countdown > 0) {
                if (this.storedItems.isEmpty() || this.getRecipe() == null) {
                    this.countdown = -1;
                    this.updatePacketViaState();
                } else {
                    --this.countdown;
                }
            } else {
                this.countdown = -1;
                for (EnumFacing facing : EnumFacing.values()) {
                    IItemHandler cap;
                    TileEntity te;
                    if (facing == EnumFacing.DOWN) continue;
                    IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v().func_177972_a(facing));
                    if (GeneralConfig.getCrafterOutputIgnore().contains(state.func_177230_c()) || (te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(facing))) == null || (cap = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) == null) continue;
                    ArrayList<ItemStack> newItems = new ArrayList<ItemStack>();
                    for (ItemStack toPut : this.storedItems) {
                        ItemStack result = ItemHandlerHelper.insertItemStacked((IItemHandler)cap, (ItemStack)toPut, (boolean)false);
                        if (result.func_190926_b()) continue;
                        newItems.add(result);
                    }
                    this.storedItems = newItems;
                }
                for (ItemStack stack : this.storedItems) {
                    EntityItem item = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.1, (double)this.field_174879_c.func_177952_p() + 0.5, stack);
                    this.field_145850_b.func_72838_d((Entity)item);
                }
                this.storedItems.clear();
            }
            if (this.countdown == -1) {
                IItemHandler cap;
                TileEntity te;
                List<ItemStack> items = this.getContents();
                FeyCraftingRecipe recipe = this.getRecipe();
                if (!(recipe != null && (items.isEmpty() || items.size() == 5 && recipe.matches(items)) || (te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177977_b())) == null || (cap = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) == null)) {
                    for (int i = 0; i < this.inventory.getSlots(); ++i) {
                        ItemStack toPut = this.inventory.getStackInSlot(i);
                        this.inventory.setStackInSlot(i, ItemHandlerHelper.insertItemStacked((IItemHandler)cap, (ItemStack)toPut, (boolean)false));
                    }
                }
                if (recipe != null && !items.isEmpty() && (items.size() != 5 || recipe.matches(items))) {
                    return;
                }
                if (recipe != null) {
                    this.refillInventory();
                }
            }
        }
    }

    public void refillInventory() {
        FeyCraftingRecipe recipe = this.getRecipe();
        if (!this.field_145850_b.field_72995_K && recipe != null) {
            IItemHandler cap;
            TileEntity te;
            List<Ingredient> requirements = recipe.getIngredients();
            if (ItemHandlerUtil.isEmpty((IItemHandler)this.inventory) && (te = this.field_145850_b.func_175625_s(this.func_174877_v().func_177977_b())) != null && (cap = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) != null) {
                List<ItemStack> temp;
                Int2ObjectOpenHashMap slotsToIngredient = new Int2ObjectOpenHashMap();
                int amount = 0;
                block0: for (Ingredient ingredient : requirements) {
                    for (int i = 0; i < cap.getSlots(); ++i) {
                        ItemStack inSlot = cap.getStackInSlot(i);
                        if (!ingredient.apply(inSlot)) continue;
                        if (slotsToIngredient.containsKey(i)) {
                            if (inSlot.func_190916_E() <= ((IngredientWithStack)slotsToIngredient.get(i)).getCount()) continue;
                            ++amount;
                            ((IngredientWithStack)slotsToIngredient.get(i)).increment();
                            continue block0;
                        }
                        ++amount;
                        slotsToIngredient.put(i, (Object)new IngredientWithStack(ingredient, 1));
                        continue block0;
                    }
                }
                if (amount == 5 && (temp = ItemHandlerUtil.getItemsInSlots(cap, (Int2ObjectOpenHashMap<IngredientWithStack>)slotsToIngredient, true)).size() == 5) {
                    temp = ItemHandlerUtil.getItemsInSlots(cap, (Int2ObjectOpenHashMap<IngredientWithStack>)slotsToIngredient, false);
                    for (int i = 0; i < temp.size(); ++i) {
                        ItemStack stack = temp.get(i);
                        this.inventory.setStackInSlot(i, stack);
                    }
                    this.func_70296_d();
                    this.updatePacketViaState();
                }
            }
        }
    }

    @Override
    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        tag.func_74782_a("pedestal", (NBTBase)this.pedestal.serializeNBT());
        return tag;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.pedestal.deserializeNBT(tag.func_74775_l("pedestal"));
    }

    @Override
    public void breakBlock(World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, EntityPlayer player) {
        super.breakBlock(world, pos, state, player);
        if (!world.field_72995_K) {
            Util.spawnInventoryInWorld((World)world, (double)((double)this.func_174877_v().func_177958_n() + 0.5), (double)((double)this.func_174877_v().func_177956_o() + 0.5), (double)((double)this.func_174877_v().func_177952_p() + 0.5), (IItemHandler)this.pedestal);
        }
    }
}

