/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.tileentity;

import epicsquid.mysticallib.tile.TileBase;
import epicsquid.mysticallib.util.ItemUtil;
import epicsquid.mysticallib.util.Util;
import epicsquid.roots.init.ModBlocks;
import epicsquid.roots.init.ModItems;
import epicsquid.roots.init.ModRecipes;
import epicsquid.roots.init.ModSounds;
import epicsquid.roots.particle.ParticleUtil;
import epicsquid.roots.recipe.MortarRecipe;
import epicsquid.roots.spell.SpellBase;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityMortar
extends TileBase {
    public ItemStackHandler inventory = new ItemStackHandler(5){

        protected void onContentsChanged(int slot) {
            TileEntityMortar.this.func_70296_d();
            if (!((TileEntityMortar)TileEntityMortar.this).field_145850_b.field_72995_K) {
                TileEntityMortar.this.updatePacketViaState();
                TileEntityMortar.this.field_145850_b.func_175666_e(TileEntityMortar.this.field_174879_c, ModBlocks.mortar);
            }
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
            return 1;
        }
    };

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74782_a("handler", (NBTBase)this.inventory.serializeNBT());
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.deserializeNBT(tag.func_74775_l("handler"));
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing == EnumFacing.UP;
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing == EnumFacing.UP) {
            return (T)this.inventory;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean handleCraft(BlockPos crafterPos) {
        List<ItemStack> ingredients = this.getIngredients();
        SpellBase spell = ModRecipes.getSpellRecipe(ingredients);
        if (spell != null) {
            if (spell.isDisabled()) {
                return false;
            }
            if (this.field_145850_b.field_72995_K) {
                for (int i = 0; i < 8; ++i) {
                    int chance = Util.rand.nextInt(3);
                    if (chance == 0) {
                        ParticleUtil.spawnParticleSmoke(this.field_145850_b, (float)this.func_174877_v().func_177958_n() + 0.5f + 0.25f * (Util.rand.nextFloat() - 0.5f), (float)this.func_174877_v().func_177956_o() + 0.4375f + 0.125f * (Util.rand.nextFloat() - 0.5f), (float)this.func_174877_v().func_177952_p() + 0.5f + 0.25f * (Util.rand.nextFloat() - 0.5f), 0.0125f * (Util.rand.nextFloat() - 0.5f), 0.0125f * (Util.rand.nextFloat() - 0.5f), 0.0125f * (Util.rand.nextFloat() - 0.5f), spell.getRed1(), spell.getGreen1(), spell.getBlue1(), 0.25f, 1.5f, 24, false);
                        continue;
                    }
                    if (chance == 1) {
                        ParticleUtil.spawnParticleSmoke(this.field_145850_b, (float)this.func_174877_v().func_177958_n() + 0.5f + 0.25f * (Util.rand.nextFloat() - 0.5f), (float)this.func_174877_v().func_177956_o() + 0.4375f + 0.125f * (Util.rand.nextFloat() - 0.5f), (float)this.func_174877_v().func_177952_p() + 0.5f + 0.25f * (Util.rand.nextFloat() - 0.5f), 0.0125f * (Util.rand.nextFloat() - 0.5f), 0.0125f * (Util.rand.nextFloat() - 0.5f), 0.0125f * (Util.rand.nextFloat() - 0.5f), spell.getRed2(), spell.getGreen2(), spell.getBlue2(), 0.25f, 1.5f, 24, false);
                        continue;
                    }
                    if (chance != 2) continue;
                    ParticleUtil.spawnParticleSmoke(this.field_145850_b, (float)this.func_174877_v().func_177958_n() + 0.5f + 0.25f * (Util.rand.nextFloat() - 0.5f), (float)this.func_174877_v().func_177956_o() + 0.4375f + 0.125f * (Util.rand.nextFloat() - 0.5f), (float)this.func_174877_v().func_177952_p() + 0.5f + 0.25f * (Util.rand.nextFloat() - 0.5f), 0.0125f * (Util.rand.nextFloat() - 0.5f), 0.0125f * (Util.rand.nextFloat() - 0.5f), 0.0125f * (Util.rand.nextFloat() - 0.5f), 0.5f, 0.5f, 0.5f, 0.5f, 2.5f, 24, false);
                }
            }
            ItemStack dust = spell.getResult();
            if (!this.field_145850_b.field_72995_K) {
                ItemUtil.spawnItem((World)this.field_145850_b, (BlockPos)crafterPos.func_177982_a(0, 1, 0), (ItemStack)dust);
                this.field_145850_b.func_184133_a(null, crafterPos, ModSounds.Events.MORTAR_USE, SoundCategory.PLAYERS, 1.0f, 1.0f);
                this.func_70296_d();
                this.updatePacketViaState();
            }
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                items.add(this.inventory.extractItem(i, 1, false));
            }
            if (!this.field_145850_b.field_72995_K) {
                for (ItemStack stack : spell.recipe.transformIngredients(items, this)) {
                    ItemUtil.spawnItem((World)this.field_145850_b, (BlockPos)crafterPos.func_177982_a(0, 1, 0), (ItemStack)stack);
                }
            }
            return true;
        }
        MortarRecipe mortarRecipe = ModRecipes.getMortarRecipe(ingredients);
        if (mortarRecipe != null) {
            if (this.field_145850_b.field_72995_K) {
                for (int i = 0; i < 8; ++i) {
                    int chance = Util.rand.nextInt(3);
                    if (chance == 0) {
                        ParticleUtil.spawnParticleSmoke(this.field_145850_b, (float)this.func_174877_v().func_177958_n() + 0.5f + 0.25f * (Util.rand.nextFloat() - 0.5f), (float)this.func_174877_v().func_177956_o() + 0.4375f + 0.125f * (Util.rand.nextFloat() - 0.5f), (float)this.func_174877_v().func_177952_p() + 0.5f + 0.25f * (Util.rand.nextFloat() - 0.5f), 0.0125f * (Util.rand.nextFloat() - 0.5f), 0.0125f * (Util.rand.nextFloat() - 0.5f), 0.0125f * (Util.rand.nextFloat() - 0.5f), mortarRecipe.getR1(), mortarRecipe.getG1(), mortarRecipe.getB1(), 0.25f, 1.5f, 24, false);
                        continue;
                    }
                    if (chance == 1) {
                        ParticleUtil.spawnParticleSmoke(this.field_145850_b, (float)this.func_174877_v().func_177958_n() + 0.5f + 0.25f * (Util.rand.nextFloat() - 0.5f), (float)this.func_174877_v().func_177956_o() + 0.4375f + 0.125f * (Util.rand.nextFloat() - 0.5f), (float)this.func_174877_v().func_177952_p() + 0.5f + 0.25f * (Util.rand.nextFloat() - 0.5f), 0.0125f * (Util.rand.nextFloat() - 0.5f), 0.0125f * (Util.rand.nextFloat() - 0.5f), 0.0125f * (Util.rand.nextFloat() - 0.5f), mortarRecipe.getR2(), mortarRecipe.getG2(), mortarRecipe.getB2(), 0.25f, 1.5f, 24, false);
                        continue;
                    }
                    if (chance != 2) continue;
                    ParticleUtil.spawnParticleSmoke(this.field_145850_b, (float)this.func_174877_v().func_177958_n() + 0.5f + 0.25f * (Util.rand.nextFloat() - 0.5f), (float)this.func_174877_v().func_177956_o() + 0.4375f + 0.125f * (Util.rand.nextFloat() - 0.5f), (float)this.func_174877_v().func_177952_p() + 0.5f + 0.25f * (Util.rand.nextFloat() - 0.5f), 0.0125f * (Util.rand.nextFloat() - 0.5f), 0.0125f * (Util.rand.nextFloat() - 0.5f), 0.0125f * (Util.rand.nextFloat() - 0.5f), 0.5f, 0.5f, 0.5f, 0.5f, 2.5f, 24, false);
                }
            }
            if (!this.field_145850_b.field_72995_K) {
                ItemUtil.spawnItem((World)this.field_145850_b, (BlockPos)crafterPos.func_177982_a(0, 1, 0), (ItemStack)mortarRecipe.getResult().func_77946_l());
                this.field_145850_b.func_184133_a(null, crafterPos, ModSounds.Events.MORTAR_USE, SoundCategory.PLAYERS, 1.0f, 1.0f);
                this.func_70296_d();
                this.updatePacketViaState();
            }
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                items.add(this.inventory.extractItem(i, 1, false));
            }
            if (!this.field_145850_b.field_72995_K) {
                for (ItemStack stack : mortarRecipe.transformIngredients(items, this)) {
                    ItemUtil.spawnItem((World)this.field_145850_b, (BlockPos)crafterPos.func_177982_a(0, 1, 0), (ItemStack)stack);
                }
            }
            return true;
        }
        return false;
    }

    public List<ItemStack> getIngredients() {
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            ingredients.add(stack);
        }
        return ingredients;
    }

    public boolean activate(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState state, @Nonnull EntityPlayer player, @Nonnull EnumHand hand, @Nonnull EnumFacing side, float hitX, float hitY, float hitZ) {
        if (hand != EnumHand.MAIN_HAND) {
            return true;
        }
        ItemStack heldItem = player.func_184586_b(hand);
        ItemStack offHand = player.func_184592_cb();
        List<ItemStack> ingredients = this.getIngredients();
        if (!heldItem.func_190926_b()) {
            ItemStack slot0 = this.inventory.getStackInSlot(0);
            if (heldItem.func_77973_b() != ModItems.pestle && (ingredients.size() != 5 || offHand.func_77973_b() != ModItems.pestle)) {
                if (!slot0.func_190926_b() && slot0.func_77973_b() == ModItems.pestle) {
                    return true;
                }
                for (int i = 0; i < this.inventory.getSlots(); ++i) {
                    if (!this.inventory.getStackInSlot(i).func_190926_b()) continue;
                    ItemStack toInsert = heldItem.func_77946_l();
                    toInsert.func_190920_e(1);
                    ItemStack attemptedInsert = this.inventory.insertItem(i, toInsert, true);
                    if (!attemptedInsert.func_190926_b()) continue;
                    this.inventory.insertItem(i, toInsert, false);
                    player.func_184586_b(hand).func_190918_g(1);
                    if (player.func_184586_b(hand).func_190916_E() == 0) {
                        player.func_184611_a(hand, ItemStack.field_190927_a);
                    }
                    world.func_184133_a(null, this.func_174877_v(), ModSounds.Events.MORTAR_ADD_ITEM, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    this.func_70296_d();
                    this.updatePacketViaState();
                    return true;
                }
            } else {
                ItemStack mortar;
                if (ingredients.isEmpty() && (mortar = this.inventory.insertItem(0, heldItem, false)).func_190926_b()) {
                    player.func_184611_a(hand, ItemStack.field_190927_a);
                    this.func_70296_d();
                    world.func_184133_a(null, this.func_174877_v(), ModSounds.Events.MORTAR_ADD_ITEM, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    this.updatePacketViaState();
                    return true;
                }
                return this.handleCraft(player.func_180425_c());
            }
        }
        if (heldItem.func_190926_b() && !world.field_72995_K) {
            for (int i = this.inventory.getSlots() - 1; i >= 0; --i) {
                if (!this.dropItemInInventory(this.inventory, i)) continue;
                world.func_184133_a(null, this.func_174877_v(), ModSounds.Events.MORTAR_REMOVE_ITEM, SoundCategory.PLAYERS, 1.0f, 1.0f);
                return true;
            }
        }
        return !heldItem.func_190926_b();
    }

    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!world.field_72995_K) {
            Util.spawnInventoryInWorld((World)world, (double)((double)this.func_174877_v().func_177958_n() + 0.5), (double)((double)this.func_174877_v().func_177956_o() + 0.5), (double)((double)this.func_174877_v().func_177952_p() + 0.5), (IItemHandler)this.inventory);
        }
    }
}

